/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.ancientcurses.entity.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.turtleboi.ancientcurses.entity.CursedPortalEntity;
import net.turtleboi.ancientcurses.entity.client.CursedPortalModel;
import org.jetbrains.annotations.NotNull;

public class CursedPortalRenderer
extends EntityRenderer<CursedPortalEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("ancientcurses", "textures/entity/cursed_portal.png");
    private final CursedPortalModel<CursedPortalEntity> model;

    public CursedPortalRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
        this.model = new CursedPortalModel(pContext.m_174023_(CursedPortalModel.CURSED_PORTAL_LAYER));
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull CursedPortalEntity pEntity) {
        int textureIndex = pEntity.getTextureIndex();
        return new ResourceLocation("ancientcurses", "textures/entity/cursed_portal/cursed_portal" + textureIndex + ".png");
    }

    public void render(CursedPortalEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            double playerX = player.m_20185_();
            double playerZ = player.m_20189_();
            double entityX = entity.m_20185_();
            double entityZ = entity.m_20189_();
            double dirX = playerX - entityX;
            double dirZ = playerZ - entityZ;
            float yaw = (float)(Math.atan2(dirZ, dirX) * 57.29577951308232) - 90.0f;
            poseStack.m_85836_();
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-yaw));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.depthMask((boolean)false);
            VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110470_((ResourceLocation)this.getTextureLocation(entity)));
            this.model.m_7695_(poseStack, vertexConsumer, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 0.9f);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
            poseStack.m_85849_();
        }
        super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, bufferSource, light);
    }
}

