/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.ancientcurses.network.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.turtleboi.ancientcurses.client.PlayerClientData;

public class CameraShakeS2C {
    private final float intensity;
    private final int duration;

    public CameraShakeS2C(float intensity, int duration) {
        this.intensity = intensity;
        this.duration = duration;
    }

    public CameraShakeS2C(FriendlyByteBuf buf) {
        this.intensity = buf.readFloat();
        this.duration = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeFloat(this.intensity);
        buf.writeInt(this.duration);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            PlayerClientData.setCameraShakeIntensity(this.intensity);
            PlayerClientData.setCameraShakeDuration(this.duration);
        });
        context.setPacketHandled(true);
        return true;
    }
}

