/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.ancientcurses.network.packets;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.turtleboi.ancientcurses.entity.CursedPortalEntity;
import net.turtleboi.ancientcurses.network.ModNetworking;
import net.turtleboi.ancientcurses.network.packets.PortalOverlayPacketS2C;

public class PortalOverlayPacketC2S {
    private final float portalAlpha;

    public PortalOverlayPacketC2S(float portalAlpha) {
        this.portalAlpha = portalAlpha;
    }

    public PortalOverlayPacketC2S(FriendlyByteBuf buf) {
        this.portalAlpha = buf.readFloat();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeFloat(this.portalAlpha);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            List cursedPortalEntities;
            ServerPlayer player = context.getSender();
            if (player != null && (cursedPortalEntities = player.m_9236_().m_45976_(CursedPortalEntity.class, player.m_20191_().m_82400_(2.5))).isEmpty()) {
                float newAlpha = Math.max(0.0f, this.portalAlpha - 0.001f);
                ModNetworking.sendToPlayer(new PortalOverlayPacketS2C(newAlpha), player);
            }
        });
        context.setPacketHandled(true);
        return true;
    }
}

