/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.ancientcurses.network.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.turtleboi.ancientcurses.client.PlayerClientData;

public class VoidPacketS2C {
    private final boolean isVoid;
    private final int voidTimer;
    private final int voidTotalTime;

    public VoidPacketS2C(boolean isVoid, int voidTimer, int voidTotalTime) {
        this.isVoid = isVoid;
        this.voidTimer = voidTimer;
        this.voidTotalTime = voidTotalTime;
    }

    public VoidPacketS2C(FriendlyByteBuf buf) {
        this.isVoid = buf.readBoolean();
        this.voidTimer = buf.readInt();
        this.voidTotalTime = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.isVoid);
        buf.writeInt(this.voidTimer);
        buf.writeInt(this.voidTotalTime);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            PlayerClientData.setVoid(this.isVoid);
            PlayerClientData.setVoidTimer(this.voidTimer);
            PlayerClientData.setTotalVoidTime(this.voidTotalTime);
        });
        context.setPacketHandled(true);
        return true;
    }
}

