/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.ancientcurses.trials;

import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.turtleboi.ancientcurses.block.entity.CursedAltarBlockEntity;
import net.turtleboi.ancientcurses.entity.CursedPortalEntity;
import net.turtleboi.ancientcurses.network.ModNetworking;
import net.turtleboi.ancientcurses.network.packets.CameraShakeS2C;
import net.turtleboi.ancientcurses.network.packets.SyncTrialDataS2C;
import net.turtleboi.ancientcurses.trials.PlayerTrialData;
import net.turtleboi.ancientcurses.trials.Trial;

public class SurvivalTrial
implements Trial {
    private UUID playerUUID;
    private long elapsedTime;
    private long trialDuration;
    private CursedAltarBlockEntity altar;
    private MobEffect effect;
    private boolean completed;
    public static final String trialDurationTotal = "TrialDuration";
    public static final String trialDurationElapsed = "TrialElapsedTime";

    public SurvivalTrial(Player player, MobEffect effect, long trialDuration, CursedAltarBlockEntity altar) {
        this.playerUUID = player.m_20148_();
        this.altar = altar;
        this.effect = effect;
        this.trialDuration = trialDuration;
        this.elapsedTime = 0L;
        this.completed = false;
        PlayerTrialData.setCurseEffect(player, effect);
    }

    public SurvivalTrial(CursedAltarBlockEntity altar) {
        this.altar = altar;
        this.completed = false;
    }

    public boolean isTrialActive() {
        return this.altar.getPlayerTrial(this.playerUUID) != null;
    }

    @Override
    public void saveToNBT(CompoundTag tag) {
        tag.m_128362_("PlayerUUID", this.playerUUID);
        tag.m_128359_("Effect", Objects.requireNonNull(ForgeRegistries.MOB_EFFECTS.getKey((Object)this.effect)).toString());
        tag.m_128356_(trialDurationElapsed, this.elapsedTime);
        tag.m_128356_(trialDurationTotal, this.trialDuration);
        tag.m_128379_("Completed", this.completed);
    }

    @Override
    public void loadFromNBT(CompoundTag tag) {
        this.playerUUID = tag.m_128342_("PlayerUUID");
        String effectName = tag.m_128461_("Effect");
        this.effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(effectName));
        this.elapsedTime = tag.m_128454_(trialDurationElapsed);
        this.trialDuration = tag.m_128454_(trialDurationTotal);
        this.completed = tag.m_128471_("Completed");
    }

    @Override
    public String getType() {
        return "SurvivalTrial";
    }

    @Override
    public void setAltar(CursedAltarBlockEntity altar) {
        this.altar = altar;
    }

    @Override
    public MobEffect getEffect() {
        return this.effect;
    }

    public Player getPlayer() {
        Level level = this.altar.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return serverLevel.m_46003_(this.playerUUID);
        }
        return null;
    }

    @Override
    public boolean isTrialCompleted(Player player) {
        return this.elapsedTime >= this.trialDuration;
    }

    @Override
    public void onPlayerTick(Player player) {
        if (!this.isTrialActive()) {
            return;
        }
        this.trackProgress(player);
        if (this.isTrialCompleted(player)) {
            this.concludeTrial(player);
        }
    }

    @Override
    public void trackProgress(Player player) {
        if (player != null) {
            ++this.elapsedTime;
            float progressPercentage = Math.min((float)this.elapsedTime / (float)this.trialDuration, 1.0f);
            ModNetworking.sendToPlayer(new SyncTrialDataS2C("SurvivalTrial", "", 0, 0, this.elapsedTime, this.trialDuration, "", 0, 0), (ServerPlayer)player);
        }
    }

    @Override
    public void concludeTrial(Player player) {
        ModNetworking.sendToPlayer(new SyncTrialDataS2C("SurvivalTrial", "", 0, 0, this.trialDuration, this.trialDuration, "", 0, 0), (ServerPlayer)player);
        player.m_21195_(this.effect);
        PlayerTrialData.clearCurseEffect(player);
        ModNetworking.sendToPlayer(new CameraShakeS2C(0.125f, 1000), (ServerPlayer)player);
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_6263_(null, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), (SoundEvent)SoundEvents.f_12325_.get(), SoundSource.AMBIENT, 1.0f, 0.25f);
        }
        CursedPortalEntity.spawnPortalNearPlayer(player, this.altar.m_58899_(), this.altar.m_58904_(), (Object)this.altar);
        this.altar.setPlayerTrialCompleted(player);
        this.completed = true;
    }

    @Override
    public void onEntityKilled(Player player, Entity entity) {
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    @Override
    public void setCompleted(boolean completed) {
        this.completed = completed;
    }
}

