/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.ancientcurses.trials;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraftforge.registries.ForgeRegistries;

public class TrialRecord {
    private BlockPos altarPos;
    private String trialType;
    private boolean completed;
    private boolean rewardCollected;

    public TrialRecord(BlockPos altarPos, String trialType, boolean completed, boolean rewardCollected) {
        this.altarPos = altarPos;
        this.trialType = trialType;
        this.completed = completed;
        this.rewardCollected = rewardCollected;
    }

    public TrialRecord() {
    }

    public BlockPos getAltarPos() {
        return this.altarPos;
    }

    public void setAltarPos(BlockPos altarPos) {
        this.altarPos = altarPos;
    }

    public String getTrialType() {
        return this.trialType;
    }

    public void setTrialType(String trialType) {
        this.trialType = trialType;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
    }

    public boolean isRewardCollected() {
        return this.rewardCollected;
    }

    public void setRewardCollected(boolean rewardCollected) {
        this.rewardCollected = rewardCollected;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128356_("AltarPos", this.altarPos.m_121878_());
        tag.m_128359_("TrialType", this.trialType);
        tag.m_128379_("Completed", this.completed);
        tag.m_128379_("RewardCollected", this.rewardCollected);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.altarPos = BlockPos.m_122022_((long)tag.m_128454_("AltarPos"));
        this.trialType = tag.m_128461_("TrialType");
        this.completed = tag.m_128471_("Completed");
        this.rewardCollected = tag.m_128471_("RewardCollected");
    }

    public boolean isTrialType(String type) {
        return Objects.equals(this.trialType, type);
    }

    public MobEffect getTrialEffect() {
        return (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(this.trialType));
    }
}

