/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.ancientcurses.util;

import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;

public class AttributeModifierUtil {
    public static UUID generateUUIDFromName(String name) {
        return UUID.nameUUIDFromBytes(name.getBytes(StandardCharsets.UTF_8));
    }

    public static void applyPermanentModifier(Player player, Attribute attribute, String name, double value, AttributeModifier.Operation operation) {
        UUID uuid = AttributeModifierUtil.generateUUIDFromName(name);
        AttributeInstance attributeInstance = player.m_21051_(attribute);
        if (attributeInstance != null) {
            if (attributeInstance.m_22111_(uuid) != null) {
                attributeInstance.m_22120_(uuid);
            }
            attributeInstance.m_22125_(new AttributeModifier(uuid, name, value, operation));
        }
    }

    public static void applyTransientModifier(Player player, Attribute attribute, String name, double value, AttributeModifier.Operation operation) {
        UUID uuid = AttributeModifierUtil.generateUUIDFromName(name);
        AttributeInstance attributeInstance = player.m_21051_(attribute);
        if (attributeInstance != null) {
            if (attributeInstance.m_22111_(uuid) != null) {
                attributeInstance.m_22120_(uuid);
            }
            attributeInstance.m_22118_(new AttributeModifier(uuid, name, value, operation));
        }
    }

    public static void removeModifier(Player player, Attribute attribute, String name) {
        UUID uuid = AttributeModifierUtil.generateUUIDFromName(name);
        AttributeInstance attributeInstance = player.m_21051_(attribute);
        if (attributeInstance != null) {
            attributeInstance.m_22120_(uuid);
        }
    }

    public static void removeModifiersByPrefix(Player player, Attribute attribute, String prefix) {
        AttributeInstance attributeInstance = player.m_21051_(attribute);
        if (attributeInstance != null) {
            attributeInstance.m_22122_().stream().filter(modifier -> modifier.m_22214_().startsWith(prefix)).forEach(arg_0 -> ((AttributeInstance)attributeInstance).m_22130_(arg_0));
        }
    }
}

