/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.ancientcurses.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.turtleboi.ancientcurses.item.ModItems;

public class ItemValueMap {
    private static final Map<Item, Integer> ITEM_VALUE_MAP = new HashMap<Item, Integer>();
    private static final Map<Item, Integer> ITEM_VALUE_CACHE;
    private static final Set<Item> CURRENTLY_PROCESSING_ITEMS;

    public static int getItemValue(ItemStack itemStack, Level level) {
        Item item = itemStack.m_41720_();
        if (ITEM_VALUE_MAP.containsKey(item)) {
            int predefinedValue = ITEM_VALUE_MAP.get(item);
            return predefinedValue + ItemValueMap.calculateEnchantmentValue(itemStack);
        }
        int recipeValue = ItemValueMap.calculateValueFromRecipe(itemStack, level);
        int baseValue = ItemValueMap.getBaseValue(itemStack);
        int enchantmentValue = ItemValueMap.calculateEnchantmentValue(itemStack);
        return baseValue + recipeValue + enchantmentValue;
    }

    private static int calculateEnchantmentValue(ItemStack itemStack) {
        int enchantmentValue = 0;
        if (itemStack.m_41793_()) {
            Map enchantments = EnchantmentHelper.m_44831_((ItemStack)itemStack);
            for (Map.Entry entry : enchantments.entrySet()) {
                int level = (Integer)entry.getValue();
                enchantmentValue += level * 20;
            }
        }
        return enchantmentValue;
    }

    private static int calculateValueFromRecipe(ItemStack itemStack, Level level) {
        Item item = itemStack.m_41720_();
        if (CURRENTLY_PROCESSING_ITEMS.contains(item)) {
            return ITEM_VALUE_CACHE.getOrDefault(item, 1);
        }
        if (ITEM_VALUE_CACHE.containsKey(item)) {
            return ITEM_VALUE_CACHE.get(item);
        }
        CURRENTLY_PROCESSING_ITEMS.add(item);
        RecipeManager recipeManager = level.m_7465_();
        int totalValue = 0;
        totalValue += ItemValueMap.calculateCraftingRecipeValue(itemStack, level, recipeManager);
        totalValue += ItemValueMap.calculateSmithingRecipeValue(itemStack, level, recipeManager);
        totalValue = Math.max(totalValue, 1);
        ITEM_VALUE_CACHE.put(item, totalValue);
        CURRENTLY_PROCESSING_ITEMS.remove(item);
        return totalValue;
    }

    private static int calculateCraftingRecipeValue(ItemStack itemStack, Level level, RecipeManager recipeManager) {
        int totalValue = 0;
        for (CraftingRecipe recipe : recipeManager.m_44013_(RecipeType.f_44107_)) {
            if (!ItemStack.m_41656_((ItemStack)recipe.m_8043_(level.m_9598_()), (ItemStack)itemStack)) continue;
            int resultCount = recipe.m_8043_(level.m_9598_()).m_41613_();
            for (Ingredient ingredient : recipe.m_7527_()) {
                ItemStack[] matchingStacks = ingredient.m_43908_();
                if (matchingStacks.length <= 0) continue;
                totalValue += ItemValueMap.getItemValue(matchingStacks[0], level);
            }
            totalValue = totalValue / Math.max(resultCount, 1) + ItemValueMap.getBaseValue(itemStack);
        }
        return totalValue;
    }

    private static int calculateSmithingRecipeValue(ItemStack itemStack, Level level, RecipeManager recipeManager) {
        int totalValue = 0;
        for (SmithingRecipe recipe : recipeManager.m_44013_(RecipeType.f_44113_)) {
            if (!ItemStack.m_41656_((ItemStack)recipe.m_8043_(level.m_9598_()), (ItemStack)itemStack)) continue;
            ItemStack base = ItemValueMap.findMatchingItem(arg_0 -> ((SmithingRecipe)recipe).m_266343_(arg_0));
            ItemStack addition = ItemValueMap.findMatchingItem(arg_0 -> ((SmithingRecipe)recipe).m_266253_(arg_0));
            int baseValue = ItemValueMap.getItemValue(base, level);
            int additionValue = ItemValueMap.getItemValue(addition, level);
            totalValue += baseValue + additionValue + ItemValueMap.getBaseValue(itemStack);
        }
        return totalValue;
    }

    private static ItemStack findMatchingItem(Predicate<ItemStack> predicate) {
        for (Item item : ForgeRegistries.ITEMS) {
            ItemStack stack = new ItemStack((ItemLike)item);
            if (!predicate.test(stack)) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    private static int getBaseValue(ItemStack itemStack) {
        Rarity rarity = itemStack.m_41791_();
        if (rarity == Rarity.COMMON) {
            return 1;
        }
        if (rarity == Rarity.UNCOMMON) {
            return 20;
        }
        if (rarity == Rarity.RARE) {
            return 50;
        }
        if (rarity == Rarity.EPIC) {
            return 100;
        }
        if (rarity == ModItems.LEGENDARY) {
            return 500;
        }
        return 0;
    }

    static {
        ITEM_VALUE_MAP.put(Items.f_42416_, 10);
        ITEM_VALUE_MAP.put(Items.f_42417_, 33);
        ITEM_VALUE_MAP.put(Items.f_42451_, 25);
        ITEM_VALUE_MAP.put(Items.f_42534_, 25);
        ITEM_VALUE_MAP.put(Items.f_42415_, 50);
        ITEM_VALUE_MAP.put(Items.f_42616_, 75);
        ITEM_VALUE_MAP.put(Items.f_42792_, 33);
        ITEM_VALUE_MAP.put(Items.f_42419_, 33);
        ITEM_VALUE_MAP.put(Items.f_42418_, 264);
        ITEM_VALUE_MAP.put(Items.f_42791_, 2376);
        ITEM_VALUE_MAP.put(Items.f_42354_, 44);
        ITEM_VALUE_MAP.put(Items.f_42464_, 100);
        ITEM_VALUE_MAP.put(Items.f_42465_, 200);
        ITEM_VALUE_MAP.put(Items.f_42466_, 150);
        ITEM_VALUE_MAP.put(Items.f_42467_, 50);
        ITEM_VALUE_MAP.put(Items.f_42713_, 250);
        ITEM_VALUE_MAP.put(Items.f_42651_, 135);
        ITEM_VALUE_MAP.put(Items.f_42652_, 235);
        ITEM_VALUE_MAP.put(Items.f_42653_, 335);
        ITEM_VALUE_MAP.put(Items.f_42747_, 200);
        ITEM_VALUE_MAP.put(Items.f_42741_, 200);
        ITEM_VALUE_MAP.put(Items.f_42437_, 400);
        ITEM_VALUE_MAP.put(Items.f_42686_, 400);
        ITEM_VALUE_CACHE = new HashMap<Item, Integer>();
        CURRENTLY_PROCESSING_ITEMS = new HashSet<Item>();
    }
}

