/*
 * Decompiled with CFR 0.152.
 */
package net.asestefan.util_config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class UtilConfig {
    public static final Server SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final DataGen DATAGEN;
    public static final ForgeConfigSpec DATAGEN_SPEC;

    public static void loadConfig(ForgeConfigSpec config, String path) {
        CommentedFileConfig file = (CommentedFileConfig)CommentedFileConfig.builder((File)new File(path)).sync().autosave().writingMode(WritingMode.REPLACE).build();
        file.load();
        config.setConfig((CommentedConfig)file);
    }

    static {
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Server::new);
        SERVER = (Server)commonSpecPair.getLeft();
        SERVER_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
        Pair commonPair = new ForgeConfigSpec.Builder().configure(DataGen::new);
        DATAGEN = (DataGen)commonPair.getLeft();
        DATAGEN_SPEC = (ForgeConfigSpec)commonPair.getRight();
    }

    public static class Server {
        public final ForgeConfigSpec.ConfigValue<Integer> integer_ex;
        public final ForgeConfigSpec.ConfigValue<Long> long_ex;
        public final ForgeConfigSpec.ConfigValue<Byte> byte_ex;
        public final ForgeConfigSpec.ConfigValue<Double> double_ex;
        public final ForgeConfigSpec.ConfigValue<Boolean> boolean_ex;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> string_list_ex;

        public Server(ForgeConfigSpec.Builder builder) {
            builder.push("Examples");
            this.integer_ex = builder.comment("Default 3").define("Integer Example", (Object)3);
            this.long_ex = builder.comment("Default 20000").define("Long Example", (Object)20000L);
            this.byte_ex = builder.comment("Default 2").define("Byte Example", (Object)2);
            this.double_ex = builder.comment("Default 0.15").defineInRange("Double Example", 0.15, 0.0, 1.0);
            this.boolean_ex = builder.comment("Default true").define("Boolean Example", true);
            this.string_list_ex = builder.comment("Default minecraft:is_overworld").defineList("String List Example", (List)Lists.newArrayList((Object[])new String[]{"minecraft:is_overworld", ""}), o -> o instanceof String);
            builder.pop();
        }
    }

    public static class DataGen {
        public DataGen(ForgeConfigSpec.Builder builder) {
        }
    }
}

