/*
 * Decompiled with CFR 0.152.
 */
package net.asestefan.utils;

import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class QuaternionUtils {
    public static double magnificationToFovMultiplier(double magnification, double currentFov) {
        double currentTan = Math.tan(Math.toRadians(currentFov / 2.0));
        double newTan = currentTan / magnification;
        double newFov = Math.toDegrees(Math.atan(newTan)) * 2.0;
        return newFov / currentFov;
    }

    public static double fovToMagnification(double currentFov, double originFov) {
        return Math.tan(Math.toRadians(originFov / 2.0)) / Math.tan(Math.toRadians(currentFov / 2.0));
    }

    public static float[] toQuaternion(float roll, float pitch, float yaw) {
        double cy = Math.cos((double)yaw * 0.5);
        double sy = Math.sin((double)yaw * 0.5);
        double cp = Math.cos((double)pitch * 0.5);
        double sp = Math.sin((double)pitch * 0.5);
        double cr = Math.cos((double)roll * 0.5);
        double sr = Math.sin((double)roll * 0.5);
        return new float[]{(float)(cy * cp * sr - sy * sp * cr), (float)(sy * cp * sr + cy * sp * cr), (float)(sy * cp * cr - cy * sp * sr), (float)(cy * cp * cr + sy * sp * sr)};
    }

    public static Quaternionf slerp(Quaternionf from, Quaternionf to, float alpha) {
        float s1;
        float s0;
        float epsilon;
        float bw;
        float bz;
        float by;
        float ax = from.x();
        float ay = from.y();
        float az = from.z();
        float aw = from.w();
        float bx = to.x();
        float dot = ax * bx + ay * (by = to.y()) + az * (bz = to.z()) + aw * (bw = to.w());
        if (dot < 0.0f) {
            bx = -bx;
            by = -by;
            bz = -bz;
            bw = -bw;
            dot = -dot;
        }
        if (1.0 - (double)dot > (double)(epsilon = 1.0E-6f)) {
            float omega = (float)Math.acos(dot);
            float invSinOmega = 1.0f / (float)Math.sin(omega);
            s0 = (float)Math.sin((1.0 - (double)alpha) * (double)omega) * invSinOmega;
            s1 = (float)Math.sin(alpha * omega) * invSinOmega;
        } else {
            s0 = 1.0f - alpha;
            s1 = alpha;
        }
        float rx = s0 * ax + s1 * bx;
        float ry = s0 * ay + s1 * by;
        float rz = s0 * az + s1 * bz;
        float rw = s0 * aw + s1 * bw;
        return new Quaternionf(rx, ry, rz, rw);
    }

    public static Vector3f getEulerAngles(Matrix4f matrix) {
        double z;
        double y;
        double x;
        boolean singular;
        double sy = Math.sqrt(matrix.m00() * matrix.m00() + matrix.m10() * matrix.m10());
        boolean bl = singular = sy < 1.0E-6;
        if (!singular) {
            x = Math.atan2(matrix.m21(), matrix.m22());
            y = Math.atan2(-matrix.m20(), sy);
            z = Math.atan2(matrix.m10(), matrix.m00());
        } else {
            x = Math.atan2(-matrix.m12(), matrix.m11());
            y = Math.atan2(-matrix.m20(), sy);
            z = 0.0;
        }
        return new Vector3f((float)x, (float)y, (float)z);
    }
}

