/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.blocks.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.teamabyssalofficial.blocks.scratch.TickableBlockEntity;
import net.teamabyssalofficial.registry.BlockEntityRegistry;
import net.teamabyssalofficial.registry.EffectRegistry;
import net.teamabyssalofficial.registry.EntityRegistry;
import net.teamabyssalofficial.registry.ParticleRegistry;
import net.teamabyssalofficial.registry.SoundRegistry;

public class ToxicPuddleEntity
extends BlockEntity
implements TickableBlockEntity {
    private int ticks;

    public ToxicPuddleEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.TOXIC_PUDDLE.get(), pos, state);
    }

    @Override
    public void tick() {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        this.animateTick(this.f_58858_, this.f_58857_);
        ++this.ticks;
        if (Math.random() <= (double)0.05f && this.ticks > 1600 || this.f_58857_.m_46758_(this.m_58899_())) {
            this.f_58857_.m_7471_(this.m_58899_(), false);
        }
    }

    private void animateTick(BlockPos initPos, Level level) {
        BlockPos blockpos = initPos.m_7494_();
        if (level.m_8055_(blockpos).m_60795_() && !level.m_8055_(blockpos).m_60804_((BlockGetter)level, blockpos) && level.m_213780_().m_188503_(100) == 0) {
            double d0 = (double)initPos.m_123341_() + level.m_213780_().m_188500_();
            double d1 = (double)initPos.m_123342_() + 1.0;
            double d2 = (double)initPos.m_123343_() + level.m_213780_().m_188500_();
            if (level instanceof ServerLevel) {
                ServerLevel world = (ServerLevel)level;
                world.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.TOXIC_PARTICLE.get()), d0, d1, d2, 30, 0.0, 0.0, 0.0, 0.0);
                level.m_5594_(null, initPos, (SoundEvent)SoundRegistry.TOXIC_PUDDLE_SIZZLE.get(), SoundSource.BLOCKS, 0.2f + level.m_213780_().m_188501_() * 0.2f, 0.9f + level.m_213780_().m_188501_() * 0.15f);
            }
        }
    }

    public void onTouch(LivingEntity livingEntity, Level level) {
        if (!level.m_5776_() && !EntityRegistry.FLOOD_FORMS.contains(livingEntity)) {
            if (!livingEntity.m_21023_((MobEffect)EffectRegistry.ACID_BURNS.get())) {
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.ACID_BURNS.get(), 200, 1));
            }
            if (!livingEntity.m_21023_(MobEffects.f_19614_)) {
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200, 1));
            }
            if (!livingEntity.m_21023_(MobEffects.f_19613_)) {
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 200, 1));
            }
        }
    }
}

