/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;
import net.teamabyssalofficial.client.model.MawClawModel;
import net.teamabyssalofficial.client.special.GeckoBedrockCurves;
import net.teamabyssalofficial.entity.custom.special.MawClawEntity;
import net.teamabyssalofficial.impl.StackScaler;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class MawClawRenderer
extends GeoEntityRenderer<MawClawEntity> {
    public MawClawRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (GeoModel)new MawClawModel());
        this.f_114477_ = 0.0f;
    }

    public void preRender(PoseStack poseStack, MawClawEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (!isReRender && animatable.getBurrowDepth() != 0.0f && animatable.getBurrowProgress() > 0) {
            poseStack.m_252880_(0.0f, animatable.getBurrowDepth() * -this.getDepth(animatable, partialTick), 0.0f);
        }
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    private float getDepth(MawClawEntity animatable, float partialTick) {
        float burrowProgress = (float)GeckoBedrockCurves.bezier(animatable.prevClientBurrowProgress, animatable.clientBurrowProgress, partialTick);
        float f = 0.0f;
        if (animatable.isBurrowing()) {
            f = burrowProgress / 50.0f;
        } else if (animatable.isUnderground()) {
            f = 1.0f;
        } else if (animatable.isEmerging()) {
            f = 1.0f - (burrowProgress - 50.0f - 60.0f) / 50.0f;
        }
        return f;
    }

    public void render(MawClawEntity entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource bufferIn, int packedLightIn) {
        stack.m_85836_();
        stack.m_85841_(0.7f, 0.7f, 0.7f);
        StackScaler scaler = entity.stackScaler;
        stack.m_85841_(scaler.getpX(), scaler.getpY(), scaler.getpZ());
        super.m_7392_((Entity)entity, entityYaw, partialTicks, stack, bufferIn, packedLightIn);
        stack.m_85849_();
    }
}

