/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;
import net.teamabyssalofficial.client.model.MawFormModel;
import net.teamabyssalofficial.client.renderer.layer.MawFormLayerRenderer;
import net.teamabyssalofficial.client.special.GeckoBedrockCurves;
import net.teamabyssalofficial.entity.custom.MawFormEntity;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;

public class MawFormRenderer
extends GeoEntityRenderer<MawFormEntity> {
    public MawFormRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (GeoModel)new MawFormModel());
        this.f_114477_ = 0.0f;
        this.addRenderLayer(new MawFormLayerRenderer((GeoRenderer<MawFormEntity>)this));
    }

    public void preRender(PoseStack poseStack, MawFormEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (!isReRender && animatable.getBurrowDepth() != 0.0f && animatable.getBurrowProgress() > 0) {
            poseStack.m_252880_(0.0f, animatable.getBurrowDepth() * -this.getDepth(animatable, partialTick), 0.0f);
        }
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    private float getDepth(MawFormEntity animatable, float partialTick) {
        float burrowProgress = (float)GeckoBedrockCurves.bezier(animatable.prevClientBurrowProgress, animatable.clientBurrowProgress, partialTick);
        float f = 0.0f;
        if (animatable.isBurrowing()) {
            f = burrowProgress / 500.0f;
        } else if (animatable.isUnderground()) {
            f = 1.0f;
        } else if (animatable.isEmerging()) {
            f = 0.8f - (burrowProgress - 500.0f - 100.0f) / 90.0f;
        }
        return f + 0.6f;
    }

    public void render(MawFormEntity entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource bufferIn, int packedLightIn) {
        stack.m_85836_();
        stack.m_85841_(0.7f, 0.7f, 0.7f);
        stack.m_85841_(entity.stackScale(), entity.stackScale(), entity.stackScale());
        super.m_7392_((Entity)entity, entityYaw, partialTicks, stack, bufferIn, packedLightIn);
        stack.m_85849_();
    }
}

