/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.client.special;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.world.phys.Vec3;
import net.teamabyssalofficial.client.special.model.OptimizedGeoBone;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.cache.object.GeoQuad;
import software.bernie.geckolib.loading.json.raw.Bone;
import software.bernie.geckolib.loading.json.raw.Cube;
import software.bernie.geckolib.loading.json.raw.ModelProperties;
import software.bernie.geckolib.loading.object.BakedModelFactory;
import software.bernie.geckolib.loading.object.BoneStructure;
import software.bernie.geckolib.loading.object.GeometryTree;
import software.bernie.geckolib.util.RenderUtils;

public class GeckoDawnFactory
implements BakedModelFactory {
    public BakedGeoModel constructGeoModel(GeometryTree geometryTree) {
        ObjectArrayList bones = new ObjectArrayList();
        for (BoneStructure boneStructure : geometryTree.topLevelBones().values()) {
            bones.add(this.constructBone(boneStructure, geometryTree.properties(), null));
        }
        return new BakedGeoModel((List)bones, geometryTree.properties());
    }

    public GeoBone constructBone(BoneStructure boneStructure, ModelProperties properties, @Nullable GeoBone parent) {
        Bone bone = boneStructure.self();
        OptimizedGeoBone newBone = new OptimizedGeoBone(parent, bone.name(), bone.mirror(), bone.inflate(), bone.neverRender(), bone.reset());
        Vec3 rotation = RenderUtils.arrayToVec((double[])bone.rotation());
        Vec3 pivot = RenderUtils.arrayToVec((double[])bone.pivot());
        newBone.updateRotation((float)Math.toRadians(-rotation.f_82479_), (float)Math.toRadians(-rotation.f_82480_), (float)Math.toRadians(rotation.f_82481_));
        newBone.updatePivot((float)(-pivot.f_82479_), (float)pivot.f_82480_, (float)pivot.f_82481_);
        for (Cube cube : bone.cubes()) {
            newBone.getCubes().add(this.constructCube(cube, properties, newBone));
        }
        for (BoneStructure child : boneStructure.children().values()) {
            newBone.getChildBones().add(this.constructBone(child, properties, newBone));
        }
        return newBone;
    }

    public GeoCube constructCube(Cube cube, ModelProperties properties, GeoBone bone) {
        boolean mirror;
        boolean bl = mirror = cube.mirror() == Boolean.TRUE;
        double inflate = cube.inflate() != null ? cube.inflate() / 16.0 : (bone.getInflate() == null ? 0.0 : bone.getInflate() / 16.0);
        Vec3 size = RenderUtils.arrayToVec((double[])cube.size());
        Vec3 origin = RenderUtils.arrayToVec((double[])cube.origin());
        Vec3 rotation = RenderUtils.arrayToVec((double[])cube.rotation());
        Vec3 pivot = RenderUtils.arrayToVec((double[])cube.pivot());
        origin = new Vec3(-(origin.f_82479_ + size.f_82479_) / 16.0, origin.f_82480_ / 16.0, origin.f_82481_ / 16.0);
        Vec3 vertexSize = size.m_82542_(0.0625, 0.0625, 0.0625);
        pivot = pivot.m_82542_(-1.0, 1.0, 1.0);
        rotation = new Vec3(Math.toRadians(-rotation.f_82479_), Math.toRadians(-rotation.f_82480_), Math.toRadians(rotation.f_82481_));
        GeoQuad[] quads = this.buildQuads(cube.uv(), new BakedModelFactory.VertexSet(origin, vertexSize, inflate), cube, (float)properties.textureWidth(), (float)properties.textureHeight(), mirror);
        return new GeoCube(quads, pivot, rotation, size, inflate, mirror);
    }
}

