/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.client.special;

public class GeckoEasingCurves {
    public static double easeIn(double start, double end, double t) {
        return start + (end - start) * t * t;
    }

    public static double easeOut(double start, double end, double t) {
        return start + (end - start) * (1.0 - Math.pow(1.0 - t, 2.0));
    }

    public static double easeInOut(double start, double end, double t) {
        return t < 0.5 ? GeckoEasingCurves.easeIn(start, end / 2.0, t * 2.0) : GeckoEasingCurves.easeOut(start + end / 2.0, end, (t - 0.5) * 2.0);
    }

    public static double easeOutIn(double start, double end, double t) {
        return t < 0.5 ? GeckoEasingCurves.easeOut(start, end / 2.0, t * 2.0) : GeckoEasingCurves.easeIn(start + end / 2.0, end, (t - 0.5) * 2.0);
    }

    public static double easeInCircle(double start, double end, double t) {
        return start + (end - start) * (1.0 - Math.sqrt(1.0 - t * t));
    }

    public static double easyEase(double start, double end, double t) {
        return start + (end - start) * (t < 0.5 ? 2.0 * t * t : -1.0 + 2.0 * t * (2.0 - t));
    }

    public static double easeInSine(double start, double end, double t) {
        return (end - start) * (1.0 - Math.cos((float)(t * Math.PI / 2.0))) + start;
    }

    public static double easeInCubic(double start, double end, double t) {
        return (end - start) * (t * t * t) + start;
    }

    public static double easeInQuint(double start, double end, double t) {
        return (end - start) * (t * t * t * t * t) + start;
    }

    public static double easeInElastic(double start, double end, double t) {
        if (t == 0.0) {
            return start;
        }
        if (t == 1.0) {
            return end;
        }
        double c4 = 2.0943951023931953;
        return start - Math.pow(2.0, 10.0 * t - 10.0) * Math.sin((float)((t * 10.0 - 10.75) * c4)) * (end - start);
    }

    public static double easeOutSine(double start, double end, double t) {
        return (end - start) * Math.sin((float)(t * Math.PI / 2.0)) + start;
    }

    public static double easeOutCubic(double start, double end, double t) {
        return (end - start) * (1.0 - Math.pow(1.0 - t, 3.0)) + start;
    }

    public static double easeOutQuint(double start, double end, double t) {
        return (end - start) * (1.0 - Math.pow(1.0 - t, 5.0)) + start;
    }

    public static double easeOutCircle(double start, double end, double t) {
        return (end - start) * Math.sqrt(1.0 - Math.pow(t - 1.0, 2.0)) + start;
    }

    public static double easeOutElastic(double start, double end, double t) {
        if (t == 0.0) {
            return start;
        }
        if (t == 1.0) {
            return end;
        }
        return (end - start) * (Math.pow(2.0, -10.0 * t) * Math.sin((float)((t * 10.0 - 0.75) * 2.0943951023931953)) + 1.0) + start;
    }

    public static double easeInOutSine(double start, double end, double t) {
        return (end - start) * (-(Math.cos((float)(Math.PI * t)) - 1.0) / 2.0) + start;
    }

    public static double easeInOutCubic(double start, double end, double t) {
        if (t < 0.5) {
            return (end - start) * (4.0 * t * t * t) + start;
        }
        return (end - start) * (1.0 - Math.pow(-2.0 * t + 2.0, 3.0) / 2.0) + start;
    }

    public static double easeInOutQuint(double start, double end, double t) {
        if (t < 0.5) {
            return (end - start) * (16.0 * Math.pow(t, 5.0)) + start;
        }
        return (end - start) * (1.0 - Math.pow(-2.0 * t + 2.0, 5.0) / 2.0) + start;
    }

    public static double easeInOutCircle(double start, double end, double t) {
        if (t < 0.5) {
            return start + (end - start) * (1.0 - Math.sqrt(1.0 - Math.pow(2.0 * t, 2.0))) / 2.0;
        }
        return start + (end - start) * (Math.sqrt(1.0 - Math.pow(-2.0 * t + 2.0, 2.0)) + 1.0) / 2.0;
    }

    public static double easeInOutElastic(double start, double end, double t) {
        if (t == 0.0) {
            return start;
        }
        if (t == 1.0) {
            return end;
        }
        double c5 = 1.3962634015954636;
        if (t < 0.5) {
            return start - Math.pow(2.0, 20.0 * t - 10.0) * Math.sin((float)((20.0 * t - 11.125) * c5)) / 2.0;
        }
        return start + Math.pow(2.0, -20.0 * t + 10.0) * Math.sin((float)((20.0 * t - 11.125) * c5)) / 2.0 + (end - start);
    }

    public static double easeInQuad(double start, double end, double t) {
        return (end - start) * (t * t) + start;
    }

    public static double easeInQuart(double start, double end, double t) {
        return (end - start) * (t * t * t * t) + start;
    }

    public static double easeInExpo(double start, double end, double t) {
        if (t == 0.0) {
            return start;
        }
        return (end - start) * Math.pow(2.0, 10.0 * t - 10.0) + start;
    }

    public static double easeInBack(double start, double end, double t) {
        double c1 = 1.70158;
        double c3 = 2.70158;
        return (end - start) * (2.70158 * t * t * t - 1.70158 * t * t) + start;
    }

    public static double easeInBounce(double start, double end, double t) {
        return start + (end - start) * (1.0 - GeckoEasingCurves.easeOutBounce(0.0, 1.0, 1.0 - t));
    }

    public static double easeOutBounce(double start, double end, double t) {
        double n1 = 7.5625;
        double d1 = 2.75;
        double value = t < 0.36363636363636365 ? 7.5625 * t * t : (t < 0.7272727272727273 ? 7.5625 * (t -= 0.5454545454545454) * t + 0.75 : (t < 0.9090909090909091 ? 7.5625 * (t -= 0.8181818181818182) * t + 0.9375 : 7.5625 * (t -= 0.9545454545454546) * t + 0.984375));
        return start + (end - start) * value;
    }

    public static double easeOutQuad(double start, double end, double t) {
        return start + (end - start) * (1.0 - Math.pow(1.0 - t, 2.0));
    }

    public static double easeOutQuart(double start, double end, double t) {
        return start + (end - start) * (1.0 - Math.pow(1.0 - t, 4.0));
    }

    public static double easeOutExpo(double start, double end, double t) {
        if (t == 1.0) {
            return end;
        }
        return start + (end - start) * (1.0 - Math.pow(2.0, -10.0 * t));
    }

    public static double easeOutBack(double start, double end, double t) {
        double c1 = 1.70158;
        double c3 = 2.70158;
        double adjustedT = t - 1.0;
        return start + (end - start) * (1.0 + 2.70158 * Math.pow(adjustedT, 3.0) + 1.70158 * Math.pow(adjustedT, 2.0));
    }

    public static double easeInOutQuad(double start, double end, double t) {
        if (t < 0.5) {
            return start + (end - start) * (2.0 * t * t);
        }
        return start + (end - start) * (1.0 - Math.pow(-2.0 * t + 2.0, 2.0) / 2.0);
    }

    public static double easeInOutQuart(double start, double end, double t) {
        if (t < 0.5) {
            return start + (end - start) * (8.0 * Math.pow(t, 4.0));
        }
        return start + (end - start) * (1.0 - Math.pow(-2.0 * t + 2.0, 4.0) / 2.0);
    }

    public static double easeInOutExpo(double start, double end, double t) {
        if (t == 0.0) {
            return start;
        }
        if (t == 1.0) {
            return end;
        }
        if (t < 0.5) {
            return start + (end - start) * (Math.pow(2.0, 20.0 * t - 10.0) / 2.0);
        }
        return start + (end - start) * ((2.0 - Math.pow(2.0, -20.0 * t + 10.0)) / 2.0);
    }

    public static double easeInOutBack(double start, double end, double t) {
        double c1 = 1.70158;
        double c2 = 2.5949095;
        if (t < 0.5) {
            return start + Math.pow(2.0 * t, 2.0) * (7.189819 * t - 2.5949095) / 2.0 * (end - start);
        }
        return start + (Math.pow(2.0 * t - 2.0, 2.0) * (3.5949095 * (2.0 * t - 2.0) + 2.5949095) + 2.0) / 2.0 * (end - start);
    }

    public static double easeInOutBounce(double start, double end, double t) {
        if (t < 0.5) {
            return start + (end - start) * (1.0 - GeckoEasingCurves.easeOutBounce(0.0, 1.0, 1.0 - 2.0 * t)) / 2.0;
        }
        return start + (end - start) * (1.0 + GeckoEasingCurves.easeOutBounce(0.0, 1.0, 2.0 * t - 1.0)) / 2.0;
    }
}

