/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.client.special.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.teamabyssalofficial.client.special.GeckoAnimationLibrary;
import net.teamabyssalofficial.client.special.model.GeckoClassModel;
import net.teamabyssalofficial.client.special.model.OptimizedGeoBone;
import net.teamabyssalofficial.client.special.player.GeckoPlayer;
import net.teamabyssalofficial.guns.gun.GunItem;
import software.bernie.geckolib.cache.object.GeoBone;

@OnlyIn(value=Dist.CLIENT)
public class GeckoBipedModel
extends GeckoClassModel<GeckoPlayer> {
    private ResourceLocation textureLocation;
    public boolean isSitting = false;
    public boolean isChild = true;
    public float swingProgress;
    public boolean isSneak;
    public float swimAnimation;
    public HumanoidModel.ArmPose leftArmPose = HumanoidModel.ArmPose.EMPTY;
    public HumanoidModel.ArmPose rightArmPose = HumanoidModel.ArmPose.EMPTY;
    protected boolean useSmallArms = false;

    public ResourceLocation getAnimationResource(GeckoPlayer animatable) {
        return new ResourceLocation("dotf", "animations/animated_player.animation.json");
    }

    public ResourceLocation getModelResource(GeckoPlayer animatable) {
        return new ResourceLocation("dotf", "geo/animated_player.geo.json");
    }

    public ResourceLocation getTextureResource(GeckoPlayer animatable) {
        return this.textureLocation;
    }

    public void setTextureFromPlayer(AbstractClientPlayer player) {
        this.textureLocation = player.m_108560_();
    }

    public void setUseSmallArms(boolean useSmallArms) {
        this.useSmallArms = useSmallArms;
    }

    public boolean isUsingSmallArms() {
        return this.useSmallArms;
    }

    public OptimizedGeoBone bipedHead() {
        return this.getOptimizedBone("Head");
    }

    public OptimizedGeoBone bipedHeadwear() {
        return this.getOptimizedBone("HatLayer");
    }

    public OptimizedGeoBone bipedBody() {
        return this.getOptimizedBone("Body");
    }

    public OptimizedGeoBone bipedRightArm() {
        return this.getOptimizedBone("RightArm");
    }

    public OptimizedGeoBone bipedLeftArm() {
        return this.getOptimizedBone("LeftArm");
    }

    public OptimizedGeoBone bipedRightLeg() {
        return this.getOptimizedBone("RightLeg");
    }

    public OptimizedGeoBone bipedLeftLeg() {
        return this.getOptimizedBone("LeftLeg");
    }

    public void setVisible(boolean visible) {
        this.bipedHead().setHidden(!visible);
        this.bipedHeadwear().setHidden(!visible);
        this.bipedBody().setHidden(!visible);
        this.bipedRightArm().setHidden(!visible);
        this.bipedLeftArm().setHidden(!visible);
        this.bipedRightLeg().setHidden(!visible);
        this.bipedLeftLeg().setHidden(!visible);
    }

    public void setRotationAngles() {
        OptimizedGeoBone head = this.getOptimizedBone("Head");
        OptimizedGeoBone neck = this.getOptimizedBone("Neck");
        float yaw = 0.0f;
        float pitch = 0.0f;
        float roll = 0.0f;
        for (OptimizedGeoBone parent = neck.getParent(); parent != null; parent = parent.getParent()) {
            pitch += parent.getRotX();
            yaw += parent.getRotY();
            roll += parent.getRotZ();
        }
        neck.addRot(-yaw, -pitch, -roll);
    }

    public void setRotationAngles(Player entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float partialTick) {
        boolean flag3;
        if (!this.isInitialized()) {
            return;
        }
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        OptimizedGeoBone rightArmClassic = this.getOptimizedBone("RightArmClassic");
        OptimizedGeoBone leftArmClassic = this.getOptimizedBone("LeftArmClassic");
        OptimizedGeoBone rightArmSlim = this.getOptimizedBone("RightArmSlim");
        OptimizedGeoBone leftArmSlim = this.getOptimizedBone("LeftArmSlim");
        if (this.useSmallArms) {
            rightArmClassic.setHidden(true);
            leftArmClassic.setHidden(true);
            rightArmSlim.setHidden(false);
            leftArmSlim.setHidden(false);
        } else {
            rightArmSlim.setHidden(true);
            leftArmSlim.setHidden(true);
            rightArmClassic.setHidden(false);
            leftArmClassic.setHidden(false);
        }
        this.swimAnimation = entityIn.m_20998_(partialTick);
        float headLookAmount = this.getControllerValueInverted("HeadLookController");
        float armLookAmount = 1.0f - this.getControllerValueInverted("ArmPitchController");
        float armLookAmountRight = ((GeoBone)this.getBone("ArmPitchController").get()).getPosY();
        float armLookAmountLeft = ((GeoBone)this.getBone("ArmPitchController").get()).getPosZ();
        boolean flag = entityIn.m_21256_() > 4;
        boolean flag1 = entityIn.m_6067_();
        this.bipedHead().addRotY(headLookAmount * -netHeadYaw * ((float)Math.PI / 180));
        this.getOptimizedBone("LeftClavicle").addRotY(Math.min(armLookAmount + armLookAmountLeft, 1.0f) * -netHeadYaw * ((float)Math.PI / 180));
        this.getOptimizedBone("RightClavicle").addRotY(Math.min(armLookAmount + armLookAmountRight, 1.0f) * -netHeadYaw * ((float)Math.PI / 180));
        if (flag) {
            this.bipedHead().addRotX(-0.7853982f);
        } else if (this.swimAnimation > 0.0f) {
            if (flag1) {
                this.bipedHead().addRotX(headLookAmount * -this.rotLerpRad(this.swimAnimation, this.bipedHead().getRotX(), -0.7853982f));
            } else {
                this.bipedHead().addRotX(headLookAmount * -this.rotLerpRad(this.swimAnimation, this.bipedHead().getRotX(), headPitch * ((float)Math.PI / 180)));
            }
        } else {
            this.bipedHead().addRotX(headLookAmount * -headPitch * ((float)Math.PI / 180));
            this.getOptimizedBone("LeftClavicle").addRotX(Math.min(armLookAmount + armLookAmountLeft, 1.0f) * -headPitch * ((float)Math.PI / 180));
            this.getOptimizedBone("RightClavicle").addRotX(Math.min(armLookAmount + armLookAmountRight, 1.0f) * -headPitch * ((float)Math.PI / 180));
        }
        float f = 1.0f;
        if (flag) {
            f = (float)entityIn.m_20184_().m_82556_();
            f /= 0.2f;
            f = f * f * f;
        }
        if (f < 1.0f) {
            f = 1.0f;
        }
        float legWalkAmount = this.getControllerValueInverted("LegWalkController");
        float armSwingAmount = this.getControllerValueInverted("ArmSwingController");
        float armSwingAmountRight = 1.0f - ((GeoBone)this.getBone("ArmSwingController").get()).getPosY();
        float armSwingAmountLeft = 1.0f - ((GeoBone)this.getBone("ArmSwingController").get()).getPosZ();
        float gunAmount = entityIn.m_21205_().m_41720_() instanceof GunItem ? 0.2f : 1.0f;
        this.bipedRightArm().addRotX(armSwingAmount * gunAmount * armSwingAmountRight * Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f / f);
        this.bipedLeftArm().addRotX(armSwingAmount * gunAmount * armSwingAmountLeft * Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f / f);
        this.bipedRightLeg().addRotX(legWalkAmount * Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount / f);
        this.bipedLeftLeg().addRotX(legWalkAmount * Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount / f);
        if (this.isSitting) {
            this.bipedRightArm().setRotX(this.bipedRightArm().getRotX() + -0.62831855f);
            this.bipedLeftArm().setRotX(this.bipedRightArm().getRotX() + -0.62831855f);
            this.bipedRightLeg().setRotX(-1.4137167f);
            this.bipedRightLeg().setRotY(0.31415927f);
            this.bipedRightLeg().setRotZ(0.07853982f);
            this.bipedLeftLeg().setRotX(-1.4137167f);
            this.bipedLeftLeg().setRotY(-0.31415927f);
            this.bipedLeftLeg().setRotZ(-0.07853982f);
            this.getOptimizedBone("Waist").setRot(0.0f, 0.0f, 0.0f);
            this.getOptimizedBone("Root").setRot(0.0f, 0.0f, 0.0f);
        }
        boolean flag2 = entityIn.m_5737_() == HumanoidArm.RIGHT;
        boolean bl = flag3 = flag2 ? this.leftArmPose.m_102897_() : this.rightArmPose.m_102897_();
        if (flag2 != flag3) {
            this.poseLeftArm(entityIn);
            this.poseRightArm(entityIn);
        } else {
            this.poseRightArm(entityIn);
            this.poseLeftArm(entityIn);
        }
        float sneakController = this.getControllerValueInverted("CrouchController");
        if (this.isSneak) {
            this.bipedBody().addRotX(-0.5f * sneakController);
            this.getOptimizedBone("Neck").addRotX(0.5f * sneakController);
            this.bipedRightArm().addRot(0.4f * sneakController, 0.0f, 0.0f);
            this.bipedLeftArm().addRot(0.4f * sneakController, 0.0f, 0.0f);
            this.bipedHead().addPosY(-1.0f * sneakController);
            this.bipedBody().addPos(0.0f, -1.5f * sneakController, 1.7f * sneakController);
            this.getOptimizedBone("Waist").addPos(0.0f, -0.2f * sneakController, 4.0f * sneakController);
            this.bipedLeftArm().addRotX(-0.4f * sneakController);
            this.bipedLeftArm().addPos(0.0f, 0.2f * sneakController, -1.0f * sneakController);
            this.bipedRightArm().addRotX(-0.4f * sneakController);
            this.bipedRightArm().addPos(0.0f, 0.2f * sneakController, -1.0f * sneakController);
            this.getOptimizedBone("Waist").addPosY(2.0f * (1.0f - sneakController));
        }
        float armBreathAmount = this.getControllerValueInverted("ArmBreathController");
        GeckoBipedModel.breathAnim(this.bipedRightArm(), this.bipedLeftArm(), ageInTicks, armBreathAmount);
        this.swingAnim(entityIn, partialTick);
        if (this.swimAnimation > 0.0f) {
            float f3;
            float f1 = limbSwing % 26.0f;
            HumanoidArm humanoidArm = this.getMainHand(entityIn);
            float f2 = humanoidArm == HumanoidArm.RIGHT && this.swingProgress > 0.0f ? 0.0f : this.swimAnimation;
            float f4 = f3 = humanoidArm == HumanoidArm.LEFT && this.swingProgress > 0.0f ? 0.0f : this.swimAnimation;
            if (f1 < 14.0f) {
                this.bipedLeftArm().setRotX(-this.rotLerpRad(f3, this.bipedLeftArm().getRotX(), 0.0f));
                this.bipedRightArm().setRotX(-Mth.m_14179_((float)f2, (float)this.bipedRightArm().getRotX(), (float)0.0f));
                this.bipedLeftArm().setRotY(this.rotLerpRad(f3, this.bipedLeftArm().getRotY(), (float)Math.PI));
                this.bipedRightArm().setRotY(Mth.m_14179_((float)f2, (float)this.bipedRightArm().getRotY(), (float)((float)Math.PI)));
                this.bipedLeftArm().setRotZ(this.rotLerpRad(f3, this.bipedLeftArm().getRotZ(), (float)Math.PI + 1.8707964f * this.getArmAngleSq(f1) / this.getArmAngleSq(14.0f)));
                this.bipedRightArm().setRotZ(Mth.m_14179_((float)f2, (float)this.bipedRightArm().getRotZ(), (float)((float)Math.PI - 1.8707964f * this.getArmAngleSq(f1) / this.getArmAngleSq(14.0f))));
            } else if (f1 >= 14.0f && f1 < 22.0f) {
                float f6 = (f1 - 14.0f) / 8.0f;
                this.bipedLeftArm().setRotX(-this.rotLerpRad(f3, this.bipedLeftArm().getRotX(), 1.5707964f * f6));
                this.bipedRightArm().setRotX(-Mth.m_14179_((float)f2, (float)this.bipedRightArm().getRotX(), (float)(1.5707964f * f6)));
                this.bipedLeftArm().setRotY(this.rotLerpRad(f3, this.bipedLeftArm().getRotY(), (float)Math.PI));
                this.bipedRightArm().setRotY(Mth.m_14179_((float)f2, (float)this.bipedRightArm().getRotY(), (float)((float)Math.PI)));
                this.bipedLeftArm().setRotZ(this.rotLerpRad(f3, this.bipedLeftArm().getRotZ(), 5.012389f - 1.8707964f * f6));
                this.bipedRightArm().setRotZ(Mth.m_14179_((float)f2, (float)this.bipedRightArm().getRotZ(), (float)(1.2707963f + 1.8707964f * f6)));
            } else if (f1 >= 22.0f && f1 < 26.0f) {
                float f42 = (f1 - 22.0f) / 4.0f;
                this.bipedLeftArm().setRotX(-this.rotLerpRad(f3, this.bipedLeftArm().getRotX(), 1.5707964f - 1.5707964f * f42));
                this.bipedRightArm().setRotX(-Mth.m_14179_((float)f2, (float)this.bipedRightArm().getRotX(), (float)(1.5707964f - 1.5707964f * f42)));
                this.bipedLeftArm().setRotY(this.rotLerpRad(f3, this.bipedLeftArm().getRotY(), (float)Math.PI));
                this.bipedRightArm().setRotY(Mth.m_14179_((float)f2, (float)this.bipedRightArm().getRotY(), (float)((float)Math.PI)));
                this.bipedLeftArm().setRotZ(this.rotLerpRad(f3, this.bipedLeftArm().getRotZ(), (float)Math.PI));
                this.bipedRightArm().setRotZ(Mth.m_14179_((float)f2, (float)this.bipedRightArm().getRotZ(), (float)((float)Math.PI)));
            }
            float f7 = 0.3f;
            float f5 = 0.33333334f;
            this.bipedLeftLeg().setRotX(Mth.m_14179_((float)this.swimAnimation, (float)this.bipedLeftLeg().getRotX(), (float)(0.3f * Mth.m_14089_((float)(limbSwing * 0.33333334f + (float)Math.PI)))));
            this.bipedRightLeg().setRotX(Mth.m_14179_((float)this.swimAnimation, (float)this.bipedRightLeg().getRotX(), (float)(0.3f * Mth.m_14089_((float)(limbSwing * 0.33333334f)))));
        }
    }

    protected OptimizedGeoBone getArmForSide(HumanoidArm side) {
        return side == HumanoidArm.LEFT ? this.bipedLeftArm() : this.bipedRightArm();
    }

    protected float rotLerpRad(float angleIn, float maxAngleIn, float mulIn) {
        float f = (mulIn - maxAngleIn) % ((float)Math.PI * 2);
        if (f < (float)(-Math.PI)) {
            f += (float)Math.PI * 2;
        }
        if (f >= (float)Math.PI) {
            f -= (float)Math.PI * 2;
        }
        return maxAngleIn + angleIn * f;
    }

    private float getArmAngleSq(float limbSwing) {
        return -65.0f * limbSwing + limbSwing * limbSwing;
    }

    protected HumanoidArm getMainHand(Player entityIn) {
        HumanoidArm handside = entityIn.m_5737_();
        return entityIn.f_20912_ == InteractionHand.MAIN_HAND ? handside : handside.m_20828_();
    }

    public static void breathAnim(OptimizedGeoBone rightArm, OptimizedGeoBone leftArm, float ageInTicks, float armBreathAmount) {
        rightArm.addRotZ(armBreathAmount * Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f);
        leftArm.addRotZ(armBreathAmount * -Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.05f - 0.05f);
        rightArm.addRotX(armBreathAmount * Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.05f);
        leftArm.addRotX(armBreathAmount * -Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.05f);
    }

    protected void swingAnim(Player pLivingEntity, float pPartialTickTime) {
        float attackTime = this.attackTime((LivingEntity)pLivingEntity, pPartialTickTime);
        if (!(attackTime <= 0.0f)) {
            HumanoidArm humanoidarm = this.getMainHand(pLivingEntity);
            OptimizedGeoBone optimizedGeoBone = this.getArmForSide(humanoidarm);
            float f = attackTime;
            this.bipedBody().setRotY(-Mth.m_14031_((float)(Mth.m_14116_((float)f) * ((float)Math.PI * 2))) * 0.1f);
            this.bipedBody().mulRotX(1.0f);
            this.bipedBody().mulRotZ(1.0f);
            if (humanoidarm == HumanoidArm.LEFT) {
                this.bipedBody().mulRotY(-1.0f);
            }
            this.bipedRightArm().addRotY(this.bipedBody().getRotY());
            this.bipedLeftArm().addRotY(this.bipedBody().getRotY());
            this.bipedLeftArm().addRotX(this.bipedBody().getRotY());
            f = 1.0f - attackTime;
            f *= f;
            f *= f;
            f = 1.0f - f;
            float f1 = Mth.m_14031_((float)(f * (float)Math.PI));
            float f2 = Mth.m_14031_((float)(attackTime * (float)Math.PI)) * -(this.bipedHead().getRotX() - 0.7f) * 0.75f;
            optimizedGeoBone.addRotX(f1 * 1.1f + f2);
            optimizedGeoBone.addRotY(this.bipedBody().getRotY() * 1.9f);
            optimizedGeoBone.addRotZ(Mth.m_14031_((float)(attackTime * (float)Math.PI)) * -0.1f);
        }
    }

    private void poseRightArm(Player player) {
        float armSwingAmount = this.getControllerValueInverted("ArmSwingController");
        switch (this.rightArmPose) {
            case EMPTY: {
                break;
            }
            case BLOCK: {
                this.bipedRightArm().addRotX(0.9424779f * armSwingAmount);
                break;
            }
            case ITEM: {
                this.bipedRightArm().addRotX(0.31415927f * armSwingAmount);
                break;
            }
            case THROW_SPEAR: {
                this.bipedRightArm().setRotX(this.bipedRightArm().getRotX() * 0.5f - (float)Math.PI);
                this.bipedRightArm().setRotY(0.0f);
                break;
            }
            case BOW_AND_ARROW: {
                this.bipedRightArm().setRotY(-0.1f + this.bipedHead().getRotY());
                this.bipedLeftArm().setRotY(-1.0f + this.bipedHead().getRotY() / 2.0f + 0.4f);
                this.bipedRightArm().setRotX(-(-1.5707964f - this.bipedHead().getRotX()));
                this.bipedLeftArm().setRotX(-(-1.5707964f - this.bipedHead().getRotX()));
                break;
            }
            case CROSSBOW_CHARGE: {
                GeckoAnimationLibrary.animateCrossbowCharge(this.bipedRightArm(), this.bipedLeftArm(), (LivingEntity)player, true);
                break;
            }
            case CROSSBOW_HOLD: {
                GeckoAnimationLibrary.animateCrossbowHold(this.bipedRightArm(), this.bipedLeftArm(), this.bipedHead(), true);
                break;
            }
            case BRUSH: {
                this.bipedRightArm().setRotX(-(this.bipedRightArm().getRotX() * 0.5f - 0.62831855f));
                this.bipedRightArm().setRotY(0.0f);
                break;
            }
            case SPYGLASS: {
                this.bipedRightArm().setRotX(-Mth.m_14036_((float)(-this.bipedHead().getRotX() - 1.9198622f - (player.m_6047_() ? 0.2617994f : 0.0f)), (float)-2.4f, (float)3.3f));
                this.bipedRightArm().setRotY(this.bipedHead().getRotY() + 0.2617994f);
                this.getOptimizedBone("RightHeldItem").setRotX(1.5707964f);
                break;
            }
            case TOOT_HORN: {
                this.bipedRightArm().setRotX(Mth.m_14036_((float)this.bipedHead().getRotX(), (float)-1.2f, (float)1.2f) + 1.4835298f);
                this.bipedRightArm().setRotY(-this.bipedHead().getRotY() + 0.5235988f);
            }
        }
    }

    private void poseLeftArm(Player player) {
        float armSwingAmount = this.getControllerValueInverted("ArmSwingController");
        switch (this.leftArmPose) {
            case EMPTY: {
                break;
            }
            case BLOCK: {
                this.bipedLeftArm().addRotX(0.9424779f * armSwingAmount);
                break;
            }
            case ITEM: {
                this.bipedLeftArm().addRotX(0.31415927f * armSwingAmount);
                break;
            }
            case THROW_SPEAR: {
                this.bipedLeftArm().setRotX(this.bipedLeftArm().getRotX() * 0.5f - (float)Math.PI);
                this.bipedLeftArm().setRotY(0.0f);
                break;
            }
            case BOW_AND_ARROW: {
                this.bipedRightArm().setRotY(1.0f + this.bipedHead().getRotY() / 2.0f - 0.4f);
                this.bipedLeftArm().setRotY(-(0.1f - this.bipedHead().getRotY()));
                this.bipedRightArm().setRotX(-(-1.5707964f - this.bipedHead().getRotX()));
                this.bipedLeftArm().setRotX(-(-1.5707964f - this.bipedHead().getRotX()));
                break;
            }
            case CROSSBOW_CHARGE: {
                GeckoAnimationLibrary.animateCrossbowCharge(this.bipedRightArm(), this.bipedLeftArm(), (LivingEntity)player, false);
                break;
            }
            case CROSSBOW_HOLD: {
                GeckoAnimationLibrary.animateCrossbowHold(this.bipedRightArm(), this.bipedLeftArm(), this.bipedHead(), false);
                break;
            }
            case BRUSH: {
                this.bipedLeftArm().setRotX(-(this.bipedLeftArm().getRotX() * 0.5f - 0.62831855f));
                this.bipedLeftArm().setRotY(0.0f);
                break;
            }
            case SPYGLASS: {
                this.bipedLeftArm().setRotX(-Mth.m_14036_((float)(-this.bipedHead().getRotX() - 1.9198622f - (player.m_6047_() ? 0.2617994f : 0.0f)), (float)-2.4f, (float)3.3f));
                this.bipedLeftArm().setRotY(this.bipedHead().getRotY() - 0.2617994f);
                this.getOptimizedBone("LeftHeldItem").setRotX(1.5707964f);
                break;
            }
            case TOOT_HORN: {
                this.bipedLeftArm().setRotX(Mth.m_14036_((float)this.bipedHead().getRotX(), (float)-1.2f, (float)1.2f) + 1.4835298f);
                this.bipedLeftArm().setRotY(this.bipedHead().getRotY() - 0.5235988f);
            }
        }
    }

    protected float attackTime(LivingEntity pLivingEntity, float pPartialTickTime) {
        return pLivingEntity.m_21324_(pPartialTickTime);
    }
}

