/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.crafting;

import com.google.common.collect.ImmutableList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.teamabyssalofficial.blocks.blockentity.GunWorkbenchEntity;
import net.teamabyssalofficial.crafting.WorkbenchIngredient;
import net.teamabyssalofficial.guns.helper.GunInventoryHelper;
import net.teamabyssalofficial.registry.RecipeRegistry;
import net.teamabyssalofficial.registry.RecipeSerializersRegistry;
import org.jetbrains.annotations.NotNull;

public class WorkbenchRecipe
implements Recipe<GunWorkbenchEntity> {
    private final ResourceLocation id;
    private final ItemStack item;
    private final ImmutableList<WorkbenchIngredient> materials;

    public WorkbenchRecipe(ResourceLocation id, ItemStack item, ImmutableList<WorkbenchIngredient> materials) {
        this.id = id;
        this.item = item;
        this.materials = materials;
    }

    public ItemStack getItem() {
        return this.item.m_41777_();
    }

    public ImmutableList<WorkbenchIngredient> getMaterials() {
        return this.materials;
    }

    public boolean matches(GunWorkbenchEntity inv, Level worldIn) {
        return false;
    }

    public ItemStack assemble(GunWorkbenchEntity entity, RegistryAccess access) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return this.item.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializersRegistry.GUN_WORKBENCH.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeRegistry.GUN_WORKBENCH.get();
    }

    public boolean hasMaterials(Player player) {
        for (WorkbenchIngredient ingredient : this.getMaterials()) {
            if (GunInventoryHelper.hasWorkstationIngredient(player, ingredient)) continue;
            return false;
        }
        return true;
    }

    public void consumeMaterials(Player player) {
        for (WorkbenchIngredient ingredient : this.getMaterials()) {
            GunInventoryHelper.removeWorkstationIngredient(player, ingredient);
        }
    }
}

