/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.dotf;

import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.teamabyssalofficial.dotf.config.DawnOfTheFloodConfig;
import net.teamabyssalofficial.util.LevelGetterInterface;
import net.teamabyssalofficial.util.WorldDataUtils;

public class BiomeModification
implements BiomeModifier {
    private static final RegistryObject<Codec<? extends BiomeModifier>> SERIALIZER = RegistryObject.create((ResourceLocation)new ResourceLocation("dotf", "dotf_spawns"), (ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"dotf");

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD) {
            int biomesModifier = 0;
            ServerLevel world = LevelGetterInterface.INSTANCE.level;
            if (world != null) {
                switch (WorldDataUtils.getWorldDataRegistry(world).getWave()) {
                    case 4: {
                        biomesModifier = 20;
                        break;
                    }
                    case 5: {
                        biomesModifier = 50;
                        break;
                    }
                    case 6: {
                        biomesModifier = 60;
                        break;
                    }
                    default: {
                        biomesModifier = 0;
                    }
                }
            }
            for (String biomeString : (List)DawnOfTheFloodConfig.SERVER.dimension_parameters.get()) {
                if (!biome.m_203656_(TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(biomeString))) && !biome.m_203373_(new ResourceLocation(biomeString))) continue;
                for (String str : (List)DawnOfTheFloodConfig.SERVER.spawns.get()) {
                    String[] string = str.split("\\|");
                    EntityType entity = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(string[0]));
                    if (entity == null) continue;
                    builder.getMobSpawnSettings().getSpawner(entity.m_20674_()).add(new MobSpawnSettings.SpawnerData(entity, Integer.parseUnsignedInt(string[1]) + biomesModifier, Integer.parseUnsignedInt(string[2]), Integer.parseUnsignedInt(string[3])));
                }
            }
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)SERIALIZER.get();
    }

    public static Codec<BiomeModification> makeCodec() {
        return Codec.unit(BiomeModification::new);
    }
}

