/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.entity.categories;

import javax.annotation.Nullable;
import mod.chloeprime.aaaparticles.api.common.AAALevel;
import mod.chloeprime.aaaparticles.api.common.ParticleEmitterInfo;
import net.asestefan.screenshake.ScreenShakeUtils;
import net.asestefan.utils.ParticleUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.NetworkHooks;
import net.teamabyssalofficial.dotf.config.DawnOfTheFloodConfig;
import net.teamabyssalofficial.impl.StackScaler;
import net.teamabyssalofficial.registry.EntityRegistry;
import net.teamabyssalofficial.registry.ParticleRegistry;
import net.teamabyssalofficial.registry.ParticleResourceRegistry;
import net.teamabyssalofficial.registry.SoundRegistry;
import net.teamabyssalofficial.util.BlockUtils;
import net.teamabyssalofficial.util.PerformanceEngine;

public class BodyEntity
extends Monster {
    private static final EntityDataAccessor<Integer> FALL_TIMER = SynchedEntityData.m_135353_(BodyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(BodyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DESPAWN_TICKS = SynchedEntityData.m_135353_(BodyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> WATER_DESPAWN_TICKS = SynchedEntityData.m_135353_(BodyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> TAKEN = SynchedEntityData.m_135353_(BodyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> STACK_SCALE = SynchedEntityData.m_135353_(BodyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public final StackScaler stackScaler = new StackScaler(1.0f, 1.0f, 1.0f);
    protected float scalingFactor = 2.5f;

    protected BodyEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 0;
        EntityRegistry.FLOOD_FORMS.add((Entity)this);
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(DESPAWN_TICKS, (Object)0);
        this.f_19804_.m_135372_(WATER_DESPAWN_TICKS, (Object)0);
        this.f_19804_.m_135372_(TAKEN, (Object)false);
        this.f_19804_.m_135372_(FALL_TIMER, (Object)this.getFallAnimationTick());
        this.f_19804_.m_135372_(STACK_SCALE, (Object)Float.valueOf(1.0f));
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("Variant", this.getVariant());
        compoundTag.m_128405_("Despawn_Ticks", this.getDespawnTicks());
        compoundTag.m_128405_("Water_Despawn_Ticks", this.getWaterDespawnTicks());
        compoundTag.m_128379_("Taken", this.isTaken());
        compoundTag.m_128405_("Fall_Timer", this.getFallTimer());
        compoundTag.m_128350_("stackScale", this.stackScale());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setVariant(compoundTag.m_128451_("Variant"));
        this.setDespawnTicks(compoundTag.m_128451_("Despawn_Ticks"));
        this.setWaterDespawnTicks(compoundTag.m_128451_("Water_Despawn_Ticks"));
        this.setTaken(compoundTag.m_128471_("Taken"));
        this.setFallTimer(compoundTag.m_128451_("Fall_Timer"));
        this.setStackScale(compoundTag.m_128457_("stackScale"));
    }

    public int getFallTimer() {
        return (Integer)this.f_19804_.m_135370_(FALL_TIMER);
    }

    public void setFallTimer(int ticks) {
        this.f_19804_.m_135381_(FALL_TIMER, (Object)ticks);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public int getDespawnTicks() {
        return (Integer)this.f_19804_.m_135370_(DESPAWN_TICKS);
    }

    public void setDespawnTicks(int ticks) {
        this.f_19804_.m_135381_(DESPAWN_TICKS, (Object)ticks);
    }

    public int getWaterDespawnTicks() {
        return (Integer)this.f_19804_.m_135370_(WATER_DESPAWN_TICKS);
    }

    public void setWaterDespawnTicks(int ticks) {
        this.f_19804_.m_135381_(WATER_DESPAWN_TICKS, (Object)ticks);
    }

    public boolean isTaken() {
        return (Boolean)this.f_19804_.m_135370_(TAKEN);
    }

    public void setTaken(boolean value) {
        this.f_19804_.m_135381_(TAKEN, (Object)value);
    }

    public float stackScale() {
        return ((Float)this.f_19804_.m_135370_(STACK_SCALE)).floatValue();
    }

    public void setStackScale(float pScale) {
        this.f_19804_.m_135381_(STACK_SCALE, (Object)Float.valueOf(pScale));
    }

    public void randomizeScale(float pFactor) {
        float scalingMul = this.f_19796_.m_188501_() / pFactor;
        this.setStackScale(this.stackScale() + scalingMul);
    }

    protected void m_8024_() {
        if (this.getFallTimer() > 0) {
            this.setFallTimer(this.getFallTimer() - 1);
        }
        super.m_8024_();
    }

    public void summonFloodParticle() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.FLOOD_BLOOD_SPLASH.get()), this.m_20208_(0.25), this.m_20187_() + 0.25, this.m_20262_(0.25), 2, 0.1, 0.2, 0.1, ParticleUtils.getDownwardsSmallSpread((RandomSource)this.f_19796_));
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getFallTimer() > 0) {
            this.summonFloodParticle();
        }
        if (this.getFallTimer() == this.getScreenshakeTick()) {
            if (((Boolean)DawnOfTheFloodConfig.SERVER.corpse_screen_shake_ground.get()).booleanValue() && PerformanceEngine.canPerformShake((LivingEntity)this, this.m_9236_(), 10.0)) {
                ScreenShakeUtils.ScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)PerformanceEngine.getShakeRadius(8), (float)this.getScreenshakeIntensity(), (int)5, (int)2);
            }
            this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SoundRegistry.BODY_FALL.get(), SoundSource.HOSTILE, this.m_6121_(), this.getSoundPitch());
        }
        this.setDespawnTicks(this.getDespawnTicks() + 1);
        if (this.m_5842_()) {
            this.setWaterDespawnTicks(this.getWaterDespawnTicks() + 1);
        }
        if (this.getDespawnTicks() == 12000 || this.getWaterDespawnTicks() == 200 || this.m_5842_() && PerformanceEngine.hasPerformanceModeOn()) {
            this.m_146870_();
            this.vanish();
        }
    }

    public void vanish() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            if (!PerformanceEngine.hasPerformanceModeOn()) {
                AAALevel.addParticle((Level)world, (boolean)true, (ParticleEmitterInfo)ParticleResourceRegistry.getTemporaryFloodSmoke().clone().scale(0.15f).position(this.m_20208_(0.25), this.m_20188_() + 0.2, this.m_20262_(0.25)));
            }
            world.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.GUTS.get()), this.m_20208_(0.5), this.m_20187_() + 0.35, this.m_20262_(0.65), PerformanceEngine.getParticleCount(35), 0.1, 0.2, 0.1, ParticleUtils.getDownwardsSmallSpread((RandomSource)this.f_19796_));
        }
        this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12609_, SoundSource.HOSTILE, 1.25f, 0.95f);
        AABB aabb = this.m_20191_().m_82400_(1.0);
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            BlockUtils.generateBlood(this.m_9236_(), blockpos);
        }
    }

    public void m_6667_(DamageSource pDamageSource) {
        this.m_146870_();
        this.vanish();
        super.m_6667_(pDamageSource);
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    protected InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        if (pHand == InteractionHand.MAIN_HAND && (pPlayer.m_21205_().m_41720_() == Items.f_42409_ || pPlayer.m_21205_().m_41720_() == Items.f_42448_)) {
            this.m_146870_();
            this.vanish();
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (pSource.m_276093_(DamageTypes.f_268546_) || pSource.m_276093_(DamageTypes.f_268468_) || pSource.m_276093_(DamageTypes.f_268631_)) {
            return super.m_6469_(pSource, pAmount);
        }
        return false;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return null;
    }

    public int m_20146_() {
        return super.m_6062_();
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        this.randomizeScale(this.scalingFactor);
        this.stackScaler.randomizeScale(this.f_19796_, 2.2f);
        return super.m_6518_(pLevel, pDifficulty, pReason, spawnGroupData, compoundTag);
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return pDistanceToClosestPlayer > 16384.0;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public int getFallAnimationTick() {
        return 23;
    }

    public int getScreenshakeTick() {
        return 5;
    }

    public float getScreenshakeIntensity() {
        return 0.15f;
    }

    public float getSoundPitch() {
        return 0.95f;
    }

    public float m_6121_() {
        return 1.05f;
    }
}

