/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.entity.custom.special;

import mod.chloeprime.aaaparticles.api.common.AAALevel;
import mod.chloeprime.aaaparticles.api.common.ParticleEmitterInfo;
import net.asestefan.screenshake.ScreenShakeUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.teamabyssalofficial.entity.custom.special.ThrowableItemEntity;
import net.teamabyssalofficial.registry.EntityRegistry;
import net.teamabyssalofficial.registry.ItemRegistry;
import net.teamabyssalofficial.registry.ParticleResourceRegistry;
import net.teamabyssalofficial.registry.SoundRegistry;
import net.teamabyssalofficial.util.BlockUtils;
import net.teamabyssalofficial.util.PerformanceEngine;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PlasmaGrenadeEntity
extends ThrowableItemEntity
implements GeoEntity {
    public float rotation;
    public float prevRotation;
    private int aliveTicks = 0;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public PlasmaGrenadeEntity(EntityType<? extends ThrowableItemEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
        this.isPlasma = true;
    }

    public PlasmaGrenadeEntity(EntityType<? extends ThrowableItemEntity> entityType, Level world, LivingEntity entity) {
        super(entityType, world, entity);
        this.setShouldBounce(true);
        this.setGravityVelocity(0.05f);
        this.setItem(new ItemStack((ItemLike)ItemRegistry.PLASMA_GRENADE.get()));
        this.setMaxLife(100);
        this.isPlasma = true;
    }

    public PlasmaGrenadeEntity(Level world, LivingEntity entity, int timeLeft) {
        super((EntityType<? extends ThrowableItemEntity>)((EntityType)EntityRegistry.PLASMA_GRENADE.get()), world, entity);
        this.setShouldBounce(true);
        this.setGravityVelocity(0.05f);
        this.setItem(new ItemStack((ItemLike)ItemRegistry.PLASMA_GRENADE.get()));
        this.setMaxLife(timeLeft);
        this.isPlasma = true;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerV) {
        controllerV.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller_entity", 1, event -> event.setAndContinue(RawAnimation.begin().thenLoop("idle")))});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected void m_8097_() {
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.prevRotation = this.rotation;
        ++this.aliveTicks;
        double speed = this.m_20184_().m_82553_();
        if (speed > 0.1) {
            this.rotation = (float)((double)this.rotation + speed * 50.0);
        }
        if (this.m_9236_().f_46443_) {
            this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123762_, true, this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_(), 0.0, 0.0, 0.0);
        }
        if (this.aliveTicks == 100) {
            this.onDeath();
        }
    }

    @Override
    public void onDeath() {
        this.createExplosion((Entity)this, 2.5f, false);
    }

    public void createExplosion(Entity entity, float radius, boolean breakTerrain) {
        Level world = entity.m_9236_();
        if (world.m_5776_()) {
            return;
        }
        if (world instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)world;
            if (!PerformanceEngine.hasPerformanceModeOn()) {
                AAALevel.addParticle((Level)server, (boolean)true, (ParticleEmitterInfo)ParticleResourceRegistry.getPlasmaExplosion().clone().scale(0.45f).position(entity.m_20182_()));
            }
        }
        if (ForgeEventFactory.getMobGriefingEvent((Level)world, (Entity)entity)) {
            Level.ExplosionInteraction interaction = breakTerrain ? Level.ExplosionInteraction.TNT : Level.ExplosionInteraction.NONE;
            world.m_255391_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), radius, false, interaction);
        }
        world.m_5594_(null, entity.m_20183_(), (SoundEvent)SoundRegistry.PLASMA_GRENADE_EXPLOSION.get(), SoundSource.BLOCKS, 3.0f, (1.0f + (world.f_46441_.m_188501_() - world.f_46441_.m_188501_()) * 0.2f) * 0.7f);
        if (PerformanceEngine.canPerformShake(entity.m_20191_(), world, (double)PerformanceEngine.getShakeRadius(18))) {
            ScreenShakeUtils.ScreenShake((Level)world, (Vec3)entity.m_20182_(), (float)PerformanceEngine.getShakeRadius(18), (float)0.19f, (int)13, (int)5);
        }
        if (breakTerrain) {
            BlockUtils.moveTrembleBlocks(world, (int)radius, entity, 0.2, 0.2, 0.2, false);
        }
    }
}

