/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.guns.bullet;

import java.util.List;
import mod.chloeprime.aaaparticles.api.common.AAALevel;
import mod.chloeprime.aaaparticles.api.common.ParticleEmitterInfo;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.teamabyssalofficial.guns.bullet.AbstractBullet;
import net.teamabyssalofficial.registry.ParticleResourceRegistry;
import net.teamabyssalofficial.registry.SoundRegistry;
import net.teamabyssalofficial.util.NeedlerSpike;
import net.teamabyssalofficial.util.PerformanceEngine;

public class AbstractBlamiteCrystalEntity
extends AbstractBullet {
    private final float explosionDamage = 10.0f;
    private final float explosionRadius = 2.5f;
    private boolean explode = false;
    private double x;
    private double y;
    private double z;

    public AbstractBlamiteCrystalEntity(LivingEntity owner, Level world, double bulletDamage, float bulletSpeed, boolean doesDamageDecreaseWithDistance) {
        super(owner, world, bulletDamage, bulletSpeed, doesDamageDecreaseWithDistance);
    }

    public AbstractBlamiteCrystalEntity(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public void createExplosion(Projectile pEntity) {
        Level level = pEntity.m_9236_();
        if (level.f_46443_) {
            return;
        }
        level.m_5594_(null, pEntity.m_20183_(), (SoundEvent)SoundRegistry.NEEDLER_SMALL_EXPLODE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        AABB boundingBox = pEntity.m_20191_().m_82400_(2.5);
        List entities = level.m_45933_((Entity)(pEntity.m_19749_() != null ? pEntity.m_19749_() : pEntity), boundingBox);
        for (Entity entityIterator : entities) {
            if (!(entityIterator instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entityIterator;
            float dist = pEntity.m_20270_((Entity)livingEntity);
            livingEntity.m_6469_(this.getDamage(), 10.0f * (1.0f / dist));
        }
    }

    @Override
    protected void m_5790_(EntityHitResult pResult) {
        LivingEntity livingEntity;
        NeedlerSpike needlerSpike;
        super.m_5790_(pResult);
        Entity entity = pResult.m_82443_();
        this.m_9236_().m_5594_(null, entity.m_20183_(), (SoundEvent)SoundRegistry.NEEDLER_IMPACT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        if (entity instanceof LivingEntity && (needlerSpike = (NeedlerSpike)(livingEntity = (LivingEntity)entity)).IgetNeedlerSpikesShot() > 0 && needlerSpike.IgetNeedlerSpikesShot() % 7 == 0) {
            this.explode = true;
            this.x = livingEntity.m_20208_(0.25);
            this.y = livingEntity.m_20188_() - 0.1;
            this.z = livingEntity.m_20262_(0.25);
            this.createExplosion(this);
            if (!PerformanceEngine.hasPerformanceModeOn()) {
                AAALevel.addParticle((Level)this.m_9236_(), (boolean)true, (ParticleEmitterInfo)ParticleResourceRegistry.getNeedlerSmoke().clone().scale(0.3f).position(this.x, this.y, this.z));
            }
        }
    }

    @Override
    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("shouldExplode", this.explode);
    }

    @Override
    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.explode = tag.m_128471_("shouldExplode");
    }
}

