/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.item;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import mod.chloeprime.aaaparticles.api.common.AAALevel;
import mod.chloeprime.aaaparticles.api.common.ParticleEmitterInfo;
import net.asestefan.screenshake.ScreenShakeUtils;
import net.fabridge.fabricmc.network.fabric.PacketByteBufs;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.teamabyssalofficial.client.weapon.renderer.GravityHammerRenderer;
import net.teamabyssalofficial.dotf.config.DawnOfTheFloodConfig;
import net.teamabyssalofficial.dotf.playerlib.AnimationAbilityHandler;
import net.teamabyssalofficial.guns.helper.KeybindHelper;
import net.teamabyssalofficial.item.RenderedHandsItem;
import net.teamabyssalofficial.network.ServerNetworkHandler;
import net.teamabyssalofficial.registry.ParticleResourceRegistry;
import net.teamabyssalofficial.registry.SoundRegistry;
import net.teamabyssalofficial.util.BlockUtils;
import net.teamabyssalofficial.util.PerformanceEngine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.cache.AnimatableIdCache;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.keyframe.event.SoundKeyframeEvent;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import software.bernie.geckolib.util.RenderUtils;

public class GravityHammerItem
extends RenderedHandsItem
implements GeoAnimatable,
GeoItem {
    private final float damage;
    private final float reach;
    private final String description = "The Gravity Hammer is a Brute melee weapon that combines a bladed war hammer with repurposed gravitic impellers integrated onto the striking face. These impellers give the weapon its namesake, and each smash produces a devastating area of effect pulse.";
    public static final int ATTACK1_TICKS = 40;
    public static final int ATTACK2_TICKS = 45;
    public static final int ATTACK3_TICKS = 35;
    public static final int DRAW_TICKS = 20;
    public static final byte ATTACK_NONE = 0;
    public static final byte ATTACK1 = 1;
    public static final byte ATTACK2 = 2;
    public static final byte ATTACK3 = 3;
    private int drawTick;
    protected final AnimatableInstanceCache animationCache;

    public GravityHammerItem(Item.Properties pProperties) {
        super(pProperties.m_41487_(1).setNoRepair().m_41497_(Rarity.RARE));
        this.damage = ((Double)DawnOfTheFloodConfig.SERVER.gravity_hammer_damage.get()).floatValue();
        this.reach = ((Double)DawnOfTheFloodConfig.SERVER.gravity_hammer_reach.get()).floatValue();
        this.description = "The Gravity Hammer is a Brute melee weapon that combines a bladed war hammer with repurposed gravitic impellers integrated onto the striking face. These impellers give the weapon its namesake, and each smash produces a devastating area of effect pulse.";
        this.drawTick = 0;
        this.animationCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    private void setDefaultNBT(ItemStack stack) {
        CompoundTag nbtCompound = stack.m_41784_();
        nbtCompound.m_128405_("attackTick", 0);
        nbtCompound.m_128344_("attackID", (byte)0);
    }

    public void m_7836_(ItemStack pStack, Level pLevel, Player pPlayer) {
        this.setDefaultNBT(pStack);
        if (pLevel instanceof ServerLevel) {
            long id = GeoItem.getOrAssignId((ItemStack)pStack, (ServerLevel)((ServerLevel)pLevel));
            this.triggerAnim((Entity)pPlayer, id, "controller", "idle");
        }
        super.m_7836_(pStack, pLevel, pPlayer);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        if (Screen.m_96638_()) {
            pTooltipComponents.add((Component)Component.m_237115_((String)("Damage: " + this.getDamage())).m_130940_(ChatFormatting.BLUE));
            pTooltipComponents.add((Component)Component.m_237115_((String)("Entity Reach: " + this.getEntityReach())).m_130940_(ChatFormatting.BLUE));
            pTooltipComponents.add((Component)Component.m_237115_((String)("Description: " + this.getDesc())).m_130940_(ChatFormatting.BLUE));
        } else {
            pTooltipComponents.add((Component)Component.m_237115_((String)"Press Shift to see stats").m_130940_(ChatFormatting.BLUE));
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        CompoundTag nbtCompound = stack.m_41784_();
        ItemStack mainHandGun = ((Player)entity).m_21205_();
        if (!nbtCompound.m_128425_("GeckoLibID", 99) && world instanceof ServerLevel) {
            nbtCompound.m_128356_("GeckoLibID", AnimatableIdCache.getFreeId((ServerLevel)((ServerLevel)world)));
        }
        if (nbtCompound.m_128451_("attackTick") > 0) {
            nbtCompound.m_128405_("attackTick", nbtCompound.m_128451_("attackTick") - 1);
        }
        long id = GeoItem.getId((ItemStack)stack);
        AnimationController animationController = (AnimationController)this.getAnimatableInstanceCache().getManagerForId(id).getAnimationControllers().get("controller");
        if (world.f_46443_) {
            Minecraft client = Minecraft.m_91087_();
            Options options = client.f_91066_;
            boolean canAnimate = options.m_92176_().m_90612_();
            this.updateBooleanTag(nbtCompound, "isDrawing", nbtCompound.m_128471_("isDrawn"));
            if (nbtCompound.m_128471_("isDrawing") && nbtCompound.m_128451_("drawnTick") < 20) {
                ++this.drawTick;
                nbtCompound.m_128405_("drawnTick", this.drawTick);
            }
            if (id == GeoItem.getId((ItemStack)((Player)entity).m_21205_())) {
                if (!nbtCompound.m_128471_("isDrawn")) {
                    nbtCompound.m_128379_("isDrawn", true);
                }
                if (nbtCompound.m_128471_("isDrawing") && canAnimate) {
                    this.handleDrawingState(nbtCompound, (AnimationController<GeoAnimatable>)animationController);
                }
            } else if (GeoItem.getId((ItemStack)((Player)entity).m_21205_()) != id) {
                if (nbtCompound.m_128471_("isDrawn")) {
                    nbtCompound.m_128473_("isDrawn");
                    nbtCompound.m_128473_("drawnTick");
                    this.drawTick = 0;
                }
                animationController.tryTriggerAnimation("idle");
            }
            if (animationController.getCurrentRawAnimation() != Animations.IDLE && !canAnimate) {
                animationController.tryTriggerAnimation("idle");
            }
            if (mainHandGun == stack && KeybindHelper.getShootMapping().m_90857_() && nbtCompound.m_128451_("drawnTick") >= 20) {
                int rand = ((Player)entity).m_217043_().m_188503_(10);
                FriendlyByteBuf bufA = PacketByteBufs.create();
                boolean canPlayAnim = animationController.getCurrentRawAnimation() != Animations.SWING_RIGHT && animationController.getCurrentRawAnimation() != Animations.SWING_LEFT && animationController.getCurrentRawAnimation() != Animations.SWING_VERTICAL;
                switch (rand) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        if (!canPlayAnim) break;
                        if (canAnimate) {
                            animationController.tryTriggerAnimation("swing_right");
                        }
                        ServerNetworkHandler.sendC2SSendGravityHammerAttack(bufA, 40, (byte)1);
                        AnimationAbilityHandler.INSTANCE.sendPlayerTryAbilityMessage((Player)entity, AnimationAbilityHandler.GRAVITY_HAMMER_RIGHT_HIT);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        if (!canPlayAnim) break;
                        if (canAnimate) {
                            animationController.tryTriggerAnimation("swing_left");
                        }
                        ServerNetworkHandler.sendC2SSendGravityHammerAttack(bufA, 45, (byte)2);
                        AnimationAbilityHandler.INSTANCE.sendPlayerTryAbilityMessage((Player)entity, AnimationAbilityHandler.GRAVITY_HAMMER_LEFT_HIT);
                        break;
                    }
                    case 8: 
                    case 9: {
                        if (!canPlayAnim) break;
                        if (canAnimate) {
                            animationController.tryTriggerAnimation("swing_vertical");
                        }
                        ServerNetworkHandler.sendC2SSendGravityHammerAttack(bufA, 35, (byte)3);
                        AnimationAbilityHandler.INSTANCE.sendPlayerTryAbilityMessage((Player)entity, AnimationAbilityHandler.GRAVITY_HAMMER_VERTICAL_HIT);
                    }
                }
            }
            if (mainHandGun == stack && !entity.m_5833_()) {
                int hitTick = 29;
                switch (nbtCompound.m_128445_("attackID")) {
                    case 1: {
                        hitTick = 29;
                        break;
                    }
                    case 2: {
                        hitTick = 33;
                        break;
                    }
                    case 3: {
                        hitTick = 24;
                    }
                }
                if (nbtCompound.m_128451_("attackTick") == hitTick) {
                    ServerNetworkHandler.sendC2SSendGravityHammerDamage();
                }
            }
        }
    }

    private void updateBooleanTag(CompoundTag nbt, String key, boolean value) {
        if (value) {
            nbt.m_128379_(key, true);
        } else {
            nbt.m_128473_(key);
        }
    }

    private void handleDrawingState(CompoundTag nbt, AnimationController<GeoAnimatable> animationController) {
        if (nbt.m_128451_("drawnTick") < 20) {
            animationController.tryTriggerAnimation("draw");
        }
    }

    public boolean isSlamAttack(ItemStack stack) {
        return stack.m_41784_().m_128445_("attackID") == 3;
    }

    public void attack(@NotNull Player player, ItemStack stack) {
        if (this.isSlamAttack(stack)) {
            BlockUtils.moveTrembleBlocks(player.m_9236_(), 5, (LivingEntity)player, 0.15, 0.35, 0.15, false);
            if (PerformanceEngine.canPerformShake((LivingEntity)player, player.m_9236_(), 16.0)) {
                ScreenShakeUtils.ScreenShake((Level)player.m_9236_(), (Vec3)player.m_20182_(), (float)PerformanceEngine.getShakeRadius(16), (float)0.25f, (int)4, (int)1);
                Level level = player.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel world = (ServerLevel)level;
                    if (!PerformanceEngine.hasPerformanceModeOn()) {
                        AAALevel.addParticle((Level)world, (boolean)true, (ParticleEmitterInfo)ParticleResourceRegistry.bolts.get(player.m_217043_().m_188503_(ParticleResourceRegistry.bolts.size())).clone().scale(0.25f).position(player.m_20208_(0.25), player.m_20186_() + 0.25, player.m_20262_(0.25)));
                    }
                }
            }
        }
        float extra = this.isSlamAttack(stack) ? 3.5f : 3.0f;
        float reach = this.isSlamAttack(stack) ? this.getEntityReach() / 2.0f : this.getEntityReach();
        AABB boundingBox = player.m_20191_().m_82400_((double)reach);
        List entities = player.m_9236_().m_45933_((Entity)player, boundingBox);
        for (Entity entity : entities) {
            float knockbackFactor;
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || (livingEntity = (LivingEntity)entity) instanceof Villager || livingEntity instanceof IronGolem || livingEntity instanceof Player) continue;
            Level level = player.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel world = (ServerLevel)level;
                if (!PerformanceEngine.hasPerformanceModeOn()) {
                    AAALevel.addParticle((Level)world, (boolean)true, (ParticleEmitterInfo)ParticleResourceRegistry.getWeaponSmoke().clone().scale(0.15f).position(livingEntity.m_20208_(0.25), livingEntity.m_20188_() - 0.1, livingEntity.m_20262_(0.25)));
                }
            }
            float dist = player.m_20270_((Entity)livingEntity);
            float f = player.m_21023_(MobEffects.f_19600_) ? (float)Objects.requireNonNull(player.m_21124_(MobEffects.f_19600_)).m_19564_() : 1.0f;
            livingEntity.m_6469_(livingEntity.m_269291_().m_269075_(player), this.getDamage() * (1.0f / dist) * f * extra);
            if (!this.isSlamAttack(stack)) {
                knockbackFactor = 3.5f;
                livingEntity.m_9236_().m_5594_(null, livingEntity.m_20183_(), (SoundEvent)SoundRegistry.GRAVITY_HAMMER_BLOW.get(), SoundSource.HOSTILE, 1.8f, 1.0f);
            } else {
                knockbackFactor = 9.0f;
            }
            livingEntity.f_20883_ = livingEntity.f_20885_;
            float f1 = (float)Math.cos(Math.toRadians(player.m_146908_() + 90.0f)) * knockbackFactor;
            float f2 = (float)Math.sin(Math.toRadians(player.m_146908_() + 90.0f)) * knockbackFactor;
            float res = (float)Objects.requireNonNull(livingEntity.m_21051_(Attributes.f_22278_)).m_22115_();
            float resistance = res > 3.0f ? 1.0f / (res + 0.1f) : 1.0f;
            livingEntity.m_5997_((double)(f1 * resistance * player.m_217043_().m_188501_()) * 1.2 * (double)(1.0f / dist), 0.2 * (double)player.m_217043_().m_188501_() * (double)resistance, (double)(f2 * player.m_217043_().m_188501_()) * 1.2 * (double)resistance * (double)(1.0f / dist));
            livingEntity.f_19864_ = true;
        }
        stack.m_41784_().m_128344_("attackID", (byte)0);
    }

    public int m_142159_(ItemStack pStack) {
        return Objects.requireNonNull(ChatFormatting.BLUE.m_126665_());
    }

    public boolean m_8120_(ItemStack pStack) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private GravityHammerRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new GravityHammerRenderer();
                }
                return this.renderer;
            }
        });
    }

    private PlayState predicate(AnimationState<GravityHammerItem> event) {
        if (event.getController().getCurrentAnimation() == null || event.getController().getAnimationState() == AnimationController.State.STOPPED) {
            event.getController().tryTriggerAnimation("idle");
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animationCache;
    }

    public double getTick(Object itemStack) {
        return RenderUtils.getCurrentTick();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, "controller", 1, this::predicate).triggerableAnim("idle", Animations.IDLE).triggerableAnim("draw", Animations.DRAW).triggerableAnim("swing_right", Animations.SWING_RIGHT).triggerableAnim("swing_left", Animations.SWING_LEFT).triggerableAnim("swing_vertical", Animations.SWING_VERTICAL);
        controller.setSoundKeyframeHandler(this::soundListener);
        controllers.add(new AnimationController[]{controller});
    }

    private void soundListener(SoundKeyframeEvent<GravityHammerItem> gravityHammerItemSoundKeyframeEvent) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            switch (gravityHammerItemSoundKeyframeEvent.getKeyframeData().getSound()) {
                case "draw": {
                    player.m_5496_((SoundEvent)SoundRegistry.GRAVITY_HAMMER_READY.get(), 1.25f, 1.0f);
                    break;
                }
                case "swing": {
                    player.m_5496_((SoundEvent)SoundRegistry.GRAVITY_HAMMER_SWING.get(), 1.25f, 1.0f);
                    break;
                }
                case "hit": {
                    player.m_5496_((SoundEvent)SoundRegistry.GRAVITY_HAMMER_HIT.get(), 1.25f, 1.0f);
                }
            }
        }
    }

    public float getDamage() {
        return this.damage;
    }

    public float getEntityReach() {
        return this.reach;
    }

    public String getDesc() {
        return this.description;
    }

    public static class Animations {
        public static final RawAnimation IDLE = RawAnimation.begin().thenLoop("idle");
        public static final RawAnimation DRAW = RawAnimation.begin().then("draw", Animation.LoopType.PLAY_ONCE);
        public static final RawAnimation SWING_RIGHT = RawAnimation.begin().then("swing_right", Animation.LoopType.PLAY_ONCE);
        public static final RawAnimation SWING_LEFT = RawAnimation.begin().then("swing_left", Animation.LoopType.PLAY_ONCE);
        public static final RawAnimation SWING_VERTICAL = RawAnimation.begin().then("swing_vertical", Animation.LoopType.PLAY_ONCE);
    }
}

