/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.mixin;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.player.Player;
import net.teamabyssalofficial.util.PlayerVariableUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerMixin
implements PlayerVariableUtils {
    @Unique
    private static final EntityDataAccessor<Integer> KILLS = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Unique
    private static final EntityDataAccessor<Boolean> INVINCIBLE = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Unique
    private static final EntityDataAccessor<Boolean> HUD_HIDDEN = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Unique
    private static final EntityDataAccessor<Boolean> CAMERA_LOCKED = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Unique
    private static final EntityDataAccessor<Boolean> MOVEMENT_BLOCKED = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Unique
    private static final EntityDataAccessor<Float> FOG_FACTOR = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    @Unique
    private SynchedEntityData dataTracker() {
        return ((Player)this).m_20088_();
    }

    @Inject(at={@At(value="HEAD")}, method={"addAdditionalSaveData"})
    private void addAdditionalSaveData(CompoundTag nbt, CallbackInfo ci) {
        nbt.m_128405_("KillData", this.IgetKills());
        nbt.m_128379_("Invincible", this.isInvincible());
        nbt.m_128350_("FogFactor", this.getFogFactor());
        nbt.m_128379_("hudHidden", this.hasHudHidden());
        nbt.m_128379_("cameraLocked", this.hasCameraLocked());
        nbt.m_128379_("movementBlocked", this.movementBlocked());
    }

    @Inject(at={@At(value="HEAD")}, method={"readAdditionalSaveData"})
    private void readAdditionalSaveData(CompoundTag nbt, CallbackInfo ci) {
        if (nbt.m_128441_("KillData")) {
            this.IsetKills(nbt.m_128451_("KillData"));
            this.setInvincible(nbt.m_128471_("Invincible"));
            this.setFogFactor(nbt.m_128457_("FogFactor"));
            this.setHudHidden(nbt.m_128471_("hudHidden"));
            this.setCameraLocked(nbt.m_128471_("cameraLocked"));
            this.setMovementBlocked(nbt.m_128471_("movementBlocked"));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"defineSynchedData"})
    private void defineSynchedData(CallbackInfo ci) {
        this.dataTracker().m_135372_(KILLS, (Object)0);
        this.dataTracker().m_135372_(INVINCIBLE, (Object)false);
        this.dataTracker().m_135372_(FOG_FACTOR, (Object)Float.valueOf(0.0f));
        this.dataTracker().m_135372_(HUD_HIDDEN, (Object)false);
        this.dataTracker().m_135372_(CAMERA_LOCKED, (Object)false);
        this.dataTracker().m_135372_(MOVEMENT_BLOCKED, (Object)false);
    }

    @Override
    public int IgetKills() {
        return (Integer)this.dataTracker().m_135370_(KILLS);
    }

    @Override
    public void IsetKills(int i) {
        this.dataTracker().m_135381_(KILLS, (Object)i);
    }

    @Override
    public boolean isInvincible() {
        return (Boolean)this.dataTracker().m_135370_(INVINCIBLE);
    }

    @Override
    public void setInvincible(boolean value) {
        this.dataTracker().m_135381_(INVINCIBLE, (Object)value);
    }

    @Override
    public float getFogFactor() {
        return ((Float)this.dataTracker().m_135370_(FOG_FACTOR)).floatValue();
    }

    @Override
    public void setFogFactor(float factor) {
        this.dataTracker().m_135381_(FOG_FACTOR, (Object)Float.valueOf(factor));
    }

    @Override
    public boolean hasHudHidden() {
        return (Boolean)this.dataTracker().m_135370_(HUD_HIDDEN);
    }

    @Override
    public void setHudHidden(boolean value) {
        this.dataTracker().m_135381_(HUD_HIDDEN, (Object)value);
    }

    @Override
    public boolean hasCameraLocked() {
        return (Boolean)this.dataTracker().m_135370_(CAMERA_LOCKED);
    }

    @Override
    public void setCameraLocked(boolean value) {
        this.dataTracker().m_135381_(CAMERA_LOCKED, (Object)value);
    }

    @Override
    public boolean movementBlocked() {
        return (Boolean)this.dataTracker().m_135370_(MOVEMENT_BLOCKED);
    }

    @Override
    public void setMovementBlocked(boolean value) {
        this.dataTracker().m_135381_(MOVEMENT_BLOCKED, (Object)value);
    }
}

