/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.network;

import net.fabridge.fabricmc.api.ModInitializer;
import net.fabridge.fabricmc.network.ClientPlayNetworking;
import net.fabridge.fabricmc.network.ServerPlayNetworking;
import net.fabridge.fabricmc.network.fabric.PacketByteBufs;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.teamabyssalofficial.client.special.GeckoTemplateLoader;
import net.teamabyssalofficial.network.messages.ModMessages;
import net.teamabyssalofficial.network.messages.server.EnergySwordAttackMessage;
import net.teamabyssalofficial.network.messages.server.EnergySwordDamageMessage;
import net.teamabyssalofficial.network.messages.server.FragmentGrenadeMessage;
import net.teamabyssalofficial.network.messages.server.FragmentTickMessage;
import net.teamabyssalofficial.network.messages.server.GravityHammerAttackMessage;
import net.teamabyssalofficial.network.messages.server.GravityHammerDamageMessage;
import net.teamabyssalofficial.network.messages.server.GunAimingMessage;
import net.teamabyssalofficial.network.messages.server.GunFiringMessage;
import net.teamabyssalofficial.network.messages.server.GunInspectMessage;
import net.teamabyssalofficial.network.messages.server.GunMeleeDamageMessage;
import net.teamabyssalofficial.network.messages.server.GunMeleeMessage;
import net.teamabyssalofficial.network.messages.server.GunReloadMessage;
import net.teamabyssalofficial.network.messages.server.GunShootingMessage;
import net.teamabyssalofficial.network.messages.server.GunWorkbenchMessage;
import net.teamabyssalofficial.network.messages.server.PlasmaGrenadeMessage;
import net.teamabyssalofficial.network.messages.server.PlasmaTickMessage;
import net.teamabyssalofficial.network.messages.server.PlayerUseAbilityMessage;

public class ServerNetworkHandler
implements ModInitializer {
    public void onInitialize() {
        GeckoTemplateLoader.init();
        ServerPlayNetworking.registerGlobalReceiver((ResourceLocation)PlasmaGrenadeMessage.ID, PlasmaGrenadeMessage::receive);
        ServerPlayNetworking.registerGlobalReceiver((ResourceLocation)PlasmaTickMessage.ID, PlasmaTickMessage::receive);
        ServerPlayNetworking.registerGlobalReceiver((ResourceLocation)FragmentGrenadeMessage.ID, FragmentGrenadeMessage::receive);
        ServerPlayNetworking.registerGlobalReceiver((ResourceLocation)FragmentTickMessage.ID, FragmentTickMessage::receive);
        ServerPlayNetworking.registerGlobalReceiver((ResourceLocation)EnergySwordAttackMessage.ID, EnergySwordAttackMessage::receive);
        ServerPlayNetworking.registerGlobalReceiver((ResourceLocation)EnergySwordDamageMessage.ID, EnergySwordDamageMessage::receive);
        ServerPlayNetworking.registerGlobalReceiver((ResourceLocation)GravityHammerAttackMessage.ID, GravityHammerAttackMessage::receive);
        ServerPlayNetworking.registerGlobalReceiver((ResourceLocation)GravityHammerDamageMessage.ID, GravityHammerDamageMessage::receive);
        ServerPlayNetworking.registerGlobalReceiver((ResourceLocation)GunReloadMessage.ID, GunReloadMessage::receive);
        ServerPlayNetworking.registerGlobalReceiver((ResourceLocation)GunInspectMessage.ID, GunInspectMessage::receive);
        ServerPlayNetworking.registerGlobalReceiver((ResourceLocation)GunMeleeMessage.ID, GunMeleeMessage::receive);
        ServerPlayNetworking.registerGlobalReceiver((ResourceLocation)GunMeleeDamageMessage.ID, GunMeleeDamageMessage::receive);
        ServerPlayNetworking.registerGlobalReceiver((ResourceLocation)GunAimingMessage.ID, GunAimingMessage::receive);
        ServerPlayNetworking.registerGlobalReceiver((ResourceLocation)GunFiringMessage.ID, GunFiringMessage::receive);
        ServerPlayNetworking.registerGlobalReceiver((ResourceLocation)GunShootingMessage.ID, GunShootingMessage::receive);
        ServerPlayNetworking.registerGlobalReceiver((ResourceLocation)GunWorkbenchMessage.ID, GunWorkbenchMessage::receive);
        ServerPlayNetworking.registerGlobalReceiver((ResourceLocation)ModMessages.SEND_ABILITY_PLAYER_USE_ID, PlayerUseAbilityMessage::receive);
    }

    public static void sendC2SSendPlasmaGrenade() {
        FriendlyByteBuf buf = PacketByteBufs.create();
        ClientPlayNetworking.send((ResourceLocation)PlasmaGrenadeMessage.ID, (FriendlyByteBuf)buf);
    }

    public static void sendC2SSendPlasmaTick(int throwTicks) {
        FriendlyByteBuf buf = PacketByteBufs.create();
        buf.writeInt(throwTicks);
        ClientPlayNetworking.send((ResourceLocation)PlasmaTickMessage.ID, (FriendlyByteBuf)buf);
    }

    public static void sendC2SSendFragmentGrenade() {
        FriendlyByteBuf buf = PacketByteBufs.create();
        ClientPlayNetworking.send((ResourceLocation)FragmentGrenadeMessage.ID, (FriendlyByteBuf)buf);
    }

    public static void sendC2SSendFragmentTick(int throwTicks) {
        FriendlyByteBuf buf = PacketByteBufs.create();
        buf.writeInt(throwTicks);
        ClientPlayNetworking.send((ResourceLocation)FragmentTickMessage.ID, (FriendlyByteBuf)buf);
    }

    public static void sendC2SSendEnergySwordAttack(FriendlyByteBuf buf, int attackTicks, byte attackID) {
        buf.writeInt(attackTicks);
        buf.writeByte((int)attackID);
        ClientPlayNetworking.send((ResourceLocation)EnergySwordAttackMessage.ID, (FriendlyByteBuf)buf);
    }

    public static void sendC2SSendEnergySwordDamage() {
        FriendlyByteBuf buf = PacketByteBufs.create();
        ClientPlayNetworking.send((ResourceLocation)EnergySwordDamageMessage.ID, (FriendlyByteBuf)buf);
    }

    public static void sendC2SSendGravityHammerAttack(FriendlyByteBuf buf, int attackTicks, byte attackID) {
        buf.writeInt(attackTicks);
        buf.writeByte((int)attackID);
        ClientPlayNetworking.send((ResourceLocation)GravityHammerAttackMessage.ID, (FriendlyByteBuf)buf);
    }

    public static void sendC2SSendGravityHammerDamage() {
        FriendlyByteBuf buf = PacketByteBufs.create();
        ClientPlayNetworking.send((ResourceLocation)GravityHammerDamageMessage.ID, (FriendlyByteBuf)buf);
    }

    public static void sendC2SGunReload(boolean canAnimate) {
        FriendlyByteBuf buf = PacketByteBufs.create();
        buf.writeBoolean(canAnimate);
        ClientPlayNetworking.send((ResourceLocation)GunReloadMessage.ID, (FriendlyByteBuf)buf);
    }

    public static void sendC2SGunInspect(boolean canAnimate) {
        FriendlyByteBuf bufX = PacketByteBufs.create();
        bufX.writeBoolean(canAnimate);
        ClientPlayNetworking.send((ResourceLocation)GunInspectMessage.ID, (FriendlyByteBuf)bufX);
    }

    public static void sendC2SGunMelee(int meleeTicks) {
        FriendlyByteBuf bufY = PacketByteBufs.create();
        bufY.writeInt(meleeTicks);
        ClientPlayNetworking.send((ResourceLocation)GunMeleeMessage.ID, (FriendlyByteBuf)bufY);
    }

    public static void sendC2SGunMeleeDamage() {
        FriendlyByteBuf bufA = PacketByteBufs.create();
        ClientPlayNetworking.send((ResourceLocation)GunMeleeDamageMessage.ID, (FriendlyByteBuf)bufA);
    }

    public static void sendC2SGunAiming(boolean det) {
        FriendlyByteBuf bufA = PacketByteBufs.create();
        bufA.writeBoolean(det);
        ClientPlayNetworking.send((ResourceLocation)GunAimingMessage.ID, (FriendlyByteBuf)bufA);
    }

    public static void sendC2SGunFiring(boolean det) {
        FriendlyByteBuf bufA = PacketByteBufs.create();
        bufA.writeBoolean(det);
        ClientPlayNetworking.send((ResourceLocation)GunFiringMessage.ID, (FriendlyByteBuf)bufA);
    }

    public static void sendC2SGunShooting() {
        FriendlyByteBuf bufR = PacketByteBufs.create();
        bufR.writeBoolean(true);
        ClientPlayNetworking.send((ResourceLocation)GunShootingMessage.ID, (FriendlyByteBuf)bufR);
    }

    public static void sendC2SGunWorkbench(ResourceLocation registryName, BlockPos pos) {
        FriendlyByteBuf buf = PacketByteBufs.create();
        buf.m_130085_(registryName);
        buf.m_130064_(pos);
        ClientPlayNetworking.send((ResourceLocation)GunWorkbenchMessage.ID, (FriendlyByteBuf)buf);
    }

    public static void registerServerNetwork() {
        new ServerNetworkHandler().onInitialize();
    }
}

