/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.registry;

import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.teamabyssalofficial.dotf.config.DawnOfTheFloodConfig;
import net.teamabyssalofficial.entity.custom.special.PortalEntity;
import net.teamabyssalofficial.registry.SoundRegistry;
import net.teamabyssalofficial.util.WorldDataUtils;

public class PortalSpawningRegistry {
    private int nextTick;

    public PortalSpawningRegistry(MinecraftServer server) {
    }

    public int tick(Level level) {
        ServerLevel world;
        if (!((Boolean)DawnOfTheFloodConfig.SERVER.allowPortalSpawns.get()).booleanValue()) {
            return 0;
        }
        RandomSource random = level.f_46441_;
        --this.nextTick;
        if (this.nextTick > 0) {
            return 0;
        }
        this.nextTick += ((Integer)DawnOfTheFloodConfig.SERVER.portalTicksBeforeSpawn.get()).intValue();
        if (level.m_46462_() && level instanceof ServerLevel && WorldDataUtils.getWorldDataRegistry(world = (ServerLevel)level).getWave() > 4) {
            if (random.m_188503_(5) != 0) {
                return 0;
            }
            int j = level.m_6907_().size();
            if (j < 1) {
                return 0;
            }
            Player player = (Player)level.m_6907_().get(random.m_188503_(j));
            if (player.m_5833_()) {
                return 0;
            }
            int k = (24 + random.m_188503_(48)) * (random.m_188499_() ? -1 : 1);
            int l = (24 + random.m_188503_(48)) * (random.m_188499_() ? -1 : 1);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = player.m_20183_().m_122032_().m_122184_(k, 0, l);
            int i1 = 10;
            if (!level.m_151572_(blockpos$mutableblockpos.m_123341_() - 10, blockpos$mutableblockpos.m_123343_() - 10, blockpos$mutableblockpos.m_123341_() + 10, blockpos$mutableblockpos.m_123343_() + 10)) {
                return 0;
            }
            int j1 = 0;
            for (int l1 = 0; l1 < 2; ++l1) {
                ++j1;
                blockpos$mutableblockpos.m_142448_(level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (BlockPos)blockpos$mutableblockpos).m_123342_());
                if (l1 == 0) {
                    if (!this.spawnPortal(level, (BlockPos)blockpos$mutableblockpos, random)) {
                        break;
                    }
                } else {
                    this.spawnPortal(level, (BlockPos)blockpos$mutableblockpos, random);
                    level.m_6907_().forEach(player1 -> {
                        player1.m_5661_((Component)Component.m_237113_((String)"The Flood has found a way to earth!").m_130940_(ChatFormatting.DARK_RED), true);
                        player1.m_9236_().m_5594_(null, player1.m_20183_(), (SoundEvent)SoundRegistry.PORTAL_SPAWN.get(), SoundSource.MASTER, 1.2f, 1.0f);
                    });
                }
                blockpos$mutableblockpos.m_142451_(blockpos$mutableblockpos.m_123341_() + random.m_188503_(5) - random.m_188503_(5));
                blockpos$mutableblockpos.m_142443_(blockpos$mutableblockpos.m_123343_() + random.m_188503_(5) - random.m_188503_(5));
            }
            return j1;
        }
        return 0;
    }

    private boolean spawnPortal(Level level, BlockPos blockPos, RandomSource randomSource) {
        BlockState blockstate = level.m_8055_(blockPos);
        BlockState downState = level.m_8055_(blockPos.m_7495_());
        if (level.m_7146_(blockPos) > 1) {
            return false;
        }
        if (blockstate.m_60819_().m_192917_((Fluid)Fluids.f_76193_) || downState.m_60819_().m_192917_((Fluid)Fluids.f_76193_)) {
            return false;
        }
        PortalEntity.addPortal(level, blockPos.m_252807_());
        return true;
    }
}

