/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.ForgeEventFactory;
import net.teamabyssalofficial.dotf.datagen.tags.GenericBlockTags;
import net.teamabyssalofficial.registry.BlockRegistry;
import net.teamabyssalofficial.util.SoundPacket;

public class BlockUtils {
    public static BlockPos posFromCoords(int x, int y, int z) {
        return new BlockPos(x, y, z);
    }

    public static BlockPos posFromVec3i(Vec3i vec3i) {
        return new BlockPos(vec3i);
    }

    public static void generateBloodInArea(Level level, AABB boundingBox, float area) {
        AABB aabb = boundingBox.m_82400_((double)area);
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            BlockUtils.generateBlood(level, blockpos);
        }
    }

    public static void generateBlood(Level level, BlockPos blockpos) {
        BlockState blockState = level.m_8055_(blockpos);
        BlockState above = level.m_8055_(blockpos.m_7494_());
        BlockState east = level.m_8055_(blockpos.m_122029_());
        BlockState west = level.m_8055_(blockpos.m_122024_());
        int randomNextInt = level.f_46441_.m_188503_(10);
        if (!level.m_5776_() && blockState.m_60804_((BlockGetter)level, blockpos) && above.m_60795_() && Math.random() < 0.9) {
            switch (randomNextInt) {
                case 0: {
                    level.m_7731_(blockpos.m_7494_(), ((Block)BlockRegistry.FLOOD_BLOOD_SPLASH2.get()).m_49966_(), 3);
                    if (Math.random() <= 0.25 && west.m_60795_()) {
                        level.m_7731_(blockpos.m_122024_(), ((Block)BlockRegistry.FLOOD_BLOOD_SPLASH2.get()).m_49966_(), 3);
                    }
                    if (!(Math.random() <= 0.35) || !east.m_60795_()) break;
                    level.m_7731_(blockpos.m_122029_(), ((Block)BlockRegistry.FLOOD_BLOOD_SPLASH2.get()).m_49966_(), 3);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    level.m_7731_(blockpos.m_7494_(), ((Block)BlockRegistry.FLOOD_BLOOD_SPLASH1.get()).m_49966_(), 3);
                    if (Math.random() <= 0.25 && east.m_60795_()) {
                        level.m_7731_(blockpos.m_122029_(), ((Block)BlockRegistry.FLOOD_BLOOD_SPLASH1.get()).m_49966_(), 3);
                    }
                    if (!(Math.random() <= 0.35) || !west.m_60795_()) break;
                    level.m_7731_(blockpos.m_122024_(), ((Block)BlockRegistry.FLOOD_BLOOD_SPLASH1.get()).m_49966_(), 3);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    level.m_7731_(blockpos.m_7494_(), ((Block)BlockRegistry.FLOOD_BLOOD_SPLASH3.get()).m_49966_(), 3);
                    if (Math.random() <= 0.25 && east.m_60795_()) {
                        level.m_7731_(blockpos.m_122029_(), ((Block)BlockRegistry.FLOOD_BLOOD_SPLASH3.get()).m_49966_(), 3);
                    }
                    if (!(Math.random() <= 0.35) || !west.m_60795_()) break;
                    level.m_7731_(blockpos.m_122024_(), ((Block)BlockRegistry.FLOOD_BLOOD_SPLASH3.get()).m_49966_(), 3);
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    level.m_7731_(blockpos.m_7494_(), ((Block)BlockRegistry.FLOOD_BLOOD_SPLASH4.get()).m_49966_(), 3);
                    if (Math.random() <= 0.25 && east.m_60795_()) {
                        level.m_7731_(blockpos.m_122029_(), ((Block)BlockRegistry.FLOOD_BLOOD_SPLASH4.get()).m_49966_(), 3);
                    }
                    if (!(Math.random() <= 0.35) || !west.m_60795_()) break;
                    level.m_7731_(blockpos.m_122024_(), ((Block)BlockRegistry.FLOOD_BLOOD_SPLASH4.get()).m_49966_(), 3);
                }
            }
        }
    }

    public static void moveTrembleBlocks(Level level, int distance, LivingEntity entity, double pushX, double pushY, double pushZ, boolean onlyRemains) {
        double perpFacing = (double)entity.f_20883_ * (Math.PI / 180);
        double facingAngle = perpFacing + 1.5707963267948966;
        int hitY = Mth.m_14107_((double)(entity.m_20191_().f_82289_ - 0.5));
        double spread = Math.PI * 2;
        int arcLen = Mth.m_14165_((double)((double)distance * spread));
        for (int i = 0; i < arcLen; ++i) {
            FallingBlockEntity fallingBlockEntity;
            double theta = ((double)i / ((double)arcLen - 1.0) - 0.5) * spread + facingAngle;
            double vx = Math.cos(theta);
            double vz = Math.sin(theta);
            double px = entity.m_20185_() + vx * (double)distance;
            double pz = entity.m_20189_() + vz * (double)distance;
            if (!ForgeEventFactory.getMobGriefingEvent((Level)level, (Entity)entity)) continue;
            int hitX = Mth.m_14107_((double)px);
            int hitZ = Mth.m_14107_((double)pz);
            RandomSource randomSource = level.m_213780_();
            BlockPos pos = new BlockPos(hitX, hitY, hitZ);
            BlockState block = level.m_8055_(pos);
            if (level.m_8055_(pos) == Blocks.f_50016_.m_49966_()) continue;
            if (onlyRemains) {
                if (!block.m_204336_(GenericBlockTags.Blocks.MOVABLE)) continue;
                fallingBlockEntity = new FallingBlockEntity(level, (double)hitX + 0.5, (double)hitY + 0.5, (double)hitZ + 0.5, block);
                level.m_7731_(pos, block.m_60819_().m_76188_(), 3);
                fallingBlockEntity.m_5997_(randomSource.m_188583_() * pushX, pushY + randomSource.m_188583_() * pushY, randomSource.m_188583_() * pushZ);
                level.m_7967_((Entity)fallingBlockEntity);
                continue;
            }
            fallingBlockEntity = new FallingBlockEntity(level, (double)hitX + 0.5, (double)hitY + 0.5, (double)hitZ + 0.5, block);
            level.m_7731_(pos, block.m_60819_().m_76188_(), 3);
            fallingBlockEntity.m_5997_(randomSource.m_188583_() * pushX, pushY + randomSource.m_188583_() * pushY, randomSource.m_188583_() * pushZ);
            level.m_7967_((Entity)fallingBlockEntity);
        }
    }

    public static void moveTrembleBlocks(Level level, int distance, Entity entity, double pushX, double pushY, double pushZ, boolean onlyRemains) {
        double perpFacing = (double)entity.m_6080_() * (Math.PI / 180);
        double facingAngle = perpFacing + 1.5707963267948966;
        int hitY = Mth.m_14107_((double)(entity.m_20191_().f_82289_ - 0.5));
        double spread = Math.PI * 2;
        int arcLen = Mth.m_14165_((double)((double)distance * spread));
        for (int i = 0; i < arcLen; ++i) {
            FallingBlockEntity fallingBlockEntity;
            double theta = ((double)i / ((double)arcLen - 1.0) - 0.5) * spread + facingAngle;
            double vx = Math.cos(theta);
            double vz = Math.sin(theta);
            double px = entity.m_20185_() + vx * (double)distance;
            double pz = entity.m_20189_() + vz * (double)distance;
            if (!ForgeEventFactory.getMobGriefingEvent((Level)level, (Entity)entity)) continue;
            int hitX = Mth.m_14107_((double)px);
            int hitZ = Mth.m_14107_((double)pz);
            RandomSource randomSource = level.m_213780_();
            BlockPos pos = new BlockPos(hitX, hitY, hitZ);
            BlockState block = level.m_8055_(pos);
            if (level.m_8055_(pos) == Blocks.f_50016_.m_49966_()) continue;
            if (onlyRemains) {
                if (!block.m_204336_(GenericBlockTags.Blocks.MOVABLE)) continue;
                fallingBlockEntity = new FallingBlockEntity(level, (double)hitX + 0.5, (double)hitY + 0.5, (double)hitZ + 0.5, block);
                level.m_7731_(pos, block.m_60819_().m_76188_(), 3);
                fallingBlockEntity.m_5997_(randomSource.m_188583_() * pushX, pushY + randomSource.m_188583_() * pushY, randomSource.m_188583_() * pushZ);
                level.m_7967_((Entity)fallingBlockEntity);
                continue;
            }
            fallingBlockEntity = new FallingBlockEntity(level, (double)hitX + 0.5, (double)hitY + 0.5, (double)hitZ + 0.5, block);
            level.m_7731_(pos, block.m_60819_().m_76188_(), 3);
            fallingBlockEntity.m_5997_(randomSource.m_188583_() * pushX, pushY + randomSource.m_188583_() * pushY, randomSource.m_188583_() * pushZ);
            level.m_7967_((Entity)fallingBlockEntity);
        }
    }

    public static void destroyBlocks(Level level, LivingEntity entity, double area, int destroySpeed, int randChance, SoundPacket soundPacket) {
        if (entity.f_19862_ && ForgeEventFactory.getMobGriefingEvent((Level)level, (Entity)entity)) {
            boolean flag = false;
            AABB aabb = entity.m_20191_().m_82400_(area);
            for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                BlockState blockstate = level.m_8055_(blockpos);
                Block block = blockstate.m_60734_();
                if (level.f_46441_.m_188503_(randChance) != 0 || !(blockstate.m_60800_((BlockGetter)level, blockpos) < (float)destroySpeed) || !(blockstate.m_60800_((BlockGetter)level, blockpos) >= 0.0f)) continue;
                level.m_5594_(null, entity.m_20183_(), soundPacket.getSoundEvent(), soundPacket.getSoundSource(), soundPacket.getVolume(), soundPacket.getPitch());
                flag = level.m_46953_(blockpos, false, (Entity)entity) || flag;
            }
        }
    }
}

