/*
 * Decompiled with CFR 0.152.
 */
package io.github.xiaocihua.stacktonearbychests;

import io.github.xiaocihua.stacktonearbychests.ModOptions;
import io.github.xiaocihua.stacktonearbychests.StackToNearbyChests;
import io.github.xiaocihua.stacktonearbychests.event.OnKeyCallback;
import io.github.xiaocihua.stacktonearbychests.event.SetScreenCallback;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.minecraft.class_1269;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_418;
import net.minecraft.class_7417;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public abstract class ForEachContainerTask {
    private static final ScheduledThreadPoolExecutor TIMER = new ScheduledThreadPoolExecutor(1);
    private static ForEachContainerTask currentTask;
    protected final class_310 client;
    protected final class_746 player;
    protected final Consumer<class_1703> action;
    private boolean interrupted;
    private final int searchInterval;
    @Nullable
    private ForEachContainerTask after;

    public ForEachContainerTask(class_310 client, class_746 player, Consumer<class_1703> action) {
        this.client = client;
        this.player = player;
        this.action = action;
        this.searchInterval = ModOptions.get().behavior.searchInterval.intValue();
    }

    public static void init() {
        SetScreenCallback.EVENT.register(screen -> {
            if (ForEachContainerTask.isRunning()) {
                if (screen instanceof class_418) {
                    currentTask.interrupt();
                    return class_1269.field_5811;
                }
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
        OnKeyCallback.PRESS.register(key -> {
            if (ForEachContainerTask.isRunning()) {
                if (key == 256) {
                    currentTask.interrupt();
                }
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
        ClientReceiveMessageEvents.GAME.register((message, overlay) -> {
            class_2588 translatable;
            class_7417 patt2381$temp;
            if (ForEachContainerTask.isRunning() && (patt2381$temp = message.method_10851()) instanceof class_2588 && (translatable = (class_2588)patt2381$temp).method_11022().equals("container.isLocked")) {
                ForEachContainerTask.getCurrentTask().openNextContainer();
            }
        });
    }

    public static ForEachContainerTask getCurrentTask() {
        return currentTask;
    }

    public static boolean isRunning() {
        return currentTask != null;
    }

    public void start() {
        currentTask = this;
        this.openNextContainerExceptionHandled();
    }

    protected void stop() {
        this.player.method_7346();
        TIMER.getQueue().clear();
        currentTask = null;
    }

    public void interrupt() {
        this.sendChatMessage("stack-to-nearby-chests.message.actionInterrupted");
        this.interrupted = true;
    }

    public void onInventory(class_1703 screenHandler) {
        this.clearTimeout();
        this.action.accept(screenHandler);
        this.openNextContainer();
    }

    private void openNextContainer() {
        if (this.interrupted) {
            this.stop();
            return;
        }
        if (this.searchInterval == 0) {
            this.openNextContainerExceptionHandled();
        } else {
            TIMER.schedule(() -> this.client.execute(this::openNextContainerExceptionHandled), (long)this.searchInterval, TimeUnit.MILLISECONDS);
        }
    }

    private void openNextContainerExceptionHandled() {
        try {
            if (this.findAndOpenNextContainer()) {
                this.setTimeout();
            } else if (this.after != null) {
                this.after.start();
            } else {
                this.stop();
            }
        }
        catch (Exception e) {
            this.sendChatMessage("stack-to-nearby-chests.message.exceptionOccurred");
            StackToNearbyChests.LOGGER.error("An exception occurred", (Throwable)e);
            this.stop();
        }
    }

    protected abstract boolean findAndOpenNextContainer();

    private void setTimeout() {
        TIMER.schedule(() -> this.client.execute(() -> {
            this.sendChatMessage("stack-to-nearby-chests.message.interruptedByTimeout");
            this.stop();
        }), 2L, TimeUnit.SECONDS);
    }

    private void clearTimeout() {
        TIMER.getQueue().clear();
    }

    public void thenStart(ForEachContainerTask after) {
        this.after = after;
    }

    private void sendChatMessage(String key) {
        class_310.method_1551().field_1705.method_1743().method_1812((class_2561)class_2561.method_43471((String)key));
    }
}

