/*
 * Decompiled with CFR 0.152.
 */
package io.github.xiaocihua.stacktonearbychests;

import io.github.xiaocihua.stacktonearbychests.event.OnKeyCallback;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1269;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import org.lwjgl.glfw.GLFW;

public final class KeySequence {
    public static final int MOUSE_BUTTON_CODE_OFFSET = 100;
    private static final IntArrayList PRESSING_KEYS = new IntArrayList();
    private List<Integer> keys;
    private final List<Integer> defaultKeys;

    public KeySequence(List<Integer> keys) {
        this.keys = new ArrayList<Integer>(keys);
        this.defaultKeys = new ArrayList<Integer>(keys);
    }

    public static KeySequence empty() {
        return new KeySequence(new ArrayList<Integer>());
    }

    public static void init() {
        OnKeyCallback.PRESS.register(key -> {
            PRESSING_KEYS.add(key);
            return class_1269.field_5811;
        });
        OnKeyCallback.RELEASE.register(key -> {
            PRESSING_KEYS.rem(key);
            return class_1269.field_5811;
        });
    }

    public static void reCheckPressedKeys() {
        IntListIterator intListIterator = PRESSING_KEYS.iterator();
        while (intListIterator.hasNext()) {
            int key = (Integer)intListIterator.next();
            if (KeySequence.isKeyPressed(key)) continue;
            PRESSING_KEYS.rem(key);
        }
    }

    public static boolean isKeyPressed(int key) {
        long window = class_310.method_1551().method_22683().method_4490();
        return KeySequence.isMouseButton(key) ? GLFW.glfwGetMouseButton((long)window, (int)(key + 100)) == 1 : class_3675.method_15987((long)window, (int)key);
    }

    private static boolean isMouseButton(int key) {
        return key < -1;
    }

    public void addKey(int key) {
        if (this.keys.size() >= 3) {
            this.keys.clear();
        }
        if (!this.keys.contains(key)) {
            this.keys.add(key);
        }
    }

    public boolean isEmpty() {
        return this.keys.isEmpty();
    }

    public boolean isPressed() {
        return !this.isEmpty() && PRESSING_KEYS.equals(this.keys);
    }

    public void addMouseButton(int button) {
        this.addKey(button - 100);
    }

    public void clear() {
        this.keys.clear();
    }

    public void reset() {
        this.keys = new ArrayList<Integer>(this.defaultKeys);
    }

    public class_2561 getLocalizedText() {
        if (this.keys.isEmpty()) {
            return class_2561.method_43471((String)"key.keyboard.unknown");
        }
        String localized = this.keys.stream().map(key -> {
            if (KeySequence.isMouseButton(key)) {
                return class_3675.class_307.field_1672.method_1447(key + 100);
            }
            return class_3675.class_307.field_1668.method_1447(key.intValue());
        }).map(key -> key.method_27445().getString()).collect(Collectors.joining(" + "));
        return class_2561.method_30163((String)localized);
    }

    public boolean testThenRun(Runnable action) {
        if (this.isPressed()) {
            action.run();
            return true;
        }
        return false;
    }

    public KeySequence register(Supplier<class_1269> action) {
        OnKeyCallback.PRESS.register(key -> {
            if (!this.keys.isEmpty() && PRESSING_KEYS.equals(this.keys)) {
                return (class_1269)action.get();
            }
            return class_1269.field_5811;
        });
        return this;
    }

    public KeySequence registerOnScreen(Class<? extends class_437> screenClass, Consumer<class_437> action, class_1269 result) {
        return this.register(() -> {
            class_437 currentScreen = class_310.method_1551().field_1755;
            if (screenClass.isInstance(currentScreen)) {
                action.accept(currentScreen);
                return result;
            }
            return class_1269.field_5811;
        });
    }

    public KeySequence registerNotOnScreen(Runnable action, class_1269 result) {
        return this.register(() -> {
            class_310 client = class_310.method_1551();
            if (client.field_1687 != null && client.field_1755 == null) {
                action.run();
                return result;
            }
            return class_1269.field_5811;
        });
    }
}

