/*
 * Decompiled with CFR 0.152.
 */
package io.github.xiaocihua.stacktonearbychests;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.xiaocihua.stacktonearbychests.ModOptions;
import io.github.xiaocihua.stacktonearbychests.StackToNearbyChests;
import io.github.xiaocihua.stacktonearbychests.event.ClickSlotCallback;
import io.github.xiaocihua.stacktonearbychests.event.DisconnectCallback;
import io.github.xiaocihua.stacktonearbychests.mixin.HandledScreenAccessor;
import io.github.xiaocihua.stacktonearbychests.mixin.MinecraftServerAccessor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_1058;
import net.minecraft.class_1132;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_642;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class LockedSlots {
    private static final Path LOCKED_SLOTS_FOLDER = ModOptions.MOD_OPTIONS_DIR.resolve("locked-slots");
    public static final List<class_2960> FAVORITE_ITEM_TAGS = List.of(new class_2960("stack-to-nearby-chests", "gold_badge"), new class_2960("stack-to-nearby-chests", "red_background"), new class_2960("stack-to-nearby-chests", "gold_border"), new class_2960("stack-to-nearby-chests", "iron_border"));
    private static HashSet<Integer> currentLockedSlots = new HashSet();
    private static boolean movingFavoriteItemStack = false;
    private static class_1735 quickMoveDestination;
    @Nullable
    private static class_1713 actionBeingExecuted;
    private static Optional<Path> currentLockedSlotsFilePath;

    public static void init() {
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            currentLockedSlotsFilePath = LockedSlots.getLockedSlotsFilePath(client);
            if (LockedSlots.isEnabled()) {
                currentLockedSlotsFilePath.ifPresentOrElse(LockedSlots::read, () -> StackToNearbyChests.LOGGER.info("Locked slots file path is empty"));
            }
        });
        DisconnectCallback.EVENT.register(() -> {
            if (LockedSlots.isEnabled()) {
                currentLockedSlotsFilePath.ifPresentOrElse(LockedSlots::write, () -> StackToNearbyChests.LOGGER.info("Locked slots file path is empty"));
            }
            currentLockedSlots.clear();
            currentLockedSlotsFilePath = Optional.empty();
        });
        ModOptions.get().keymap.markAsFavoriteKey.registerOnScreen(class_465.class, screen -> {
            double y;
            class_310 client = class_310.method_1551();
            double x = client.field_1729.method_1603() * (double)client.method_22683().method_4486() / (double)client.method_22683().method_4480();
            class_1735 slot = ((HandledScreenAccessor)screen).invokeGetSlotAt(x, y = client.field_1729.method_1604() * (double)client.method_22683().method_4502() / (double)client.method_22683().method_4507());
            if (!LockedSlots.unLock(slot) && slot != null && slot.method_7681()) {
                LockedSlots.lock(slot);
            }
        }, class_1269.field_5814);
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (screen instanceof class_465) {
                class_465 handledScreen = (class_465)screen;
                if (!LockedSlots.isEnabled()) {
                    currentLockedSlots.clear();
                }
                LockedSlots.refresh(handledScreen.method_17577());
                ScreenEvents.remove((class_437)screen).register(s -> {
                    movingFavoriteItemStack = false;
                });
            }
        });
        ClickSlotCallback.BEFORE.register((syncId, slotId, button, actionType, player) -> {
            class_1735 slot;
            class_1735 class_17352 = slot = slotId < 0 ? null : player.field_7512.method_7611(slotId);
            if (LockedSlots.isLocked(slot) && (actionType == class_1713.field_7790 && ModOptions.get().behavior.favoriteItemsCannotBePickedUp.booleanValue() || actionType == class_1713.field_7794 && ModOptions.get().behavior.favoriteItemStacksCannotBeQuickMoved.booleanValue() || actionType == class_1713.field_7791 && ModOptions.get().behavior.favoriteItemStacksCannotBeSwapped.booleanValue() || actionType == class_1713.field_7795 && ModOptions.get().behavior.favoriteItemStacksCannotBeThrown.booleanValue())) {
                return class_1269.field_5814;
            }
            actionBeingExecuted = actionType;
            return class_1269.field_5811;
        });
        ClickSlotCallback.AFTER.register((syncId, slotId, button, actionType, player) -> {
            LockedSlots.afterClickSlot(slotId, button, actionType, player);
            return class_1269.field_5811;
        });
    }

    private static void read(Path path) {
        StackToNearbyChests.LOGGER.info("Reading locked slot indices from {}", (Object)path.getFileName());
        try (BufferedReader reader = Files.newBufferedReader(path);){
            Type type = new TypeToken<HashSet<Integer>>(){}.getType();
            currentLockedSlots = (HashSet)new Gson().fromJson((Reader)reader, type);
        }
        catch (NoSuchFileException e) {
            StackToNearbyChests.LOGGER.info("Locked slots file does not exist");
        }
        catch (IOException e) {
            StackToNearbyChests.LOGGER.error("Failed to read locked slots file", (Throwable)e);
        }
    }

    private static void write(Path path) {
        StackToNearbyChests.LOGGER.info("Writing locked slot indices to {}", (Object)path.getFileName());
        try {
            Files.createDirectories(LOCKED_SLOTS_FOLDER, new FileAttribute[0]);
            String json = new Gson().toJson(currentLockedSlots);
            Files.writeString(path, (CharSequence)json, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            StackToNearbyChests.LOGGER.error("Failed to write locked slots file", (Throwable)e);
        }
    }

    private static Optional<Path> getLockedSlotsFilePath(class_310 client) {
        String fileName;
        class_1132 integratedServer = client.method_1576();
        class_642 currentServerEntry = client.method_1558();
        if (integratedServer != null) {
            fileName = ((MinecraftServerAccessor)integratedServer).getSession().method_27005().concat(".json");
        } else if (currentServerEntry != null) {
            fileName = currentServerEntry.field_3761.concat(".json").replace(":", "colon");
        } else {
            StackToNearbyChests.LOGGER.info("Could not get level name or server address");
            return Optional.empty();
        }
        return Optional.of(LOCKED_SLOTS_FOLDER.resolve(fileName));
    }

    private static boolean isEnabled() {
        return ModOptions.get().behavior.enableItemFavoriting.booleanValue();
    }

    private static boolean lock(@Nullable class_1735 slot) {
        return LockedSlots.isLockable(slot) && LockedSlots.lock(slot.method_34266());
    }

    private static boolean lock(int slotIndex) {
        return LockedSlots.isLockable(slotIndex) && currentLockedSlots.add(slotIndex);
    }

    private static boolean unLock(@Nullable class_1735 slot) {
        return LockedSlots.isLockable(slot) && LockedSlots.unLock(slot.method_34266());
    }

    private static boolean unLock(int slotIndex) {
        return LockedSlots.isLockable(slotIndex) && currentLockedSlots.remove(slotIndex);
    }

    private static boolean setLocked(int slotIndex, boolean locked) {
        return locked ? LockedSlots.lock(slotIndex) : LockedSlots.unLock(slotIndex);
    }

    public static boolean isLocked(@Nullable class_1735 slot) {
        return LockedSlots.isLockable(slot) && LockedSlots.isLocked(slot.method_34266());
    }

    public static boolean isLocked(int slotIndex) {
        return LockedSlots.isLockable(slotIndex) && currentLockedSlots.contains(slotIndex);
    }

    private static boolean isLockable(@Nullable class_1735 slot) {
        return LockedSlots.isEnabled() && slot != null && slot.field_7871 instanceof class_1661 && !class_310.method_1551().field_1724.method_31549().field_7477;
    }

    private static boolean isLockable(int slotIndex) {
        return LockedSlots.isEnabled() && slotIndex >= 0 && slotIndex != 39 && slotIndex != 38 && slotIndex != 37 && slotIndex != 36;
    }

    public static void onSetStack(int slotIndex, class_1799 stack) {
        if (stack.method_7960()) {
            if (actionBeingExecuted == null) {
                if (!StackToNearbyChests.IS_EASY_SHULKER_BOXES_MOD_LOADED) {
                    LockedSlots.unLock(slotIndex);
                }
            } else if (actionBeingExecuted == class_1713.field_7795) {
                LockedSlots.unLock(slotIndex);
            } else if (actionBeingExecuted == class_1713.field_7793 && LockedSlots.unLock(slotIndex)) {
                movingFavoriteItemStack = true;
            }
        }
    }

    public static void onInsertItem(class_1735 destination) {
        quickMoveDestination = destination;
    }

    private static void afterClickSlot(int slotId, int button, class_1713 actionType, class_1657 player) {
        class_1703 screenHandler = player.field_7512;
        @Nullable class_1735 slot = slotId < 0 ? null : screenHandler.method_7611(slotId);
        switch (actionType) {
            case field_7790: {
                if (slotId == -999) {
                    movingFavoriteItemStack = false;
                }
                if (slot == null) break;
                class_1799 cursorStack = screenHandler.method_34255();
                class_1799 slotStack = slot.method_7677();
                if (movingFavoriteItemStack) {
                    if (cursorStack.method_7960()) {
                        LockedSlots.lock(slot);
                        movingFavoriteItemStack = false;
                        break;
                    }
                    if (class_1799.method_31577((class_1799)cursorStack, (class_1799)slotStack)) break;
                    if (!LockedSlots.isLocked(slot)) {
                        movingFavoriteItemStack = false;
                    }
                    LockedSlots.lock(slot);
                    break;
                }
                if (LockedSlots.isLocked(slot) && slotStack.method_7960()) {
                    LockedSlots.unLock(slot);
                    movingFavoriteItemStack = true;
                    break;
                }
                if (cursorStack.method_7960() || class_1799.method_31577((class_1799)cursorStack, (class_1799)slotStack)) break;
                if (LockedSlots.isLocked(slot)) {
                    movingFavoriteItemStack = true;
                }
                LockedSlots.unLock(slot);
                break;
            }
            case field_7794: {
                if (slot == null || !LockedSlots.isLocked(slot) || slot.method_7681()) break;
                LockedSlots.unLock(slot);
                LockedSlots.lock(quickMoveDestination);
                break;
            }
            case field_7791: {
                boolean isFromSlotLocked = LockedSlots.unLock(slot);
                boolean isToSlotLocked = LockedSlots.unLock(button);
                if (isFromSlotLocked) {
                    LockedSlots.lock(button);
                }
                if (!isToSlotLocked) break;
                LockedSlots.lock(slot);
                break;
            }
            case field_7789: {
                if (screenHandler.method_34255().method_7960()) {
                    movingFavoriteItemStack = false;
                    break;
                }
                if (!movingFavoriteItemStack) break;
                LockedSlots.lock(slot);
            }
        }
        actionBeingExecuted = null;
    }

    private static boolean refresh(class_1703 screenHandler) {
        return screenHandler.field_7761.stream().filter(Predicate.not(class_1735::method_7681)).map(LockedSlots::unLock).reduce(Boolean::logicalOr).orElse(false);
    }

    public static void onSetGameMode(class_1934 gameMode) {
        if (gameMode == class_1934.field_9220) {
            currentLockedSlots.clear();
        }
    }

    public static void drawFavoriteItemStyle(class_4587 matrices, class_1735 slot, boolean isForeground) {
        ModOptions options = ModOptions.get();
        if (!(options.appearance.alwaysShowMarkersForFavoritedItems.booleanValue() || options.keymap.showMarkersForFavoritedItemsKey.isPressed() || options.keymap.markAsFavoriteKey.isPressed())) {
            return;
        }
        class_2960 id = options.appearance.favoriteItemStyle;
        if (LockedSlots.isLocked(slot) && isForeground == id.method_12832().equals("gold_badge")) {
            class_1058 sprite = (class_1058)class_310.method_1551().method_1549(class_1723.field_21668).apply(new class_2960(id.method_12836(), "item/" + id.method_12832()));
            RenderSystem.setShaderTexture((int)0, (class_2960)sprite.method_45852());
            class_332.method_25298((class_4587)matrices, (int)slot.field_7873, (int)slot.field_7872, (int)(isForeground ? 300 : 200), (int)16, (int)16, (class_1058)sprite);
        }
    }

    public static class_1269 beforeDropSelectedItem(int selectedSlotIndex) {
        if (LockedSlots.isLocked(selectedSlotIndex) && ModOptions.get().behavior.favoriteItemStacksCannotBeThrown.booleanValue()) {
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    public static void afterDropSelectedItem(int selectedSlotIndex) {
        if (LockedSlots.isLocked(selectedSlotIndex) && !((class_1735)class_310.method_1551().field_1724.field_7498.field_7761.get(selectedSlotIndex)).method_7681()) {
            LockedSlots.unLock(selectedSlotIndex);
        }
    }

    public static class_1269 onSwapItemWithOffhand() {
        int selectedSlotIndex = class_310.method_1551().field_1724.method_31548().field_7545;
        boolean isSelectedSlotLocked = LockedSlots.isLocked(selectedSlotIndex);
        if (isSelectedSlotLocked && ModOptions.get().behavior.favoriteItemsCannotBeSwappedWithOffhand.booleanValue()) {
            return class_1269.field_5814;
        }
        LockedSlots.setLocked(selectedSlotIndex, LockedSlots.isLocked(40));
        LockedSlots.setLocked(40, isSelectedSlotLocked);
        return class_1269.field_5811;
    }

    static {
        currentLockedSlotsFilePath = Optional.empty();
    }
}

