/*
 * Decompiled with CFR 0.152.
 */
package io.github.xiaocihua.stacktonearbychests.gui;

import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.widget.WButton;
import io.github.cottonmc.cotton.gui.widget.data.HorizontalAlignment;
import io.github.cottonmc.cotton.gui.widget.icon.Icon;
import java.util.OptionalInt;
import net.minecraft.class_2561;
import net.minecraft.class_4587;
import net.minecraft.class_5481;

public class FlatColorButton
extends WButton {
    private int regularColor = 0;
    private int hoveredColor = 0x14FFFFFF;
    private int disabledColor = 0;
    private OptionalInt borderColor = OptionalInt.empty();

    public FlatColorButton() {
    }

    public FlatColorButton(class_2561 text) {
        super(text);
    }

    public FlatColorButton(Icon icon, class_2561 text) {
        super(icon, text);
    }

    public FlatColorButton(int regularColor, int hoveredColor, int disabledColor) {
        this.regularColor = regularColor;
        this.hoveredColor = hoveredColor;
        this.disabledColor = disabledColor;
    }

    public FlatColorButton(class_2561 text, int regularColor, int hoveredColor, int disabledColor) {
        super(text);
        this.regularColor = regularColor;
        this.hoveredColor = hoveredColor;
        this.disabledColor = disabledColor;
    }

    public FlatColorButton setBorder() {
        return this.setBorder(-9342607);
    }

    public FlatColorButton setBorder(int color) {
        this.borderColor = OptionalInt.of(color);
        return this;
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void paint(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
        boolean hovered = mouseX >= 0 && mouseY >= 0 && mouseX < this.getWidth() && mouseY < this.getHeight();
        boolean enabled = this.isEnabled();
        Icon icon = this.getIcon();
        class_2561 label = this.getLabel();
        if (!enabled) {
            ScreenDrawing.coloredRect((class_4587)matrices, (int)x, (int)y, (int)this.width, (int)this.height, (int)this.disabledColor);
        } else if (hovered || this.isFocused()) {
            ScreenDrawing.coloredRect((class_4587)matrices, (int)x, (int)y, (int)this.width, (int)this.height, (int)this.hoveredColor);
        } else {
            ScreenDrawing.coloredRect((class_4587)matrices, (int)x, (int)y, (int)this.width, (int)this.height, (int)this.regularColor);
        }
        this.borderColor.ifPresent(color -> this.drawBorder(matrices, x, y, this.width, this.height, color));
        if (icon != null) {
            icon.paint(matrices, x + 2, y + 2, 16);
        }
        if (label != null) {
            int color2 = 0xE0E0E0;
            if (!enabled) {
                color2 = 0xA0A0A0;
            }
            int xOffset = icon != null && this.alignment == HorizontalAlignment.LEFT ? 18 : 0;
            ScreenDrawing.drawStringWithShadow((class_4587)matrices, (class_5481)label.method_30937(), (HorizontalAlignment)this.alignment, (int)(x + xOffset), (int)(y + (this.height - 8) / 2), (int)this.width, (int)color2);
        }
    }

    protected void drawBorder(class_4587 matrices, int x, int y, int width, int height, int color) {
        ScreenDrawing.coloredRect((class_4587)matrices, (int)x, (int)y, (int)width, (int)1, (int)color);
        ScreenDrawing.coloredRect((class_4587)matrices, (int)x, (int)(y + height - 1), (int)width, (int)1, (int)color);
        ScreenDrawing.coloredRect((class_4587)matrices, (int)x, (int)y, (int)1, (int)height, (int)color);
        ScreenDrawing.coloredRect((class_4587)matrices, (int)(x + width - 1), (int)y, (int)1, (int)height, (int)color);
    }
}

