/*
 * Decompiled with CFR 0.152.
 */
package io.github.xiaocihua.stacktonearbychests.gui;

import io.github.cottonmc.cotton.gui.widget.WBox;
import io.github.cottonmc.cotton.gui.widget.WButton;
import io.github.cottonmc.cotton.gui.widget.WText;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.Axis;
import io.github.cottonmc.cotton.gui.widget.data.InputResult;
import io.github.cottonmc.cotton.gui.widget.data.VerticalAlignment;
import io.github.xiaocihua.stacktonearbychests.KeySequence;
import io.github.xiaocihua.stacktonearbychests.gui.FlatColorButton;
import net.minecraft.class_2561;
import net.minecraft.class_4587;

public class KeymapEntry
extends WBox {
    private static final int KEYBINDING_WIDTH = 165;
    private static final int RESET_BUTTON_WIDTH = 55;
    private final WText text;
    private final KeyBindingWidget keybinding;
    private final WButton resetButton;

    public KeymapEntry(class_2561 text, KeySequence keySequence) {
        super(Axis.HORIZONTAL);
        this.text = new WText(text, 0xF5F5F5).setVerticalAlignment(VerticalAlignment.CENTER);
        this.add((WWidget)this.text);
        this.keybinding = new KeyBindingWidget(keySequence);
        this.add((WWidget)this.keybinding);
        this.resetButton = new FlatColorButton((class_2561)class_2561.method_43471((String)"stack-to-nearby-chests.options.reset")).setBorder().setOnClick(this.keybinding::reset);
        this.add((WWidget)this.resetButton);
    }

    public void layout() {
        this.text.setSize(this.width - 165 - 55 - this.spacing, this.height);
        this.keybinding.setSize(165 - this.spacing, this.height);
        this.resetButton.setSize(55, this.height);
        super.layout();
    }

    private static class KeyBindingWidget
    extends FlatColorButton {
        private final KeySequence keySequence;

        public KeyBindingWidget(KeySequence keySequence) {
            super(-14277082, 0, 0);
            this.keySequence = keySequence;
            this.setLabel();
        }

        public void reset() {
            this.keySequence.reset();
            this.setLabel();
        }

        public InputResult onClick(int x, int y, int button) {
            if (this.isFocused()) {
                this.keySequence.addMouseButton(button);
            } else {
                this.requestFocus();
            }
            this.setLabel();
            return InputResult.PROCESSED;
        }

        public InputResult onKeyPressed(int ch, int key, int modifiers) {
            switch (ch) {
                case 257: {
                    this.releaseFocus();
                    break;
                }
                case 259: {
                    this.keySequence.clear();
                    break;
                }
                default: {
                    this.keySequence.addKey(ch);
                }
            }
            this.setLabel();
            return InputResult.PROCESSED;
        }

        private void setLabel() {
            this.setLabel(this.keySequence.getLocalizedText());
        }

        @Override
        public void paint(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
            if (this.isFocused()) {
                this.drawBorder(matrices, x, y, this.width, this.height, -657931);
            }
            super.paint(matrices, x, y, mouseX, mouseY);
        }
    }
}

