/*
 * Decompiled with CFR 0.152.
 */
package io.github.xiaocihua.stacktonearbychests.gui;

import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.client.BackgroundPainter;
import io.github.cottonmc.cotton.gui.client.LightweightGuiDescription;
import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.widget.TooltipBuilder;
import io.github.cottonmc.cotton.gui.widget.WBox;
import io.github.cottonmc.cotton.gui.widget.WButton;
import io.github.cottonmc.cotton.gui.widget.WLabel;
import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WPlainPanel;
import io.github.cottonmc.cotton.gui.widget.WToggleButton;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.Axis;
import io.github.cottonmc.cotton.gui.widget.data.HorizontalAlignment;
import io.github.cottonmc.cotton.gui.widget.data.InputResult;
import io.github.cottonmc.cotton.gui.widget.data.Insets;
import io.github.cottonmc.cotton.gui.widget.data.VerticalAlignment;
import io.github.cottonmc.cotton.gui.widget.icon.Icon;
import io.github.cottonmc.cotton.gui.widget.icon.TextureIcon;
import io.github.xiaocihua.stacktonearbychests.LockedSlots;
import io.github.xiaocihua.stacktonearbychests.ModOptions;
import io.github.xiaocihua.stacktonearbychests.gui.BlackWhiteList;
import io.github.xiaocihua.stacktonearbychests.gui.BlockContainerEntry;
import io.github.xiaocihua.stacktonearbychests.gui.EntityContainerEntry;
import io.github.xiaocihua.stacktonearbychests.gui.EntryPicker;
import io.github.xiaocihua.stacktonearbychests.gui.FlatColorButton;
import io.github.xiaocihua.stacktonearbychests.gui.ItemEntry;
import io.github.xiaocihua.stacktonearbychests.gui.KeymapEntry;
import io.github.xiaocihua.stacktonearbychests.gui.TextFieldWithLabel;
import io.github.xiaocihua.stacktonearbychests.gui.WBoxCustom;
import io.github.xiaocihua.stacktonearbychests.gui.WScrollPanelCustom;
import io.github.xiaocihua.stacktonearbychests.gui.WTabPanelCustom;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModOptionsGui
extends LightweightGuiDescription {
    public static final String PREFIX = "stack-to-nearby-chests.options.";
    public static final int TEXT_COLOR = 0xF5F5F5;
    public static final BackgroundPainter BACKGROUND_DARK = BackgroundPainter.createNinePatch((class_2960)new class_2960("stack-to-nearby-chests", "textures/background_dark.png"));
    public static final BackgroundPainter BACKGROUND_LIGHT = BackgroundPainter.createNinePatch((class_2960)new class_2960("stack-to-nearby-chests", "textures/background_light.png"));
    private static final class_2960 CHECKED = new class_2960("stack-to-nearby-chests", "textures/checkbox_checked.png");
    private static final class_2960 UNCHECKED = new class_2960("stack-to-nearby-chests", "textures/checkbox_unchecked.png");
    private static final int ROOT_WIDTH = 400;
    private final WPlainPanel root;
    @Nullable
    private WPanel currentDialog;
    private final ModOptions options = ModOptions.get();

    public ModOptionsGui() {
        this.root = new WPlainPanel();
        this.setRootPanel((WPanel)this.root);
        this.root.setSize(400, 240);
        this.root.add((WWidget)this.createTitle(), 0, 0, 400, 20);
        this.root.add((WWidget)this.createTabs(), 0, 20, 400, 188);
        this.root.add((WWidget)this.createBottomBar(), 0, 208, 400, 32);
        this.root.validate((GuiDescription)this);
    }

    private WLabel createTitle() {
        return new WLabel((class_2561)class_2561.method_43471((String)"stack-to-nearby-chests.options.title"), 0xF5F5F5).setVerticalAlignment(VerticalAlignment.CENTER).setHorizontalAlignment(HorizontalAlignment.CENTER);
    }

    @NotNull
    private WTabPanelCustom createTabs() {
        WTabPanelCustom tabs = new WTabPanelCustom();
        tabs.add((WWidget)new WScrollPanelCustom((WWidget)this.createAppearance()), builder -> builder.title((class_2561)class_2561.method_43471((String)"stack-to-nearby-chests.options.appearance")));
        tabs.add((WWidget)new WScrollPanelCustom((WWidget)this.createBehavior()), builder -> builder.title((class_2561)class_2561.method_43471((String)"stack-to-nearby-chests.options.behavior")));
        tabs.add((WWidget)new WScrollPanelCustom((WWidget)this.createKeymap()), builder -> builder.title((class_2561)class_2561.method_43471((String)"stack-to-nearby-chests.options.keymap")));
        return tabs;
    }

    @NotNull
    private WBox createAppearance() {
        WBox appearance = this.createCard();
        class_5250 favoriteItemStyleLabel = class_2561.method_43471((String)"stack-to-nearby-chests.options.favoriteItemStyle");
        FlatColorButton favoriteItemStyle = new FlatColorButton(){
            private int index;
            {
                this.index = LockedSlots.FAVORITE_ITEM_TAGS.indexOf(ModOptionsGui.this.options.appearance.favoriteItemStyle);
                this.setCurrent(ModOptionsGui.this.options.appearance.favoriteItemStyle);
            }

            public InputResult onClick(int x, int y, int button) {
                int amount = class_437.method_25442() ? -1 : 1;
                this.index = class_3532.method_15387((int)(this.index + amount), (int)LockedSlots.FAVORITE_ITEM_TAGS.size());
                this.setCurrent(LockedSlots.FAVORITE_ITEM_TAGS.get(this.index));
                return super.onClick(x, y, button);
            }

            public void setCurrent(class_2960 id) {
                super.setLabel((class_2561)class_2561.method_43471((String)("stack-to-nearby-chests.resource." + id.method_12832())));
                super.setIcon((Icon)new TextureIcon(new class_2960(id.method_12836(), String.format(Locale.ROOT, "textures/item/%s%s", id.method_12832(), ".png"))));
                ModOptionsGui.this.options.appearance.favoriteItemStyle = id;
            }

            @Override
            public void paint(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
                ScreenDrawing.texturedRect((class_4587)matrices, (int)(x + 1), (int)(y + 1), (int)18, (int)18, (class_2960)new class_2960("stack-to-nearby-chests", "textures/slot_background.png"), (int)-1);
                super.paint(matrices, x, y, mouseX, mouseY);
            }
        };
        favoriteItemStyle.setBorder();
        appearance.add((WWidget)this.createLabeled((class_2561)favoriteItemStyleLabel, (WWidget)favoriteItemStyle, 160), 350, 20);
        WToggleButton alwaysShowMarkersForFavoritedItemsCheckBox = this.createCheckbox("alwaysShowMarkersForFavoritedItems", this.options.appearance.alwaysShowMarkersForFavoritedItems, class_310.method_1551().field_1772.method_1728((class_5348)class_2561.method_43471((String)"stack-to-nearby-chests.options.alwaysShowMarkersForFavoritedItems.tooltip"), 150));
        appearance.add((WWidget)alwaysShowMarkersForFavoritedItemsCheckBox);
        appearance.add((WWidget)this.createCheckbox("showStackToNearbyContainersButton", this.options.appearance.showStackToNearbyContainersButton));
        appearance.add((WWidget)this.createCheckbox("showRestockFromNearbyContainersButton", this.options.appearance.showRestockFromNearbyContainersButton));
        appearance.add((WWidget)this.createCheckbox("showQuickStackButton", this.options.appearance.showQuickStackButton));
        appearance.add((WWidget)this.createCheckbox("showRestockButton", this.options.appearance.showRestockButton));
        appearance.add((WWidget)this.createCheckbox("showTheButtonsOnTheCreativeInventoryScreen", this.options.appearance.showTheButtonsOnTheCreativeInventoryScreen));
        appearance.add((WWidget)this.createCheckbox("showButtonTooltip", this.options.appearance.showButtonTooltip));
        appearance.add((WWidget)this.createIntTextField("stackToNearbyContainersButtonPosX", this.options.appearance.stackToNearbyContainersButtonPosX), 362, 20);
        appearance.add((WWidget)this.createIntTextField("stackToNearbyContainersButtonPosY", this.options.appearance.stackToNearbyContainersButtonPosY), 362, 20);
        appearance.add((WWidget)this.createIntTextField("restockFromNearbyContainersButtonPosX", this.options.appearance.restockFromNearbyContainersButtonPosX), 360, 20);
        appearance.add((WWidget)this.createIntTextField("restockFromNearbyContainersButtonPosY", this.options.appearance.restockFromNearbyContainersButtonPosY), 360, 20);
        String tooltip = "stack-to-nearby-chests.options.buttonPos.tooltip";
        appearance.add((WWidget)this.createIntTextField("quickStackButtonPosX", this.options.appearance.quickStackButtonPosX).withTooltip(tooltip), 250, 20);
        appearance.add((WWidget)this.createIntTextField("quickStackButtonPosY", this.options.appearance.quickStackButtonPosY).withTooltip(tooltip), 250, 20);
        appearance.add((WWidget)this.createIntTextField("restockButtonPosX", this.options.appearance.restockButtonPosX).withTooltip(tooltip), 235, 20);
        appearance.add((WWidget)this.createIntTextField("restockButtonPosY", this.options.appearance.restockButtonPosY).withTooltip(tooltip), 235, 20);
        return appearance;
    }

    @NotNull
    private WBox createBehavior() {
        WBox behavior = this.createCard();
        TextFieldWithLabel searchInterval = this.createIntTextField("searchInterval", this.options.behavior.searchInterval).withTooltip("stack-to-nearby-chests.options.searchInterval.tooltip");
        searchInterval.getTextField().setTextPredicate(text -> NumberUtils.toInt((String)text, (int)-1) >= 0);
        behavior.add((WWidget)searchInterval, 230, 20);
        behavior.add((WWidget)this.createCheckbox("supportForContainerEntities", this.options.behavior.supportForContainerEntities));
        behavior.add((WWidget)this.createCheckbox("doNotQuickStackItemsFromTheHotbar", this.options.behavior.doNotQuickStackItemsFromTheHotbar));
        behavior.add((WWidget)this.createCheckbox("enableItemFavoriting", this.options.behavior.enableItemFavoriting));
        behavior.add((WWidget)this.createCheckbox("favoriteItemsCannotBePickedUp", this.options.behavior.favoriteItemsCannotBePickedUp));
        behavior.add((WWidget)this.createCheckbox("favoriteItemStacksCannotBeQuickMoved", this.options.behavior.favoriteItemStacksCannotBeQuickMoved));
        behavior.add((WWidget)this.createCheckbox("favoriteItemStacksCannotBeSwapped", this.options.behavior.favoriteItemStacksCannotBeSwapped));
        behavior.add((WWidget)this.createCheckbox("favoriteItemStacksCannotBeThrown", this.options.behavior.favoriteItemStacksCannotBeThrown));
        behavior.add((WWidget)this.createCheckbox("favoriteItemsCannotBeSwappedWithOffhand", this.options.behavior.favoriteItemsCannotBeSwappedWithOffhand));
        BlackWhiteList stackingTargets = new BlackWhiteList((class_2561)class_2561.method_43471((String)"stack-to-nearby-chests.options.stackingTargets"), this.options.behavior.stackingTargets, BlockContainerEntry::new, consumer -> this.openDialog(new EntryPicker.BlockContainerPicker((Consumer<List<class_2960>>)consumer)), data -> {
            this.options.behavior.stackingTargets = data;
        });
        behavior.add((WWidget)stackingTargets, 230, 124);
        BlackWhiteList stackingTargetEntities = new BlackWhiteList((class_2561)class_2561.method_43471((String)"stack-to-nearby-chests.options.stackingTargetEntities"), this.options.behavior.stackingTargetEntities, EntityContainerEntry::new, consumer -> this.openDialog(new EntryPicker.EntityContainerPicker((Consumer<List<class_2960>>)consumer)), data -> {
            this.options.behavior.stackingTargetEntities = data;
        });
        behavior.add((WWidget)stackingTargetEntities, 230, 124);
        BlackWhiteList itemsThatWillNotBeStacked = new BlackWhiteList((class_2561)class_2561.method_43471((String)"stack-to-nearby-chests.options.itemsThatWillNotBeStacked"), this.options.behavior.itemsThatWillNotBeStacked, ItemEntry::new, consumer -> this.openDialog(new EntryPicker.ItemPicker((Consumer<List<class_2960>>)consumer)), data -> {
            this.options.behavior.itemsThatWillNotBeStacked = data;
        });
        behavior.add((WWidget)itemsThatWillNotBeStacked, 230, 124);
        BlackWhiteList restockingSources = new BlackWhiteList((class_2561)class_2561.method_43471((String)"stack-to-nearby-chests.options.restockingSources"), this.options.behavior.restockingSources, BlockContainerEntry::new, consumer -> this.openDialog(new EntryPicker.BlockContainerPicker((Consumer<List<class_2960>>)consumer)), data -> {
            this.options.behavior.restockingSources = data;
        });
        behavior.add((WWidget)restockingSources, 230, 124);
        BlackWhiteList restockingSourceEntities = new BlackWhiteList((class_2561)class_2561.method_43471((String)"stack-to-nearby-chests.options.restockingSourceEntities"), this.options.behavior.restockingSourceEntities, EntityContainerEntry::new, consumer -> this.openDialog(new EntryPicker.EntityContainerPicker((Consumer<List<class_2960>>)consumer)), data -> {
            this.options.behavior.restockingSourceEntities = data;
        });
        behavior.add((WWidget)restockingSourceEntities, 230, 124);
        BlackWhiteList itemsThatWillNotBeRestocked = new BlackWhiteList((class_2561)class_2561.method_43471((String)"stack-to-nearby-chests.options.itemsThatWillNotBeRestocked"), this.options.behavior.itemsThatWillNotBeRestocked, ItemEntry::new, consumer -> this.openDialog(new EntryPicker.ItemPicker((Consumer<List<class_2960>>)consumer)), data -> {
            this.options.behavior.itemsThatWillNotBeRestocked = data;
        });
        behavior.add((WWidget)itemsThatWillNotBeRestocked, 230, 124);
        return behavior;
    }

    private WBox createKeymap() {
        WBox keymap = this.createCard().setSpacing(10);
        keymap.add((WWidget)new KeymapEntry((class_2561)class_2561.method_43471((String)"stack-to-nearby-chests.options.stackToNearbyContainers"), this.options.keymap.stackToNearbyContainersKey), 380, 18);
        keymap.add((WWidget)new KeymapEntry((class_2561)class_2561.method_43471((String)"stack-to-nearby-chests.options.quickStackItemsOfTheSameTypeAsTheOneUnderTheCursorToNearbyContainers"), this.options.keymap.quickStackItemsOfTheSameTypeAsTheOneUnderTheCursorToNearbyContainersKey), 380, 18);
        keymap.add((WWidget)new KeymapEntry((class_2561)class_2561.method_43471((String)"stack-to-nearby-chests.options.restockFromNearbyContainers"), this.options.keymap.restockFromNearbyContainersKey), 380, 18);
        keymap.add((WWidget)new KeymapEntry((class_2561)class_2561.method_43471((String)"stack-to-nearby-chests.options.quickStack"), this.options.keymap.quickStackKey), 380, 18);
        keymap.add((WWidget)new KeymapEntry((class_2561)class_2561.method_43471((String)"stack-to-nearby-chests.options.restock"), this.options.keymap.restockKey), 380, 18);
        keymap.add((WWidget)new KeymapEntry((class_2561)class_2561.method_43471((String)"stack-to-nearby-chests.options.markAsFavorite"), this.options.keymap.markAsFavoriteKey), 380, 18);
        keymap.add((WWidget)new KeymapEntry((class_2561)class_2561.method_43471((String)"stack-to-nearby-chests.options.showMarkersForFavoritedItems"), this.options.keymap.showMarkersForFavoritedItemsKey), 380, 18);
        keymap.add((WWidget)new KeymapEntry((class_2561)class_2561.method_43471((String)"stack-to-nearby-chests.options.openModOptionsScreen"), this.options.keymap.openModOptionsScreenKey), 380, 18);
        WLabel hint = new WLabel((class_2561)class_2561.method_43471((String)"stack-to-nearby-chests.options.keyMapHint").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(true))), 0xBFBFBF).setVerticalAlignment(VerticalAlignment.CENTER);
        keymap.add((WWidget)hint);
        return keymap;
    }

    private WBox createBottomBar() {
        WBoxCustom bottom = (WBoxCustom)new WBoxCustom(Axis.HORIZONTAL).setInsets(new Insets(7)).setHorizontalAlignment(HorizontalAlignment.CENTER);
        WButton doneButton = new FlatColorButton((class_2561)class_2561.method_43471((String)"stack-to-nearby-chests.options.done")).setBorder().setOnClick(() -> {
            this.options.write();
            class_310.method_1551().field_1755.method_25419();
        });
        bottom.add((WWidget)doneButton, 160);
        return bottom;
    }

    private WBox createCard() {
        return new WBox(Axis.VERTICAL).setInsets(Insets.ROOT_PANEL).setSpacing(10);
    }

    private WBox createLabeled(class_2561 label, WWidget widget, int widgetWidth) {
        WBoxCustom wBox = new WBoxCustom(Axis.HORIZONTAL);
        wBox.add((WWidget)new WLabel(label, 0xF5F5F5).setVerticalAlignment(VerticalAlignment.CENTER), class_310.method_1551().field_1772.method_30880(label.method_30937()));
        wBox.add(widget, widgetWidth);
        return wBox;
    }

    private WToggleButton createCheckbox(String s, MutableBoolean isOn) {
        return this.createCheckbox(s, isOn, null);
    }

    private WToggleButton createCheckbox(String s, MutableBoolean isOn, final @Nullable List<class_5481> tooltip) {
        WToggleButton checkbox = new WToggleButton(CHECKED, UNCHECKED, (class_2561)class_2561.method_43471((String)(PREFIX + s))){

            public void addTooltip(TooltipBuilder builder) {
                if (tooltip != null) {
                    builder.add(tooltip.toArray(new class_5481[0]));
                }
            }
        };
        checkbox.setColor(0xF5F5F5, 0xF5F5F5);
        checkbox.setToggle(isOn.booleanValue());
        checkbox.setOnToggle(arg_0 -> ((MutableBoolean)isOn).setValue(arg_0));
        return checkbox;
    }

    private TextFieldWithLabel createIntTextField(String s, ModOptions.IntOption value) {
        TextFieldWithLabel textField = new TextFieldWithLabel((class_2561)class_2561.method_43471((String)(PREFIX + s)), 0xF5F5F5, value::reset);
        textField.getTextField().setText(String.valueOf(value.intValue()));
        textField.getTextField().setChangedListener(text -> value.setValue(NumberUtils.toInt((String)text)));
        textField.getTextField().setTextPredicate(text -> text.matches("-?\\d+"));
        return textField;
    }

    public void openDialog(EntryPicker dialog) {
        if (this.currentDialog == null) {
            WPlainPanel operationBlockingPanel = new WPlainPanel();
            this.root.add((WWidget)operationBlockingPanel, this.root.getX(), this.root.getY(), this.root.getWidth(), this.root.getHeight());
            this.currentDialog = dialog;
            int width = dialog.getWidth();
            int height = dialog.getHeight();
            this.root.add((WWidget)dialog, (this.root.getWidth() - width) / 2, (this.root.getHeight() - height) / 2, width, height);
            dialog.setOnClose(() -> {
                this.currentDialog = null;
                this.root.remove((WWidget)dialog);
                this.root.remove((WWidget)operationBlockingPanel);
            });
            this.root.validate((GuiDescription)this);
        }
    }

    public void addPainters() {
        if (this.rootPanel != null && !this.fullscreen) {
            this.rootPanel.setBackgroundPainter(BACKGROUND_DARK);
        }
    }
}

