/*
 * Decompiled with CFR 0.152.
 */
package io.github.xiaocihua.stacktonearbychests.gui;

import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.client.BackgroundPainter;
import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WScrollBar;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.Axis;
import io.github.cottonmc.cotton.gui.widget.data.InputResult;
import io.github.xiaocihua.stacktonearbychests.gui.WClippedPanelCustom;
import io.github.xiaocihua.stacktonearbychests.gui.WScrollBarCustom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_4587;

public class SelectableEntryList<D>
extends WClippedPanelCustom {
    private final List<Entry<D>> requiresHost = new ArrayList<Entry<D>>();
    private final List<D> selectedData = new ArrayList<D>();
    protected List<D> data;
    protected Function<D, Entry<D>> supplier;
    protected HashMap<D, Entry<D>> configured = new HashMap();
    protected List<Entry<D>> unconfigured = new ArrayList<Entry<D>>();
    protected int cellHeight = 20;
    protected int margin = 0;
    protected WScrollBar scrollBar = new WScrollBarCustom(Axis.VERTICAL);
    private int lastScroll = -1;
    private Optional<Consumer<List<D>>> changedListener = Optional.empty();

    public SelectableEntryList(Collection<D> data, Function<D, Entry<D>> supplier) {
        this.data = new ArrayList<D>(data);
        this.supplier = supplier;
        this.scrollBar.setMaxValue(data.size());
        this.scrollBar.setParent((WPanel)this);
    }

    public void addData(Collection<D> data) {
        this.data.addAll(data);
        this.data = this.data.stream().distinct().collect(Collectors.toList());
        this.onChanged();
        this.layout();
    }

    public void setData(List<D> data) {
        this.data = data;
        this.onChanged();
        this.layout();
    }

    public List<D> getSelectedData() {
        return this.selectedData;
    }

    public void removeSelected() {
        this.data.removeAll(this.selectedData);
        this.onChanged();
        this.configured.clear();
        this.unconfigured.clear();
        this.selectedData.clear();
        this.layout();
    }

    public SelectableEntryList<D> setChangedListener(Consumer<List<D>> changedListener) {
        this.changedListener = Optional.ofNullable(changedListener);
        return this;
    }

    private void onChanged() {
        this.changedListener.ifPresent(listener -> listener.accept(this.data));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void paint(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
        ScreenDrawing.coloredRect((class_4587)matrices, (int)x, (int)y, (int)this.width, (int)this.height, (int)-14277082);
        if (this.scrollBar.getValue() != this.lastScroll) {
            this.layout();
            this.lastScroll = this.scrollBar.getValue();
        }
        super.paint(matrices, x, y, mouseX, mouseY);
    }

    private Entry<D> createChild(D d) {
        Entry<D> child = this.supplier.apply(d);
        child.setParent(this);
        child.setParentList(this);
        if (this.host != null) {
            child.setHost(this.host);
        } else {
            this.requiresHost.add(child);
        }
        return child;
    }

    public void validate(GuiDescription c) {
        super.validate(c);
        this.setRequiredHosts(c);
    }

    public void setHost(GuiDescription host) {
        super.setHost(host);
        this.setRequiredHosts(host);
    }

    private void setRequiredHosts(GuiDescription host) {
        for (Entry<D> widget : this.requiresHost) {
            widget.setHost(host);
        }
        this.requiresHost.clear();
    }

    public void layout() {
        this.children.clear();
        this.children.add(this.scrollBar);
        this.scrollBar.setLocation(this.width - this.scrollBar.getWidth(), 0);
        this.scrollBar.setSize(8, this.height);
        int layoutHeight = this.getHeight() - this.margin * 2;
        int cellsHigh = Math.max((layoutHeight + this.margin) / (this.cellHeight + this.margin), 1);
        this.scrollBar.setWindow(cellsHigh);
        this.scrollBar.setMaxValue(this.data.size());
        int scrollOffset = this.scrollBar.getValue();
        int presentCells = Math.min(this.data.size() - scrollOffset, cellsHigh);
        if (presentCells > 0) {
            int index;
            for (int i = 0; i < presentCells && (index = i + scrollOffset) < this.data.size(); ++i) {
                if (index < 0) continue;
                D d = this.data.get(index);
                Entry<D> w = this.configured.get(d);
                if (w == null) {
                    w = this.unconfigured.isEmpty() ? this.createChild(d) : this.unconfigured.remove(0);
                    this.configured.put(d, w);
                }
                if (w.canResize()) {
                    w.setSize(this.width - this.margin * 2 - this.scrollBar.getWidth(), this.cellHeight);
                }
                w.setLocation(this.margin, this.margin + (this.cellHeight + this.margin) * i);
                this.children.add(w);
            }
        }
    }

    public InputResult onMouseScroll(int x, int y, double amount) {
        return this.scrollBar.onMouseScroll(0, 0, amount);
    }

    public void select(D data) {
        this.selectedData.add(data);
        this.layout();
    }

    public void unSelect(D data) {
        this.selectedData.remove(data);
        this.layout();
    }

    public static abstract class Entry<D>
    extends WWidget {
        protected static final int TEXT_COLOR = 0xF5F5F5;
        private static final BackgroundPainter UNSELECTED = BackgroundPainter.createNinePatch((class_2960)new class_2960("stack-to-nearby-chests", "textures/background_dark.png"));
        private static final BackgroundPainter SELECTED = BackgroundPainter.createNinePatch((class_2960)new class_2960("stack-to-nearby-chests", "textures/background_dark_selected.png"));
        protected Optional<SelectableEntryList<D>> parentList = Optional.empty();
        protected boolean isSelected = false;
        protected D data;

        public Entry(D data) {
            this.data = data;
        }

        public D getData() {
            return this.data;
        }

        public void setParentList(SelectableEntryList<D> parentList) {
            this.parentList = Optional.ofNullable(parentList);
        }

        public InputResult onClick(int x, int y, int button) {
            boolean bl = this.isSelected = !this.isSelected;
            if (this.isSelected) {
                this.parentList.ifPresent(parent -> parent.select(this.data));
            } else {
                this.parentList.ifPresent(parent -> parent.unSelect(this.data));
            }
            return InputResult.PROCESSED;
        }

        public void paint(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
            if (this.isSelected) {
                SELECTED.paintBackground(matrices, x, y, (WWidget)this);
            } else {
                UNSELECTED.paintBackground(matrices, x, y, (WWidget)this);
            }
        }

        public boolean canResize() {
            return true;
        }
    }
}

