/*
 * Decompiled with CFR 0.152.
 */
package io.github.xiaocihua.stacktonearbychests.gui;

import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.client.BackgroundPainter;
import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WScrollBar;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.Axis;
import io.github.cottonmc.cotton.gui.widget.data.InputResult;
import io.github.xiaocihua.stacktonearbychests.gui.ModOptionsGui;
import io.github.xiaocihua.stacktonearbychests.gui.WClippedPanelCustom;
import io.github.xiaocihua.stacktonearbychests.gui.WScrollBarCustom;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_4587;

public class WScrollPanelCustom
extends WClippedPanelCustom {
    private static final int SCROLL_BAR_SIZE = 8;
    private final WWidget widget;
    protected WScrollBar horizontalScrollBar = new WScrollBarCustom(Axis.HORIZONTAL);
    protected WScrollBar verticalScrollBar = new WScrollBarCustom(Axis.VERTICAL);
    private TriState scrollingHorizontally = TriState.FALSE;
    private TriState scrollingVertically = TriState.TRUE;
    private int lastHorizontalScroll = -1;
    private int lastVerticalScroll = -1;

    public WScrollPanelCustom(WWidget widget) {
        this.widget = widget;
        widget.setParent((WPanel)this);
        this.horizontalScrollBar.setParent((WPanel)this);
        this.verticalScrollBar.setParent((WPanel)this);
        this.children.add(widget);
        this.children.add(this.verticalScrollBar);
    }

    public TriState isScrollingHorizontally() {
        return this.scrollingHorizontally;
    }

    public WScrollPanelCustom setScrollingHorizontally(TriState scrollingHorizontally) {
        if (scrollingHorizontally != this.scrollingHorizontally) {
            this.scrollingHorizontally = scrollingHorizontally;
            this.layout();
        }
        return this;
    }

    public TriState isScrollingVertically() {
        return this.scrollingVertically;
    }

    public WScrollPanelCustom setScrollingVertically(TriState scrollingVertically) {
        if (scrollingVertically != this.scrollingVertically) {
            this.scrollingVertically = scrollingVertically;
            this.layout();
        }
        return this;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void paint(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
        if (this.verticalScrollBar.getValue() != this.lastVerticalScroll || this.horizontalScrollBar.getValue() != this.lastHorizontalScroll) {
            this.layout();
            this.lastHorizontalScroll = this.horizontalScrollBar.getValue();
            this.lastVerticalScroll = this.verticalScrollBar.getValue();
        }
        super.paint(matrices, x, y, mouseX, mouseY);
    }

    public void layout() {
        this.children.clear();
        boolean horizontal = this.hasHorizontalScrollbar();
        boolean vertical = this.hasVerticalScrollbar();
        int offset = horizontal && vertical ? 8 : 0;
        this.verticalScrollBar.setSize(8, this.height - offset);
        this.verticalScrollBar.setLocation(this.width - this.verticalScrollBar.getWidth(), 0);
        this.horizontalScrollBar.setSize(this.width - offset, 8);
        this.horizontalScrollBar.setLocation(0, this.height - this.horizontalScrollBar.getHeight());
        if (this.widget instanceof WPanel) {
            this.widget.setSize(this.width - 8, this.height);
            ((WPanel)this.widget).layout();
        }
        this.children.add(this.widget);
        int x = horizontal ? -this.horizontalScrollBar.getValue() : 0;
        int y = vertical ? -this.verticalScrollBar.getValue() : 0;
        this.widget.setLocation(x, y);
        this.verticalScrollBar.setWindow(this.height - (horizontal ? 8 : 0));
        this.verticalScrollBar.setMaxValue(this.widget.getHeight());
        this.horizontalScrollBar.setWindow(this.width - (vertical ? 8 : 0));
        this.horizontalScrollBar.setMaxValue(this.widget.getWidth());
        if (vertical) {
            this.children.add(this.verticalScrollBar);
        }
        if (horizontal) {
            this.children.add(this.horizontalScrollBar);
        }
    }

    private boolean hasHorizontalScrollbar() {
        return this.scrollingHorizontally == TriState.DEFAULT ? this.widget.getWidth() > this.width - 8 : this.scrollingHorizontally.get();
    }

    private boolean hasVerticalScrollbar() {
        return this.scrollingVertically == TriState.DEFAULT ? this.widget.getHeight() > this.height - 8 : this.scrollingVertically.get();
    }

    public InputResult onMouseScroll(int x, int y, double amount) {
        if (this.hasVerticalScrollbar()) {
            return this.verticalScrollBar.onMouseScroll(0, 0, amount);
        }
        return InputResult.IGNORED;
    }

    public void validate(GuiDescription c) {
        this.horizontalScrollBar.validate(c);
        this.verticalScrollBar.validate(c);
        super.validate(c);
    }

    public BackgroundPainter getBackgroundPainter() {
        return ModOptionsGui.BACKGROUND_LIGHT;
    }
}

