/*
 * Decompiled with CFR 0.152.
 */
package mod.chloeprime.aaaparticles.common.util;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public record Basis(Vec3 row0, Vec3 row1, Vec3 row2, Vec3 x, Vec3 y, Vec3 z) {
    private static final Vec3 UP = new Vec3(0.0, 1.0, 0.0);

    public static Basis factory(Vec3 row0, Vec3 row1, Vec3 row2) {
        Vec3 x = new Vec3(row0.f_82479_, row1.f_82479_, row2.f_82479_);
        Vec3 y = new Vec3(row0.f_82480_, row1.f_82480_, row2.f_82480_);
        Vec3 z = new Vec3(row0.f_82481_, row1.f_82481_, row2.f_82481_);
        return new Basis(row0, row1, row2, x, y, z);
    }

    public static Basis fromVectors(Vec3 x, Vec3 y, Vec3 z) {
        Vec3 row0 = new Vec3(x.f_82479_, y.f_82479_, z.f_82479_);
        Vec3 row1 = new Vec3(x.f_82480_, y.f_82480_, z.f_82480_);
        Vec3 row2 = new Vec3(x.f_82481_, y.f_82481_, z.f_82481_);
        return new Basis(row0, row1, row2, x, y, z);
    }

    public Vec3 toLocal(Vec3 global) {
        return new Vec3(global.m_82526_(this.x), global.m_82526_(this.y), global.m_82526_(this.z));
    }

    public Vec3 toGlobal(Vec3 local) {
        return new Vec3(this.x.f_82479_ * local.f_82479_ + this.y.f_82479_ * local.f_82480_ + this.z.f_82479_ * local.f_82481_, this.x.f_82480_ * local.f_82479_ + this.y.f_82480_ * local.f_82480_ + this.z.f_82480_ * local.f_82481_, this.x.f_82481_ * local.f_82479_ + this.y.f_82481_ * local.f_82480_ + this.z.f_82481_ * local.f_82481_);
    }

    public static Basis fromBodyRotation(float yRot) {
        Vec3 z = Basis.getBodyFront(yRot).m_82548_();
        return Basis.fromVectors(Basis.getBodyX(z), UP, z);
    }

    public static Basis fromEntityBody(Entity entity) {
        return Basis.fromBodyRotation(entity.m_146908_());
    }

    public static Basis fromEuler(Vec3 euler) {
        double sin = Math.sin(euler.f_82479_);
        double cos = Math.cos(euler.f_82479_);
        Basis xmat = Basis.fromVectors(new Vec3(1.0, 0.0, 0.0), new Vec3(0.0, cos, sin), new Vec3(0.0, -sin, cos));
        sin = Math.sin(euler.f_82480_);
        cos = Math.cos(euler.f_82480_);
        Basis ymat = Basis.fromVectors(new Vec3(cos, 0.0, -sin), new Vec3(0.0, 1.0, 0.0), new Vec3(sin, 0.0, cos));
        sin = Math.sin(euler.f_82481_);
        cos = Math.cos(euler.f_82481_);
        Basis zmat = Basis.fromVectors(new Vec3(cos, sin, 0.0), new Vec3(-sin, cos, 0.0), new Vec3(0.0, 0.0, 1.0));
        return Basis.mul(Basis.mul(ymat, xmat), zmat);
    }

    public static Basis mul(Basis left, Basis right) {
        return Basis.factory(new Vec3(right.tDotX(left.row0), right.tDotY(left.row0), right.tDotZ(left.row0)), new Vec3(right.tDotX(left.row1), right.tDotY(left.row1), right.tDotZ(left.row1)), new Vec3(right.tDotX(left.row2), right.tDotY(left.row2), right.tDotZ(left.row2)));
    }

    public double tDotX(Vec3 with) {
        return this.row0.f_82479_ * with.f_82479_ + this.row1.f_82479_ * with.f_82480_ + this.row2.f_82479_ * with.f_82481_;
    }

    public double tDotY(Vec3 with) {
        return this.row0.f_82480_ * with.f_82479_ + this.row1.f_82480_ * with.f_82480_ + this.row2.f_82480_ * with.f_82481_;
    }

    public double tDotZ(Vec3 with) {
        return this.row0.f_82481_ * with.f_82479_ + this.row1.f_82481_ * with.f_82480_ + this.row2.f_82481_ * with.f_82481_;
    }

    private static Vec3 getBodyFront(float yRot) {
        return new Vec3((double)(-Mth.m_14031_((float)((float)Math.toRadians(yRot)))), 0.0, (double)Mth.m_14089_((float)((float)Math.toRadians(yRot))));
    }

    private static Vec3 getBodyX(Vec3 z) {
        return new Vec3(z.f_82481_, 0.0, -z.f_82479_);
    }
}

