/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.client.layer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.texture.AutoGlowingTexture;
import software.bernie.geckolib.cache.texture.GeoAbstractTexture;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.AutoGlowingGeoLayer;

public class GeckoItemGlowingLayer<T extends GeoAnimatable>
extends AutoGlowingGeoLayer<T> {
    private static final String APPENDIX = "_glowmask";
    private final ResourceLocation GLOWING_TEXTURE;

    public GeckoItemGlowingLayer(GeoRenderer<T> renderer, ResourceLocation resourceLocation) {
        super(renderer);
        this.GLOWING_TEXTURE = resourceLocation;
    }

    private ResourceLocation getEmissiveResource(ResourceLocation baseResource) {
        ResourceLocation path = GeoAbstractTexture.appendToPath((ResourceLocation)baseResource, (String)APPENDIX);
        this.generateTexture(path, textureManager -> textureManager.m_118495_(path, (AbstractTexture)new AutoGlowingTexture(baseResource, path)));
        return path;
    }

    protected void generateTexture(ResourceLocation texturePath, Consumer<TextureManager> textureManagerConsumer) {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            throw new IllegalThreadStateException("Texture loading called outside of the render thread! This should DEFINITELY not be happening.");
        }
        TextureManager textureManager = Minecraft.m_91087_().m_91097_();
        if (!(textureManager.m_174786_(texturePath, (AbstractTexture)MissingTextureAtlasSprite.m_118080_()) instanceof GeoAbstractTexture)) {
            textureManagerConsumer.accept(textureManager);
        }
    }

    protected RenderType getRenderType(T animatable) {
        RenderType bloomType = RenderType.m_110488_((ResourceLocation)this.getEmissiveResource(this.getTextureResource((GeoAnimatable)animatable)));
        return bloomType;
    }

    public void render(PoseStack poseStack, T animatable, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        RenderType emissiveRenderType = RenderType.m_110488_((ResourceLocation)this.getEmissiveResource(this.getTextureResource((GeoAnimatable)animatable)));
        this.getRenderer().reRender(bakedModel, poseStack, bufferSource, animatable, emissiveRenderType, bufferSource.m_6299_(emissiveRenderType), partialTick, 0xF00000, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }
}

