/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.client.special.cameravfx;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.teamabyssalofficial.client.special.cameravfx.CameraAnimation;
import net.teamabyssalofficial.client.special.cameravfx.CameraOptions;
import net.teamabyssalofficial.registry.EntityRegistry;
import net.teamabyssalofficial.util.PlayerVariableUtils;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BlockbenchCamera
extends Entity
implements GeoEntity {
    private static final EntityDataAccessor<String> ANIMATION_NAME = SynchedEntityData.m_135353_(BlockbenchCamera.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> ANIMATION_TICK = SynchedEntityData.m_135353_(BlockbenchCamera.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> HIDE_HUD = SynchedEntityData.m_135353_(BlockbenchCamera.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> INVIS_TO_ENTITIES = SynchedEntityData.m_135353_(BlockbenchCamera.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> LOCKED_CAMERA = SynchedEntityData.m_135353_(BlockbenchCamera.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> OBSTRUCTED_MOVEMENT = SynchedEntityData.m_135353_(BlockbenchCamera.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private Player player;
    private final String emptyAnimation = "empty";
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public BlockbenchCamera(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public BlockbenchCamera(Player player, Level pLevel, CameraAnimation animation, CameraOptions options) {
        super((EntityType)EntityRegistry.BLOCKBENCH_CAMERA.get(), pLevel);
        this.setAnimationName(animation.animationName());
        this.setAnimationTick(animation.animationLength());
        this.setHudHidden(options.hideHud());
        this.setImmuneToOthers(options.invisToEntities());
        this.setCameraLocked(options.lockedCamera());
        this.setObstructedMovement(options.obstructedMovement());
        this.player = player;
        if (this.player != null) {
            this.m_146884_(this.player.m_20182_());
            this.m_146926_(this.player.m_146909_());
            this.m_146922_(this.player.m_146908_());
            if (this.obstructedMovement()) {
                this.player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, animation.animationLength(), 99));
                this.player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, animation.animationLength(), 99));
            }
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ANIMATION_NAME, (Object)this.emptyAnimation);
        this.f_19804_.m_135372_(ANIMATION_TICK, (Object)0);
        this.f_19804_.m_135372_(HIDE_HUD, (Object)false);
        this.f_19804_.m_135372_(INVIS_TO_ENTITIES, (Object)false);
        this.f_19804_.m_135372_(LOCKED_CAMERA, (Object)false);
        this.f_19804_.m_135372_(OBSTRUCTED_MOVEMENT, (Object)false);
    }

    protected void m_7378_(CompoundTag compoundTag) {
        this.setAnimationName(compoundTag.m_128461_("animationName"));
        this.setAnimationTick(compoundTag.m_128451_("animationTick"));
        this.setHudHidden(compoundTag.m_128471_("hideHud"));
        this.setImmuneToOthers(compoundTag.m_128471_("immuneToOthers"));
        this.setCameraLocked(compoundTag.m_128471_("lockedCamera"));
        this.setObstructedMovement(compoundTag.m_128471_("obstructedMovement"));
    }

    protected void m_7380_(CompoundTag compoundTag) {
        compoundTag.m_128359_("animationName", this.getAnimationName());
        compoundTag.m_128405_("animationTick", this.getAnimationTick());
        compoundTag.m_128379_("hideHud", this.hideHud());
        compoundTag.m_128379_("immuneToOthers", this.immuneToOthers());
        compoundTag.m_128379_("lockedCamera", this.lockedCamera());
        compoundTag.m_128379_("obstructedMovement", this.obstructedMovement());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "cameraController", 7, event -> {
            if (this.getAnimationTick() > 0) {
                return event.setAndContinue(RawAnimation.begin().thenPlay(this.getAnimationName()));
            }
            return event.setAndContinue(RawAnimation.begin().thenPlay(this.emptyAnimation));
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public String getAnimationName() {
        return (String)this.f_19804_.m_135370_(ANIMATION_NAME);
    }

    public void setAnimationName(String animationName) {
        this.f_19804_.m_135381_(ANIMATION_NAME, (Object)animationName);
    }

    public int getAnimationTick() {
        return (Integer)this.f_19804_.m_135370_(ANIMATION_TICK);
    }

    public void setAnimationTick(int animationTick) {
        this.f_19804_.m_135381_(ANIMATION_TICK, (Object)animationTick);
    }

    public boolean hideHud() {
        return (Boolean)this.f_19804_.m_135370_(HIDE_HUD);
    }

    public void setHudHidden(boolean hudHidden) {
        this.f_19804_.m_135381_(HIDE_HUD, (Object)hudHidden);
    }

    public boolean immuneToOthers() {
        return (Boolean)this.f_19804_.m_135370_(INVIS_TO_ENTITIES);
    }

    public void setImmuneToOthers(boolean immuneToOthers) {
        this.f_19804_.m_135381_(INVIS_TO_ENTITIES, (Object)immuneToOthers);
    }

    public boolean lockedCamera() {
        return (Boolean)this.f_19804_.m_135370_(LOCKED_CAMERA);
    }

    public void setCameraLocked(boolean locked) {
        this.f_19804_.m_135381_(LOCKED_CAMERA, (Object)locked);
    }

    public boolean obstructedMovement() {
        return (Boolean)this.f_19804_.m_135370_(OBSTRUCTED_MOVEMENT);
    }

    public void setObstructedMovement(boolean obstructedMovement) {
        this.f_19804_.m_135381_(OBSTRUCTED_MOVEMENT, (Object)obstructedMovement);
    }

    public void decrementAnimation() {
        if (this.getAnimationTick() > 0) {
            this.setAnimationTick(this.getAnimationTick() - 1);
        }
    }

    public void attach() {
        if (this.player != null) {
            this.m_146884_(this.player.m_20182_());
            this.m_146926_(this.player.m_146909_());
            this.m_146922_(this.player.m_146908_());
        }
    }

    public void attachOptions() {
        if (this.player != null) {
            PlayerVariableUtils playerVariableUtils = (PlayerVariableUtils)this.player;
            playerVariableUtils.setInvincible(this.immuneToOthers() && this.getAnimationTick() > 1);
            playerVariableUtils.setHudHidden(this.hideHud() && this.getAnimationTick() > 1);
            playerVariableUtils.setCameraLocked(this.lockedCamera() && this.getAnimationTick() > 1);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        this.decrementAnimation();
        this.attach();
        this.attachOptions();
        if (this.getAnimationTick() == 1) {
            this.m_146870_();
        }
    }

    public static boolean hasCamera(Player player, double radius) {
        AABB aabb = player.m_20191_().m_82400_(radius);
        List entities = player.m_9236_().m_45933_((Entity)player, aabb);
        for (Entity entity : entities) {
            if (!(entity instanceof BlockbenchCamera)) continue;
            return true;
        }
        return false;
    }

    public static void addCamera(Player player, Level world, CameraAnimation animation, CameraOptions options) {
        if (!world.f_46443_) {
            BlockbenchCamera camera = new BlockbenchCamera(player, world, animation, options);
            world.m_7967_((Entity)camera);
        }
    }
}

