/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.dotf;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.teamabyssalofficial.client.ClientEventInterface;
import net.teamabyssalofficial.client.ClientLayerRegistry;
import net.teamabyssalofficial.client.ClientShaderInstances;
import net.teamabyssalofficial.client.ClientShaders;
import net.teamabyssalofficial.dotf.CommonProxy;
import net.teamabyssalofficial.dotf.DawnOfTheFlood;
import net.teamabyssalofficial.dotf.playerlib.AbilityClientEventHandler;
import net.teamabyssalofficial.guns.gun.GunItem;
import net.teamabyssalofficial.sounds.GunShotSound;

@OnlyIn(value=Dist.CLIENT)
public class ClientProxy
extends CommonProxy {
    public static final ResourceLocation ENERGY_SHIELD_SHADER = new ResourceLocation("dotf", "shaders/post/energy_shield.json");
    public static final ResourceLocation FLOOD_SHADER = new ResourceLocation("dotf", "shaders/post/flood_shader.json");
    public static final ResourceLocation POSITION_COLOR_TEX = new ResourceLocation("dotf", "shaders/post/position_color_tex.json");
    public static final ResourceLocation POSITION_COLOR_TEX_LIGHTMAP = new ResourceLocation("dotf", "shaders/post/position_color_tex_lightmap.json");
    public static final ResourceLocation POSITION_TEX_COLOR = new ResourceLocation("dotf", "shaders/post/position_tex_color.json");

    @Override
    public void init(IEventBus bus) {
        MinecraftForge.EVENT_BUS.register((Object)ClientEventInterface.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)AbilityClientEventHandler.INSTANCE);
        bus.addListener(ClientLayerRegistry::onAddLayers);
        bus.addListener(this::registerShaders);
        ClientShaders.registerEffect(ENERGY_SHIELD_SHADER);
        ClientShaders.registerEffect(FLOOD_SHADER);
        ClientShaders.registerEffect(POSITION_COLOR_TEX);
        ClientShaders.registerEffect(POSITION_COLOR_TEX_LIGHTMAP);
        ClientShaders.registerEffect(POSITION_TEX_COLOR);
    }

    private void registerShaders(RegisterShadersEvent event) {
        try {
            event.registerShader(new ShaderInstance(event.getResourceProvider(), new ResourceLocation("dotf", "rendertype_energy_shield"), DefaultVertexFormat.f_85818_), ClientShaderInstances::setRenderTypeEnergyShieldShader);
            event.registerShader(new ShaderInstance(event.getResourceProvider(), new ResourceLocation("dotf", "rendertype_flood_shader"), DefaultVertexFormat.f_85818_), ClientShaderInstances::setRenderTypeFloodShader);
            event.registerShader(new ShaderInstance(event.getResourceProvider(), new ResourceLocation("dotf", "position_color_tex"), DefaultVertexFormat.f_85818_), ClientShaderInstances::setRenderTypePositionColorTexShader);
            event.registerShader(new ShaderInstance(event.getResourceProvider(), new ResourceLocation("dotf", "position_color_tex_lightmap"), DefaultVertexFormat.f_85820_), ClientShaderInstances::setRenderTypePositionColorTexLightMapShader);
            event.registerShader(new ShaderInstance(event.getResourceProvider(), new ResourceLocation("dotf", "position_tex_color"), DefaultVertexFormat.f_85819_), ClientShaderInstances::setRenderTypePositionTexColorShader);
            DawnOfTheFlood.LOGGER.info("Registered internal shaders");
        }
        catch (IOException exception) {
            DawnOfTheFlood.LOGGER.error("Could not register internal shaders");
            exception.printStackTrace();
        }
    }

    public static void playGunShootEngineSound(Minecraft client, float val) {
        client.execute(() -> {
            Item patt4544$temp;
            if (client.f_91074_ != null && (patt4544$temp = client.f_91074_.m_21205_().m_41720_()) instanceof GunItem) {
                GunItem item = (GunItem)patt4544$temp;
                client.m_91106_().m_120367_((SoundInstance)new GunShotSound(item.getShootSound(), SoundSource.PLAYERS, (float)client.f_91074_.m_20185_(), (float)client.f_91074_.m_20186_(), (float)client.f_91074_.m_20189_(), val, val, client.f_91074_.m_217043_()));
            }
        });
    }
}

