/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.dotf.playerlib;

import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.teamabyssalofficial.client.special.player.GeckoPlayer;
import net.teamabyssalofficial.client.special.player.GeckoPlayerController;
import net.teamabyssalofficial.dotf.playerlib.AbilityCapability;
import net.teamabyssalofficial.dotf.playerlib.AbilitySection;
import net.teamabyssalofficial.dotf.playerlib.AbilityType;
import net.teamabyssalofficial.dotf.playerlib.AnimationAbilityHandler;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class Ability<T extends LivingEntity> {
    private final AbilitySection[] sectionTrack;
    protected int cooldownMax;
    private final AbilityType<T, ? extends Ability> abilityType;
    private final T user;
    private final AbilityCapability.IAbilityCapability abilityCapability;
    private int ticksInUse;
    private int ticksInSection;
    private int currentSectionIndex;
    private boolean isUsing;
    private int cooldownTimer;
    protected Random rand;
    protected RawAnimation activeAnimation;

    public Ability(AbilityType<T, ? extends Ability> abilityType, T user, AbilitySection[] sectionTrack, int cooldownMax) {
        this.abilityType = abilityType;
        this.user = user;
        this.abilityCapability = AnimationAbilityHandler.INSTANCE.getAbilityCapability((LivingEntity)user);
        this.sectionTrack = sectionTrack;
        this.cooldownMax = cooldownMax;
        this.rand = new Random();
    }

    public Ability(AbilityType<T, ? extends Ability> abilityType, T user, AbilitySection[] sectionTrack) {
        this(abilityType, user, sectionTrack, 0);
    }

    public void start() {
        if (!this.runsInBackground()) {
            this.abilityCapability.setActiveAbility(this);
        }
        this.ticksInUse = 0;
        this.ticksInSection = 0;
        this.currentSectionIndex = 0;
        this.isUsing = true;
        this.beginSection(this.getSectionTrack()[0]);
    }

    public void playAnimation(RawAnimation animation) {
        if (this.getUser() != null && this.getUser().m_9236_().m_5776_()) {
            this.activeAnimation = animation;
            GeckoPlayerController<GeckoPlayer> controller = GeckoPlayer.getAnimationController((Player)this.getUser(), GeckoPlayer.Perspective.THIRD_PERSON);
            GeckoPlayer geckoPlayer = GeckoPlayer.getGeckoPlayer((Player)this.getUser(), GeckoPlayer.Perspective.THIRD_PERSON);
            if (controller != null && geckoPlayer != null) {
                controller.playAnimation(geckoPlayer, animation);
            }
        }
    }

    public void tick() {
        if (this.isUsing()) {
            this.tickUsing();
            ++this.ticksInUse;
            ++this.ticksInSection;
            AbilitySection section = this.getCurrentSection();
            if (section instanceof AbilitySection.AbilitySectionInstant) {
                this.nextSection();
            } else if (section instanceof AbilitySection.AbilitySectionDuration) {
                AbilitySection.AbilitySectionDuration sectionDuration = (AbilitySection.AbilitySectionDuration)section;
                if (this.ticksInSection > sectionDuration.duration) {
                    this.nextSection();
                }
            }
        } else {
            this.tickNotUsing();
            if (this.getCooldownTimer() > 0) {
                --this.cooldownTimer;
            }
        }
    }

    public void tickUsing() {
    }

    public void tickNotUsing() {
    }

    public void end() {
        this.ticksInUse = 0;
        this.ticksInSection = 0;
        this.isUsing = false;
        this.cooldownTimer = this.getMaxCooldown();
        this.currentSectionIndex = 0;
        if (!this.runsInBackground()) {
            this.abilityCapability.setActiveAbility(null);
        }
    }

    public void interrupt() {
        this.end();
    }

    public void complete() {
        this.end();
    }

    public boolean canUse() {
        boolean toReturn;
        boolean bl = toReturn = (!this.isUsing() || this.canCancelSelf()) && this.cooldownTimer == 0;
        if (!this.runsInBackground()) {
            toReturn = toReturn && (this.abilityCapability.getActiveAbility() == null || this.canCancelActiveAbility() || this.abilityCapability.getActiveAbility().canBeCanceledByAbility(this));
        }
        return toReturn;
    }

    public boolean tryAbility() {
        return true;
    }

    public boolean canCancelActiveAbility() {
        return false;
    }

    public Ability getActiveAbility() {
        AbilityCapability.IAbilityCapability capability = this.getAbilityCapability();
        return capability == null ? null : this.getAbilityCapability().getActiveAbility();
    }

    public boolean canCancelSelf() {
        return false;
    }

    public boolean canBeCanceledByAbility(Ability ability) {
        return false;
    }

    protected boolean canContinueUsing() {
        return true;
    }

    public boolean isUsing() {
        return this.isUsing;
    }

    public T getUser() {
        return this.user;
    }

    public Level getLevel() {
        return this.user.m_9236_();
    }

    public int getTicksInUse() {
        return this.ticksInUse;
    }

    public int getTicksInSection() {
        return this.ticksInSection;
    }

    public int getCooldownTimer() {
        return this.cooldownTimer;
    }

    public void nextSection() {
        this.jumpToSection(this.currentSectionIndex + 1);
    }

    public void jumpToSection(int sectionIndex) {
        this.endSection(this.getCurrentSection());
        this.currentSectionIndex = sectionIndex;
        this.ticksInSection = 0;
        if (this.currentSectionIndex >= this.getSectionTrack().length) {
            this.complete();
        } else {
            this.beginSection(this.getCurrentSection());
        }
    }

    protected void endSection(AbilitySection section) {
    }

    protected void beginSection(AbilitySection section) {
    }

    public AbilitySection getCurrentSection() {
        return this.currentSectionIndex >= this.getSectionTrack().length ? null : this.getSectionTrack()[this.currentSectionIndex];
    }

    public boolean damageInterrupts() {
        return false;
    }

    public boolean runsInBackground() {
        return false;
    }

    public boolean preventsAttacking() {
        return true;
    }

    public boolean preventsBlockBreakingBuilding() {
        return true;
    }

    public boolean preventsInteracting() {
        return true;
    }

    public boolean preventsItemUse(ItemStack stack) {
        return true;
    }

    public AbilitySection[] getSectionTrack() {
        return this.sectionTrack;
    }

    public int getMaxCooldown() {
        return this.cooldownMax;
    }

    public AbilityCapability.IAbilityCapability getAbilityCapability() {
        return this.abilityCapability;
    }

    public <E extends GeoEntity> PlayState animationPredicate(AnimationState<E> e, GeckoPlayer.Perspective perspective) {
        if (this.activeAnimation != null && !this.activeAnimation.getAnimationStages().isEmpty()) {
            e.getController().setAnimation(this.activeAnimation);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void codeAnimations(GeckoPlayer model, float partialTick) {
    }

    public boolean isAnimating() {
        return this.isUsing();
    }

    public AbilityType<T, ? extends Ability> getAbilityType() {
        return this.abilityType;
    }

    public CompoundTag writeNBT() {
        CompoundTag compound = new CompoundTag();
        if (this.isUsing()) {
            compound.m_128405_("ticks_in_use", this.ticksInUse);
            compound.m_128405_("ticks_in_section", this.ticksInSection);
            compound.m_128405_("current_section", this.currentSectionIndex);
        } else if (this.cooldownTimer > 0) {
            compound.m_128405_("cooldown_timer", this.cooldownTimer);
        }
        return compound;
    }

    public void readNBT(Tag nbt) {
        CompoundTag compound = (CompoundTag)nbt;
        this.isUsing = compound.m_128471_("ticks_in_use");
        if (this.isUsing) {
            this.ticksInUse = compound.m_128451_("ticks_in_use");
            this.ticksInSection = compound.m_128451_("ticks_in_section");
            this.currentSectionIndex = compound.m_128451_("current_section");
        } else {
            this.cooldownTimer = compound.m_128451_("cooldown_timer");
        }
    }

    public void onRenderTick(TickEvent.RenderTickEvent event) {
    }
}

