/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.dotf.playerlib;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.teamabyssalofficial.dotf.playerlib.AbilityCapability;
import net.teamabyssalofficial.dotf.playerlib.AnimationAbilityHandler;
import net.teamabyssalofficial.dotf.playerlib.CapabilityHandler;
import net.teamabyssalofficial.dotf.playerlib.PlayerCapability;

public class AnimationAbilityFactory {
    @SubscribeEvent
    public void onJoinWorld(EntityJoinLevelEvent event) {
        PlayerCapability.IPlayerCapability playerCapability;
        AbilityCapability.IAbilityCapability abilityCapability;
        if (event.getEntity() instanceof Player && (abilityCapability = AnimationAbilityHandler.INSTANCE.getAbilityCapability((LivingEntity)event.getEntity())) != null) {
            abilityCapability.instanceAbilities((LivingEntity)event.getEntity());
        }
        if (event.getEntity() instanceof Player && (playerCapability = CapabilityHandler.getCapability(event.getEntity(), CapabilityHandler.PLAYER_CAPABILITY)) != null) {
            playerCapability.addedToWorld(event);
        }
    }

    @SubscribeEvent
    public void onJoinWorld(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        AbilityCapability.IAbilityCapability abilityCapability = CapabilityHandler.getCapability((Entity)entity, CapabilityHandler.ABILITY_CAPABILITY);
        if (abilityCapability != null) {
            abilityCapability.tick(event.getEntity());
        }
    }

    @SubscribeEvent
    public void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity) {
            event.addCapability(new ResourceLocation("dotf", "ability"), (ICapabilityProvider)new AbilityCapability.AbilityProvider());
        }
        if (event.getObject() instanceof Player) {
            event.addCapability(new ResourceLocation("dotf", "player"), (ICapabilityProvider)new PlayerCapability.PlayerProvider());
        }
    }
}

