/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.dotf.playerlib;

import javax.annotation.Nullable;
import net.fabridge.fabricmc.network.ClientPlayNetworking;
import net.fabridge.fabricmc.network.ServerPlayNetworking;
import net.fabridge.fabricmc.network.fabric.PacketByteBufs;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.teamabyssalofficial.dotf.playerlib.Ability;
import net.teamabyssalofficial.dotf.playerlib.AbilityCapability;
import net.teamabyssalofficial.dotf.playerlib.AbilityType;
import net.teamabyssalofficial.dotf.playerlib.AnimationAbility;
import net.teamabyssalofficial.dotf.playerlib.CapabilityHandler;
import net.teamabyssalofficial.dotf.playerlib.PlayerAbility;
import net.teamabyssalofficial.network.messages.ModMessages;
import org.apache.commons.lang3.ArrayUtils;

public enum AnimationAbilityHandler {
    INSTANCE;

    public static final AbilityType<Player, AnimationAbility> ENERGY_SWORD_SWING1;
    public static final AbilityType<Player, AnimationAbility> ENERGY_SWORD_SWING2;
    public static final AbilityType<Player, AnimationAbility> ENERGY_SWORD_SWING3;
    public static final AbilityType<Player, AnimationAbility> GRAVITY_HAMMER_RIGHT_HIT;
    public static final AbilityType<Player, AnimationAbility> GRAVITY_HAMMER_LEFT_HIT;
    public static final AbilityType<Player, AnimationAbility> GRAVITY_HAMMER_VERTICAL_HIT;
    public static final AbilityType<Player, AnimationAbility> GUN_RELOAD;
    public static final AbilityType<Player, AnimationAbility> GUN_MELEE1;
    public static final AbilityType<Player, AnimationAbility> GUN_MELEE2;
    public static final AbilityType<Player, AnimationAbility> GUN_MELEE3;
    public static final AbilityType<Player, AnimationAbility> GUN_FIRE;
    public static final AbilityType<Player, AnimationAbility> GUN_AIM_FIRE;
    public static final AbilityType<Player, AnimationAbility> GRENADE_THROW;
    public static final AbilityType<Player, ? extends PlayerAbility>[] PLAYER_ABILITIES;

    @Nullable
    public AbilityCapability.IAbilityCapability getAbilityCapability(LivingEntity entity) {
        return CapabilityHandler.getCapability((Entity)entity, CapabilityHandler.ABILITY_CAPABILITY);
    }

    @Nullable
    public Ability getAbility(LivingEntity entity, AbilityType<?, ?> abilityType) {
        AbilityCapability.IAbilityCapability abilityCapability = this.getAbilityCapability(entity);
        return abilityCapability != null ? abilityCapability.getAbilityMap().get(abilityType) : null;
    }

    public <T extends LivingEntity> void sendAbilityMessage(T entity, AbilityType<?, ?> abilityType) {
        Ability instance;
        AbilityCapability.IAbilityCapability abilityCapability;
        if (!entity.m_9236_().f_46443_ && (abilityCapability = this.getAbilityCapability(entity)) != null && (instance = abilityCapability.getAbilityMap().get(abilityType)) != null && instance.canUse()) {
            abilityCapability.activateAbility(entity, abilityType);
            FriendlyByteBuf buf = PacketByteBufs.create();
            buf.writeInt(entity.m_19879_());
            buf.writeInt(ArrayUtils.indexOf((Object[])abilityCapability.getAbilityTypesOnEntity(entity), abilityType));
            ServerPlayNetworking.send((ServerPlayer)((ServerPlayer)entity), (ResourceLocation)ModMessages.SEND_ABILITY_USE_ID, (FriendlyByteBuf)buf);
        }
    }

    public <T extends Player> void sendPlayerTryAbilityMessage(T entity, AbilityType<?, ?> ability) {
        AbilityCapability.IAbilityCapability abilityCapability;
        if (entity.m_9236_().f_46443_ && entity instanceof LocalPlayer && (abilityCapability = this.getAbilityCapability((LivingEntity)entity)) != null) {
            FriendlyByteBuf buf = PacketByteBufs.create();
            buf.writeInt(ArrayUtils.indexOf((Object[])abilityCapability.getAbilityTypesOnEntity((LivingEntity)entity), ability));
            ClientPlayNetworking.send((ResourceLocation)ModMessages.SEND_ABILITY_PLAYER_USE_ID, (FriendlyByteBuf)buf);
        }
    }

    static {
        ENERGY_SWORD_SWING1 = new AbilityType<LivingEntity, Ability>("energy_sword_swing1", (type, player) -> new AnimationAbility(type, (Player)player, "energy_sword_swing1", 20, true));
        ENERGY_SWORD_SWING2 = new AbilityType<LivingEntity, Ability>("energy_sword_swing2", (type, player) -> new AnimationAbility(type, (Player)player, "energy_sword_swing2", 20, true));
        ENERGY_SWORD_SWING3 = new AbilityType<LivingEntity, Ability>("energy_sword_swing3", (type, player) -> new AnimationAbility(type, (Player)player, "energy_sword_swing3", 19, true));
        GRAVITY_HAMMER_RIGHT_HIT = new AbilityType<LivingEntity, Ability>("grav_hammer_right_hit", (type, player) -> new AnimationAbility(type, (Player)player, "grav_hammer_right_hit", 33, true));
        GRAVITY_HAMMER_LEFT_HIT = new AbilityType<LivingEntity, Ability>("grav_hammer_left_hit", (type, player) -> new AnimationAbility(type, (Player)player, "grav_hammer_left_hit", 33, true));
        GRAVITY_HAMMER_VERTICAL_HIT = new AbilityType<LivingEntity, Ability>("grav_hammer_vertical_hit", (type, player) -> new AnimationAbility(type, (Player)player, "grav_hammer_vertical_hit", 29, true));
        GUN_RELOAD = new AbilityType<LivingEntity, Ability>("gun_reload", (type, player) -> new AnimationAbility(type, (Player)player, "gun_reload", 50, true));
        GUN_MELEE1 = new AbilityType<LivingEntity, Ability>("gun_melee1", (type, player) -> new AnimationAbility(type, (Player)player, "gun_melee1", 11, true));
        GUN_MELEE2 = new AbilityType<LivingEntity, Ability>("gun_melee2", (type, player) -> new AnimationAbility(type, (Player)player, "gun_melee2", 11, true));
        GUN_MELEE3 = new AbilityType<LivingEntity, Ability>("gun_melee3", (type, player) -> new AnimationAbility(type, (Player)player, "gun_melee3", 11, true));
        GUN_FIRE = new AbilityType<LivingEntity, Ability>("gun_fire", (type, player) -> new AnimationAbility(type, (Player)player, "gun_fire", 6, true));
        GUN_AIM_FIRE = new AbilityType<LivingEntity, Ability>("gun_aim_fire", (type, player) -> new AnimationAbility(type, (Player)player, "gun_aim_fire", 6, true));
        GRENADE_THROW = new AbilityType<LivingEntity, Ability>("grenade_throw", (type, player) -> new AnimationAbility(type, (Player)player, "grenade_throw", 20, true));
        PLAYER_ABILITIES = new AbilityType[]{ENERGY_SWORD_SWING1, ENERGY_SWORD_SWING2, ENERGY_SWORD_SWING3, GRAVITY_HAMMER_RIGHT_HIT, GRAVITY_HAMMER_LEFT_HIT, GRAVITY_HAMMER_VERTICAL_HIT, GUN_RELOAD, GUN_MELEE1, GUN_MELEE2, GUN_MELEE3, GUN_FIRE, GUN_AIM_FIRE, GRENADE_THROW};
    }
}

