/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.entity.ai;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import mod.chloeprime.aaaparticles.api.common.AAALevel;
import mod.chloeprime.aaaparticles.api.common.ParticleEmitterInfo;
import net.asestefan.utils.ParticleUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.teamabyssalofficial.entity.categories.BaseForm;
import net.teamabyssalofficial.entity.categories.BodyEntity;
import net.teamabyssalofficial.entity.custom.DeadEvokerFormEntity;
import net.teamabyssalofficial.entity.custom.DeadHumanFormEntity;
import net.teamabyssalofficial.entity.custom.DeadMarineFormEntity;
import net.teamabyssalofficial.entity.custom.DeadPillagerFormEntity;
import net.teamabyssalofficial.entity.custom.DeadPlayerFormEntity;
import net.teamabyssalofficial.entity.custom.DeadSangheiliFormEntity;
import net.teamabyssalofficial.entity.custom.DeadVillagerFormEntity;
import net.teamabyssalofficial.entity.custom.DeadVindicatorFormEntity;
import net.teamabyssalofficial.entity.custom.EvokerFormEntity;
import net.teamabyssalofficial.entity.custom.FloodedGolemEntity;
import net.teamabyssalofficial.entity.custom.HumanFormEntity;
import net.teamabyssalofficial.entity.custom.MarineFormEntity;
import net.teamabyssalofficial.entity.custom.PillagerFormEntity;
import net.teamabyssalofficial.entity.custom.PlayerFormEntity;
import net.teamabyssalofficial.entity.custom.SangheiliFormEntity;
import net.teamabyssalofficial.entity.custom.UnarmedFloodedGolemEntity;
import net.teamabyssalofficial.entity.custom.VillagerFormEntity;
import net.teamabyssalofficial.entity.custom.VindicatorFormEntity;
import net.teamabyssalofficial.registry.EntityRegistry;
import net.teamabyssalofficial.registry.ParticleRegistry;
import net.teamabyssalofficial.registry.ParticleResourceRegistry;
import net.teamabyssalofficial.util.PerformanceEngine;

public class ReanimateOthersGoal
extends Goal {
    private static TargetingConditions PARTNER_TARGETING;
    protected final Level level;
    protected final PathfinderMob mob;
    private final Class<? extends PathfinderMob> partnerClass;
    @Nullable
    protected PathfinderMob partner;
    private final double speedModifier;

    public ReanimateOthersGoal(PathfinderMob mob, double speedModifier) {
        this(mob, speedModifier, mob.getClass());
    }

    public ReanimateOthersGoal(PathfinderMob mob, double speedModifier, Class<? extends PathfinderMob> partnerClass) {
        this(mob, speedModifier, partnerClass, null);
    }

    public ReanimateOthersGoal(PathfinderMob mob, double speedModifier, Class<? extends PathfinderMob> partnerClass, @Nullable Predicate<LivingEntity> en) {
        this.level = mob.m_9236_();
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.partnerClass = partnerClass;
        PARTNER_TARGETING = TargetingConditions.m_148353_().m_26883_(32.0).m_26888_(en);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.mob.m_217043_().m_188503_(15) == 0 && this.getFreePartner() == null) {
            return false;
        }
        if (this.mob.m_217043_().m_188503_(5) == 1) {
            this.partner = this.getFreePartner();
        }
        return this.partnerClass != null;
    }

    public boolean m_8045_() {
        if (this.partner != null) {
            return this.partner.m_6084_() || this.getFreePartner() != null;
        }
        return false;
    }

    public void m_8041_() {
        this.partner = null;
    }

    public boolean canTake(Entity entity) {
        UnarmedFloodedGolemEntity unarmedFloodedGolemEntity;
        BodyEntity bodyEntity;
        return entity instanceof BodyEntity && !(bodyEntity = (BodyEntity)entity).isTaken() || entity instanceof UnarmedFloodedGolemEntity && !(unarmedFloodedGolemEntity = (UnarmedFloodedGolemEntity)entity).isTaken();
    }

    public void take(Entity entity) {
        UnarmedFloodedGolemEntity unarmedFloodedGolemEntity;
        BodyEntity bodyEntity;
        if (entity instanceof BodyEntity && !(bodyEntity = (BodyEntity)entity).isTaken()) {
            bodyEntity.setTaken(true);
        } else if (entity instanceof UnarmedFloodedGolemEntity && !(unarmedFloodedGolemEntity = (UnarmedFloodedGolemEntity)entity).isTaken()) {
            unarmedFloodedGolemEntity.setTaken(true);
        }
    }

    public void m_8037_() {
        if (this.partner != null && this.canTake((Entity)this.partner)) {
            this.mob.m_21573_().m_5624_((Entity)this.partner, this.speedModifier);
            if (this.mob.m_20270_((Entity)this.partner) <= 2.4f && this.mob.m_217043_().m_188503_(3) == 0) {
                this.reanimateForms((Entity)this.partner);
                this.take((Entity)this.partner);
                this.playReanimationSound(this.partner.m_9236_(), (Entity)this.partner);
                this.generateParticles(this.partner.m_9236_(), (Entity)this.partner, this.partner.m_217043_());
                this.mob.m_146870_();
                this.partner.m_146870_();
                this.m_8041_();
            }
        }
    }

    private void reanimateForms(Entity entity) {
        if (entity instanceof DeadHumanFormEntity) {
            DeadHumanFormEntity deadHumanFormEntity = (DeadHumanFormEntity)entity;
            HumanFormEntity humanFormEntity = new HumanFormEntity((EntityType<? extends Monster>)((EntityType)EntityRegistry.HUMAN_FORM.get()), entity.m_9236_());
            humanFormEntity.m_6027_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            humanFormEntity.setVariant(deadHumanFormEntity.getVariant());
            humanFormEntity.m_8061_(EquipmentSlot.HEAD, deadHumanFormEntity.m_6844_(EquipmentSlot.HEAD));
            humanFormEntity.m_8061_(EquipmentSlot.CHEST, deadHumanFormEntity.m_6844_(EquipmentSlot.CHEST));
            humanFormEntity.m_8061_(EquipmentSlot.LEGS, deadHumanFormEntity.m_6844_(EquipmentSlot.LEGS));
            humanFormEntity.m_8061_(EquipmentSlot.FEET, deadHumanFormEntity.m_6844_(EquipmentSlot.FEET));
            humanFormEntity.m_5618_(((DeadHumanFormEntity)entity).f_20883_);
            humanFormEntity.m_5616_(((DeadHumanFormEntity)entity).f_20885_);
            humanFormEntity.setIsReanimated(true);
            humanFormEntity.setTransformed(true);
            this.registerExtra(humanFormEntity, (Entity)deadHumanFormEntity);
            humanFormEntity.stackScaler.setpX(deadHumanFormEntity.stackScaler.getpX());
            humanFormEntity.stackScaler.setpY(deadHumanFormEntity.stackScaler.getpY());
            humanFormEntity.stackScaler.setpZ(deadHumanFormEntity.stackScaler.getpZ());
            humanFormEntity.setStackScale(deadHumanFormEntity.stackScale());
            entity.m_9236_().m_7967_((Entity)humanFormEntity);
        } else if (entity instanceof DeadPlayerFormEntity) {
            DeadPlayerFormEntity deadPlayerFormEntity = (DeadPlayerFormEntity)entity;
            PlayerFormEntity playerFormEntity = new PlayerFormEntity((EntityType<? extends Monster>)((EntityType)EntityRegistry.PLAYER_FORM.get()), entity.m_9236_());
            playerFormEntity.m_6027_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            playerFormEntity.setVariant(deadPlayerFormEntity.getVariant());
            playerFormEntity.m_8061_(EquipmentSlot.HEAD, deadPlayerFormEntity.m_6844_(EquipmentSlot.HEAD));
            playerFormEntity.m_8061_(EquipmentSlot.CHEST, deadPlayerFormEntity.m_6844_(EquipmentSlot.CHEST));
            playerFormEntity.m_8061_(EquipmentSlot.LEGS, deadPlayerFormEntity.m_6844_(EquipmentSlot.LEGS));
            playerFormEntity.m_8061_(EquipmentSlot.FEET, deadPlayerFormEntity.m_6844_(EquipmentSlot.FEET));
            playerFormEntity.m_8061_(EquipmentSlot.MAINHAND, deadPlayerFormEntity.m_21205_());
            playerFormEntity.m_5618_(((DeadPlayerFormEntity)entity).f_20883_);
            playerFormEntity.m_5616_(((DeadPlayerFormEntity)entity).f_20885_);
            playerFormEntity.setIsReanimated(true);
            playerFormEntity.setTransformed(true);
            this.registerExtra(playerFormEntity, (Entity)deadPlayerFormEntity);
            playerFormEntity.stackScaler.setpX(deadPlayerFormEntity.stackScaler.getpX());
            playerFormEntity.stackScaler.setpY(deadPlayerFormEntity.stackScaler.getpY());
            playerFormEntity.stackScaler.setpZ(deadPlayerFormEntity.stackScaler.getpZ());
            playerFormEntity.setStackScale(deadPlayerFormEntity.stackScale());
            entity.m_9236_().m_7967_((Entity)playerFormEntity);
        } else if (entity instanceof DeadVillagerFormEntity) {
            DeadVillagerFormEntity deadVillagerFormEntity = (DeadVillagerFormEntity)entity;
            VillagerFormEntity villagerFormEntity = new VillagerFormEntity((EntityType<? extends Monster>)((EntityType)EntityRegistry.VILLAGER_FORM.get()), entity.m_9236_());
            villagerFormEntity.m_6027_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            villagerFormEntity.setVariant(deadVillagerFormEntity.getVariant());
            villagerFormEntity.m_5618_(((DeadVillagerFormEntity)entity).f_20883_);
            villagerFormEntity.m_5616_(((DeadVillagerFormEntity)entity).f_20885_);
            villagerFormEntity.setIsReanimated(true);
            villagerFormEntity.setTransformed(true);
            this.registerExtra(villagerFormEntity, (Entity)deadVillagerFormEntity);
            villagerFormEntity.stackScaler.setpX(deadVillagerFormEntity.stackScaler.getpX());
            villagerFormEntity.stackScaler.setpY(deadVillagerFormEntity.stackScaler.getpY());
            villagerFormEntity.stackScaler.setpZ(deadVillagerFormEntity.stackScaler.getpZ());
            villagerFormEntity.setStackScale(deadVillagerFormEntity.stackScale());
            entity.m_9236_().m_7967_((Entity)villagerFormEntity);
        } else if (entity instanceof DeadPillagerFormEntity) {
            DeadPillagerFormEntity deadPillagerFormEntity = (DeadPillagerFormEntity)entity;
            PillagerFormEntity pillagerFormEntity = new PillagerFormEntity((EntityType<? extends Monster>)((EntityType)EntityRegistry.PILLAGER_FORM.get()), entity.m_9236_());
            pillagerFormEntity.m_6027_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            pillagerFormEntity.setVariant(deadPillagerFormEntity.getVariant());
            pillagerFormEntity.m_8061_(EquipmentSlot.MAINHAND, deadPillagerFormEntity.m_21205_());
            pillagerFormEntity.m_5618_(((DeadPillagerFormEntity)entity).f_20883_);
            pillagerFormEntity.m_5616_(((DeadPillagerFormEntity)entity).f_20885_);
            pillagerFormEntity.setIsReanimated(true);
            pillagerFormEntity.setTransformed(true);
            this.registerExtra(pillagerFormEntity, (Entity)deadPillagerFormEntity);
            pillagerFormEntity.stackScaler.setpX(deadPillagerFormEntity.stackScaler.getpX());
            pillagerFormEntity.stackScaler.setpY(deadPillagerFormEntity.stackScaler.getpY());
            pillagerFormEntity.stackScaler.setpZ(deadPillagerFormEntity.stackScaler.getpZ());
            pillagerFormEntity.setStackScale(deadPillagerFormEntity.stackScale());
            entity.m_9236_().m_7967_((Entity)pillagerFormEntity);
        } else if (entity instanceof DeadVindicatorFormEntity) {
            DeadVindicatorFormEntity deadVindicatorFormEntity = (DeadVindicatorFormEntity)entity;
            VindicatorFormEntity vindicatorFormEntity = new VindicatorFormEntity((EntityType<? extends Monster>)((EntityType)EntityRegistry.VINDICATOR_FORM.get()), entity.m_9236_());
            vindicatorFormEntity.m_6027_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            vindicatorFormEntity.setVariant(deadVindicatorFormEntity.getVariant());
            vindicatorFormEntity.m_8061_(EquipmentSlot.MAINHAND, deadVindicatorFormEntity.m_21205_());
            vindicatorFormEntity.m_5618_(((DeadVindicatorFormEntity)entity).f_20883_);
            vindicatorFormEntity.m_5616_(((DeadVindicatorFormEntity)entity).f_20885_);
            vindicatorFormEntity.setIsReanimated(true);
            vindicatorFormEntity.setTransformed(true);
            this.registerExtra(vindicatorFormEntity, (Entity)deadVindicatorFormEntity);
            vindicatorFormEntity.stackScaler.setpX(deadVindicatorFormEntity.stackScaler.getpX());
            vindicatorFormEntity.stackScaler.setpY(deadVindicatorFormEntity.stackScaler.getpY());
            vindicatorFormEntity.stackScaler.setpZ(deadVindicatorFormEntity.stackScaler.getpZ());
            vindicatorFormEntity.setStackScale(deadVindicatorFormEntity.stackScale());
            entity.m_9236_().m_7967_((Entity)vindicatorFormEntity);
        } else if (entity instanceof DeadEvokerFormEntity) {
            DeadEvokerFormEntity deadEvokerFormEntity = (DeadEvokerFormEntity)entity;
            EvokerFormEntity evokerFormEntity = new EvokerFormEntity((EntityType<? extends Monster>)((EntityType)EntityRegistry.EVOKER_FORM.get()), entity.m_9236_());
            evokerFormEntity.m_6027_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            evokerFormEntity.setVariant(deadEvokerFormEntity.getVariant());
            evokerFormEntity.m_8061_(EquipmentSlot.MAINHAND, deadEvokerFormEntity.m_21205_());
            evokerFormEntity.m_5618_(((DeadEvokerFormEntity)entity).f_20883_);
            evokerFormEntity.m_5616_(((DeadEvokerFormEntity)entity).f_20885_);
            evokerFormEntity.setIsReanimated(true);
            evokerFormEntity.setTransformed(true);
            this.registerExtra(evokerFormEntity, (Entity)deadEvokerFormEntity);
            evokerFormEntity.stackScaler.setpX(deadEvokerFormEntity.stackScaler.getpX());
            evokerFormEntity.stackScaler.setpY(deadEvokerFormEntity.stackScaler.getpY());
            evokerFormEntity.stackScaler.setpZ(deadEvokerFormEntity.stackScaler.getpZ());
            evokerFormEntity.setStackScale(deadEvokerFormEntity.stackScale());
            entity.m_9236_().m_7967_((Entity)evokerFormEntity);
        } else if (entity instanceof DeadSangheiliFormEntity) {
            DeadSangheiliFormEntity deadSangheiliFormEntity = (DeadSangheiliFormEntity)entity;
            SangheiliFormEntity sangheiliFormEntity = new SangheiliFormEntity((EntityType<? extends Monster>)((EntityType)EntityRegistry.SANGHEILI_FORM.get()), entity.m_9236_());
            sangheiliFormEntity.m_6027_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            sangheiliFormEntity.setVariant(deadSangheiliFormEntity.getVariant());
            sangheiliFormEntity.setTextureVariant(deadSangheiliFormEntity.getTextureVariant());
            sangheiliFormEntity.setGunVariant(deadSangheiliFormEntity.getGunVariant());
            sangheiliFormEntity.m_8061_(EquipmentSlot.MAINHAND, deadSangheiliFormEntity.m_21205_());
            sangheiliFormEntity.setAmmo(deadSangheiliFormEntity.getAmmo());
            sangheiliFormEntity.m_5618_(((DeadSangheiliFormEntity)entity).f_20883_);
            sangheiliFormEntity.m_5616_(((DeadSangheiliFormEntity)entity).f_20885_);
            sangheiliFormEntity.setIsReanimated(true);
            sangheiliFormEntity.setTransformed(true);
            this.registerExtra(sangheiliFormEntity, (Entity)deadSangheiliFormEntity);
            sangheiliFormEntity.stackScaler.setpX(deadSangheiliFormEntity.stackScaler.getpX());
            sangheiliFormEntity.stackScaler.setpY(deadSangheiliFormEntity.stackScaler.getpY());
            sangheiliFormEntity.stackScaler.setpZ(deadSangheiliFormEntity.stackScaler.getpZ());
            sangheiliFormEntity.setStackScale(deadSangheiliFormEntity.stackScale());
            entity.m_9236_().m_7967_((Entity)sangheiliFormEntity);
        } else if (entity instanceof DeadMarineFormEntity) {
            DeadMarineFormEntity deadMarineFormEntity = (DeadMarineFormEntity)entity;
            MarineFormEntity marineFormEntity = new MarineFormEntity((EntityType<? extends Monster>)((EntityType)EntityRegistry.MARINE_FORM.get()), entity.m_9236_());
            marineFormEntity.m_6027_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            marineFormEntity.setVariant(deadMarineFormEntity.getVariant());
            marineFormEntity.setGunVariant(deadMarineFormEntity.getGunVariant());
            marineFormEntity.m_8061_(EquipmentSlot.MAINHAND, deadMarineFormEntity.m_21205_());
            marineFormEntity.setAmmo(deadMarineFormEntity.getAmmo());
            marineFormEntity.m_5618_(((DeadMarineFormEntity)entity).f_20883_);
            marineFormEntity.m_5616_(((DeadMarineFormEntity)entity).f_20885_);
            marineFormEntity.setIsReanimated(true);
            marineFormEntity.setTransformed(true);
            this.registerExtra(marineFormEntity, (Entity)deadMarineFormEntity);
            marineFormEntity.stackScaler.setpX(deadMarineFormEntity.stackScaler.getpX());
            marineFormEntity.stackScaler.setpY(deadMarineFormEntity.stackScaler.getpY());
            marineFormEntity.stackScaler.setpZ(deadMarineFormEntity.stackScaler.getpZ());
            marineFormEntity.setStackScale(deadMarineFormEntity.stackScale());
            marineFormEntity.setHasHelmet(deadMarineFormEntity.hasHelmet());
            entity.m_9236_().m_7967_((Entity)marineFormEntity);
        } else if (entity instanceof UnarmedFloodedGolemEntity) {
            UnarmedFloodedGolemEntity unarmedFloodedGolemEntity = (UnarmedFloodedGolemEntity)entity;
            FloodedGolemEntity floodedGolemEntity = new FloodedGolemEntity((EntityType<? extends Monster>)((EntityType)EntityRegistry.FLOODED_GOLEM.get()), entity.m_9236_());
            floodedGolemEntity.m_6027_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            floodedGolemEntity.m_8061_(EquipmentSlot.MAINHAND, unarmedFloodedGolemEntity.m_21205_());
            floodedGolemEntity.m_5618_(((UnarmedFloodedGolemEntity)entity).f_20883_);
            floodedGolemEntity.m_5616_(((UnarmedFloodedGolemEntity)entity).f_20885_);
            floodedGolemEntity.setIsArmed(true);
            floodedGolemEntity.setTransformed(true);
            this.registerExtra(floodedGolemEntity, (Entity)unarmedFloodedGolemEntity);
            floodedGolemEntity.stackScaler.setpX(unarmedFloodedGolemEntity.stackScaler.getpX());
            floodedGolemEntity.stackScaler.setpY(unarmedFloodedGolemEntity.stackScaler.getpY());
            floodedGolemEntity.stackScaler.setpZ(unarmedFloodedGolemEntity.stackScaler.getpZ());
            floodedGolemEntity.setStackScale(unarmedFloodedGolemEntity.stackScale());
            entity.m_9236_().m_7967_((Entity)floodedGolemEntity);
        }
    }

    private void registerExtra(BaseForm baseForm, Entity entity) {
        baseForm.m_146926_(entity.m_146909_());
        baseForm.m_146922_(entity.m_146908_());
        baseForm.m_21153_(baseForm.m_21233_() / 2.0f);
        baseForm.m_21563_().m_24964_(entity.m_20154_());
        baseForm.m_6593_(entity.m_7770_());
    }

    private void registerExtra(FloodedGolemEntity floodedGolemEntity, Entity entity) {
        floodedGolemEntity.m_146926_(entity.m_146909_());
        floodedGolemEntity.m_146922_(entity.m_146908_());
        floodedGolemEntity.m_21153_(floodedGolemEntity.m_21233_() * 0.35f);
        floodedGolemEntity.m_21563_().m_24964_(entity.m_20154_());
        floodedGolemEntity.m_6593_(entity.m_7770_());
    }

    private void generateParticles(Level level, Entity entity, RandomSource random) {
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            if (!PerformanceEngine.hasPerformanceModeOn()) {
                AAALevel.addParticle((Level)world, (boolean)true, (ParticleEmitterInfo)ParticleResourceRegistry.getTemporaryFloodSmoke().clone().scale(0.15f).position(entity.m_20208_(0.25), entity.m_20188_() + 0.2, entity.m_20262_(0.25)));
            }
            world.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.GUTS.get()), entity.m_20208_(0.5), entity.m_20187_() + 0.35, entity.m_20262_(0.65), PerformanceEngine.getParticleCount(35), 0.1, 0.2, 0.1, ParticleUtils.getDownwardsSmallSpread((RandomSource)random));
            world.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.FLOOD_BLOOD_SPLASH.get()), entity.m_20208_(0.25), entity.m_20187_() + 0.25, entity.m_20262_(0.25), PerformanceEngine.getParticleCount(70), 0.1, 0.2, 0.1, ParticleUtils.getDownwardsSmallSpread((RandomSource)random));
        }
    }

    private void playReanimationSound(Level level, Entity entity) {
        level.m_5594_(null, entity.m_20183_(), SoundEvents.f_12609_, SoundSource.HOSTILE, 1.25f, 0.95f);
    }

    @Nullable
    private PathfinderMob getFreePartner() {
        List list = this.level.m_45971_(this.partnerClass, PARTNER_TARGETING, (LivingEntity)this.mob, this.mob.m_20191_().m_82400_(this.mob.m_21172_(Attributes.f_22277_)));
        double d0 = Double.MAX_VALUE;
        PathfinderMob inf = null;
        for (PathfinderMob inf1 : list) {
            if (!(this.mob.m_20280_((Entity)inf1) < d0)) continue;
            inf = inf1;
            d0 = this.mob.m_20280_((Entity)inf1);
        }
        return inf;
    }
}

