/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.entity.custom;

import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import mod.chloeprime.aaaparticles.api.common.AAALevel;
import mod.chloeprime.aaaparticles.api.common.ParticleEmitterInfo;
import net.asestefan.screenshake.ScreenShakeUtils;
import net.asestefan.utils.MathUtils;
import net.asestefan.utils.ParticleUtils;
import net.asestefan.utils.SoundUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.NetworkHooks;
import net.teamabyssalofficial.dotf.config.DawnOfTheFloodConfig;
import net.teamabyssalofficial.entity.ai.CustomMeleeAttackGoal;
import net.teamabyssalofficial.entity.ai.EscapeFromVehicleGoal;
import net.teamabyssalofficial.entity.ai.FastSwimmingDiveGoal;
import net.teamabyssalofficial.entity.categories.BaseForm;
import net.teamabyssalofficial.entity.custom.PillagerFormEntity;
import net.teamabyssalofficial.entity.custom.PlayerFormEntity;
import net.teamabyssalofficial.entity.custom.PodInfectorEntity;
import net.teamabyssalofficial.entity.custom.SangheiliFormEntity;
import net.teamabyssalofficial.entity.custom.special.CovenantOrsShipEntity;
import net.teamabyssalofficial.entity.custom.special.IronAxeEntity;
import net.teamabyssalofficial.guns.bullet.AbstractBullet;
import net.teamabyssalofficial.impl.StackScaler;
import net.teamabyssalofficial.registry.DamageTypeRegistry;
import net.teamabyssalofficial.registry.EffectRegistry;
import net.teamabyssalofficial.registry.EntityRegistry;
import net.teamabyssalofficial.registry.ItemRegistry;
import net.teamabyssalofficial.registry.ParticleRegistry;
import net.teamabyssalofficial.registry.ParticleResourceRegistry;
import net.teamabyssalofficial.registry.SoundRegistry;
import net.teamabyssalofficial.util.BlockUtils;
import net.teamabyssalofficial.util.PerformanceEngine;
import net.teamabyssalofficial.util.WorldDataUtils;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class EndermanFormEntity
extends Monster
implements GeoEntity,
SoundUtils {
    private static final EntityDataAccessor<Integer> AGGRO_TICKS = SynchedEntityData.m_135353_(EndermanFormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> EXPLOSION_TICKS = SynchedEntityData.m_135353_(EndermanFormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TRANSFORM_TICKS = SynchedEntityData.m_135353_(EndermanFormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> TRANSFORM_SPAWNED = SynchedEntityData.m_135353_(EndermanFormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> STACK_SCALE = SynchedEntityData.m_135353_(EndermanFormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public final StackScaler stackScaler = new StackScaler(1.09f, 1.09f, 1.09f);
    private static final int EXPLOSION_TICK = 40;
    public final double noSpeed = 0.0;
    public final float randFactor = 2.5f;
    private boolean isClose = false;
    private boolean isImmobile = false;

    public EndermanFormEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 16.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.6f);
        this.m_274367_(1.75f);
        this.f_21364_ = 10;
        EntityRegistry.FLOOD_FORMS.add((Entity)this);
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(AGGRO_TICKS, (Object)0);
        this.f_19804_.m_135372_(EXPLOSION_TICKS, (Object)0);
        this.f_19804_.m_135372_(TRANSFORM_TICKS, (Object)40);
        this.f_19804_.m_135372_(STACK_SCALE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(TRANSFORM_SPAWNED, (Object)false);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("aggroTicks", this.getAggroTicks());
        nbt.m_128405_("explosionTicks", this.getExplosionTicks());
        nbt.m_128405_("transformTicks", this.getTransformTicks());
        nbt.m_128350_("stackScale", this.stackScale());
        nbt.m_128379_("transformSpawned", this.isTransformSpawned());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setAggroTicks(nbt.m_128451_("aggroTicks"));
        this.setExplosionTicks(nbt.m_128451_("explosionTicks"));
        this.setTransformTicks(nbt.m_128451_("transformTicks"));
        this.setStackScale(nbt.m_128457_("stackScale"));
        this.setTransformSpawned(nbt.m_128471_("transformSpawned"));
    }

    public boolean hasOvercomeWaterWeakness() {
        ServerLevel world;
        Level level = this.m_9236_();
        return level instanceof ServerLevel && WorldDataUtils.getWorldDataRegistry(world = (ServerLevel)level).getWave() >= 5 || (Boolean)DawnOfTheFloodConfig.SERVER.enderman_form_sensible_to_water.get() == false;
    }

    public boolean m_6126_() {
        return !this.hasOvercomeWaterWeakness();
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22279_, 0.45).m_22268_(Attributes.f_22276_, ((Double)DawnOfTheFloodConfig.SERVER.enderman_form_health.get()).doubleValue()).m_22268_(Attributes.f_22281_, ((Double)DawnOfTheFloodConfig.SERVER.enderman_form_damage.get()).doubleValue()).m_22268_(Attributes.f_22282_, 0.35).m_22268_(Attributes.f_22278_, 0.25).m_22268_(Attributes.f_22284_, 5.0);
    }

    public int m_20146_() {
        return super.m_6062_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new CustomMeleeAttackGoal((PathfinderMob)this, 1.2, false){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 2.0 + (double)(entity.m_20205_() * entity.m_20205_());
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new FastSwimmingDiveGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8){

            public boolean m_8036_() {
                return super.m_8036_() && this.f_25725_.m_5448_() == null;
            }

            public boolean m_8045_() {
                return super.m_8045_() && this.f_25725_.m_5448_() == null;
            }
        });
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f){

            public boolean m_8036_() {
                return super.m_8036_() && !EndermanFormEntity.this.hasOvercomeWaterWeakness();
            }
        });
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true, this::targetPredicate));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{BaseForm.class}));
        this.f_21345_.m_25352_(4, (Goal)new EscapeFromVehicleGoal((Mob)this));
    }

    private boolean targetPredicate(LivingEntity liv) {
        return !EntityRegistry.FLOOD_FORMS.contains(liv) && !(liv instanceof CovenantOrsShipEntity) && !(liv instanceof Squid) && !(liv instanceof ArmorStand) && !(liv instanceof AbstractFish) && !(liv instanceof Bat) && !((List)DawnOfTheFloodConfig.SERVER.blacklist.get()).contains(liv.m_20078_());
    }

    public static boolean checkEndermanFormRules(EntityType<? extends EndermanFormEntity> entityType, ServerLevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos pos, RandomSource source) {
        WorldDataUtils worldDataUtils = WorldDataUtils.getWorldDataRegistry(levelAccessor.m_6018_());
        int currentWave = worldDataUtils.getWave();
        return levelAccessor.m_46791_() != Difficulty.PEACEFUL && EndermanFormEntity.m_219009_((ServerLevelAccessor)levelAccessor, (BlockPos)pos, (RandomSource)source) && EndermanFormEntity.m_217057_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)pos, (RandomSource)source) && currentWave > 2 && worldDataUtils.getEndermanTicks() == 0;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerV) {
        controllerV.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller1", 7, event -> {
            if (!event.isMoving() && !this.m_5912_()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("enderman.form.idle"));
            }
            if (event.isMoving() && !this.m_5912_()) {
                event.getController().setAnimationSpeed(1.5);
                return event.setAndContinue(RawAnimation.begin().thenLoop("enderman.form.walk"));
            }
            if (event.isMoving() && this.m_5912_()) {
                event.getController().setAnimationSpeed(1.25);
                return event.setAndContinue(RawAnimation.begin().thenLoop("enderman.form.target"));
            }
            if (this.getExplosionTicks() > 0) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("enderman.form.death"));
            }
            if (this.isTransformSpawned() && this.getTransformTicks() > 0) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("enderman.form.transform"));
            }
            return PlayState.CONTINUE;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public int getAggroTicks() {
        return (Integer)this.f_19804_.m_135370_(AGGRO_TICKS);
    }

    public void setAggroTicks(int ticks) {
        this.f_19804_.m_135381_(AGGRO_TICKS, (Object)ticks);
    }

    public int getExplosionTicks() {
        return (Integer)this.f_19804_.m_135370_(EXPLOSION_TICKS);
    }

    public void setExplosionTicks(int ticks) {
        this.f_19804_.m_135381_(EXPLOSION_TICKS, (Object)ticks);
    }

    public float stackScale() {
        return ((Float)this.f_19804_.m_135370_(STACK_SCALE)).floatValue();
    }

    public void setStackScale(float pScale) {
        this.f_19804_.m_135381_(STACK_SCALE, (Object)Float.valueOf(pScale));
    }

    public int getTransformTicks() {
        return (Integer)this.f_19804_.m_135370_(TRANSFORM_TICKS);
    }

    public void setTransformTicks(int ticks) {
        this.f_19804_.m_135381_(TRANSFORM_TICKS, (Object)ticks);
    }

    public boolean isTransformSpawned() {
        return (Boolean)this.f_19804_.m_135370_(TRANSFORM_SPAWNED);
    }

    public void setTransformSpawned(boolean transformSpawned) {
        this.f_19804_.m_135381_(TRANSFORM_SPAWNED, (Object)transformSpawned);
    }

    public void randomizeScale(float pFactor) {
        float scalingMul = this.f_19796_.m_188501_() / pFactor;
        this.setStackScale(this.stackScale() + scalingMul);
    }

    public float getVolume() {
        return 1.85f;
    }

    public float getPitch(RandomSource random) {
        return 0.75f;
    }

    protected SoundEvent m_7975_(DamageSource p_33034_) {
        return (SoundEvent)SoundRegistry.FLOOD_ENDERMAN_HURT.get();
    }

    protected void m_7355_(BlockPos pPos, BlockState pState) {
        super.m_7355_(pPos, pState);
        this.m_5496_((SoundEvent)SoundRegistry.ENTITY_FORM_STEP.get(), this.getVolume() / 2.0f, this.getPitch(this.f_19796_) + 0.25f);
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.FLOOD_ENDERMAN_DEATH.get();
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundRegistry.FLOOD_ENDERMAN_IDLE.get();
    }

    private void spawnLingeringCloud() {
        AreaEffectCloud cloud = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
        cloud.m_19712_(1.5f);
        cloud.m_19732_(-0.5f);
        cloud.m_19740_(6);
        cloud.m_19716_(new MobEffectInstance(MobEffects.f_19614_, 100, 0));
        cloud.m_19734_(Mth.m_14107_((double)((double)cloud.m_19748_() / 3.0 * 1.2)));
        cloud.m_19738_(-cloud.m_19743_() / (float)cloud.m_19748_());
        this.m_9236_().m_7967_((Entity)cloud);
    }

    private void spawnPods(Entity entity) {
        PodInfectorEntity podInfectorEntity = new PodInfectorEntity((EntityType<? extends Monster>)((EntityType)EntityRegistry.POD_INFECTOR.get()), entity.m_9236_());
        podInfectorEntity.m_6027_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        entity.m_9236_().m_7967_((Entity)podInfectorEntity);
        podInfectorEntity.m_20254_(entity.m_20094_());
        podInfectorEntity.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.FROM_THE_SOURCE.get(), 500, 0));
    }

    private void vanishFully() {
        if (!this.m_9236_().f_46443_) {
            this.f_20890_ = true;
            this.m_146870_();
        }
    }

    public void burst(int podCount, float volume, float pitch) {
        AABB boundingBox = this.m_20191_().m_82400_(3.0);
        List entities = this.m_9236_().m_45933_((Entity)this, boundingBox);
        for (Entity entity : entities) {
            LivingEntity livingEntity;
            if (entity instanceof LivingEntity && !EntityRegistry.FLOOD_FORMS.contains(livingEntity = (LivingEntity)entity)) {
                if (!livingEntity.m_21023_(MobEffects.f_19614_)) {
                    int pDuration = 100 + this.f_19796_.m_188503_(100);
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, pDuration, 0));
                }
                float dist = this.m_20270_((Entity)livingEntity);
                float arclen = (float)(MathUtils.arcfloat((double)dist) * (3.1415927410125732 + this.f_19796_.m_188583_()));
                livingEntity.m_6469_(DamageTypeRegistry.enderman_explosion_damage((LivingEntity)this), (float)(this.m_21133_(Attributes.f_22281_) * (double)arclen));
            }
            AABB aabb = this.m_20191_().m_82400_(1.0);
            for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                BlockUtils.generateBlood(this.m_9236_(), blockpos);
            }
        }
        this.spawnLingeringCloud();
        this.vanishFully();
        for (int i = 0; i < podCount; ++i) {
            this.spawnPods((Entity)this);
        }
        if (((Boolean)DawnOfTheFloodConfig.SERVER.base_form_screen_shake.get()).booleanValue() && PerformanceEngine.canPerformShake((LivingEntity)this, this.m_9236_(), 8.0)) {
            ScreenShakeUtils.ScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)PerformanceEngine.getShakeRadius(5), (float)0.07f, (int)4, (int)9);
        }
        this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SoundRegistry.BASE_FORM_EXPLODE.get(), SoundSource.HOSTILE, volume + 0.25f, pitch);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (!PerformanceEngine.hasPerformanceModeOn()) {
                AAALevel.addParticle((Level)server, (boolean)true, (ParticleEmitterInfo)ParticleResourceRegistry.getPodExplosionSmoke().clone().scale(1.45f).position(this.m_20182_()));
            }
            server.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.GUTS.get()), this.m_20208_(0.5), this.m_20187_() + 0.35, this.m_20262_(0.65), PerformanceEngine.getParticleCount(10), 0.1, 0.2, 0.1, ParticleUtils.getDownwardsSmallSpread((RandomSource)this.f_19796_) * 0.65);
            server.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.FLYING_REMAIN.get()), this.m_20208_(0.5), this.m_20187_() + 0.35, this.m_20262_(0.65), PerformanceEngine.getParticleCount(45), 0.1, 0.2, 0.1, ParticleUtils.getDownwardsLargeSpread((RandomSource)this.f_19796_) * 0.85);
        }
    }

    protected void m_8024_() {
        if (this.getExplosionTicks() > 0) {
            this.setExplosionTicks(this.getExplosionTicks() - 1);
        }
        if (this.getTransformTicks() > 0) {
            this.setTransformTicks(this.getTransformTicks() - 1);
        }
        super.m_8024_();
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        Arrow arrow;
        Entity entity = pSource.m_7640_();
        if (entity instanceof Arrow && ((arrow = (Arrow)entity).m_19749_() instanceof PlayerFormEntity || arrow.m_19749_() instanceof PillagerFormEntity)) {
            return false;
        }
        if (pSource.m_7640_() instanceof AbstractBullet) {
            return false;
        }
        if (pSource.m_7640_() instanceof IronAxeEntity) {
            return false;
        }
        if (pSource.m_7639_() != null && Math.random() <= 0.9 && ((Boolean)DawnOfTheFloodConfig.SERVER.enderman_form_teleportation.get()).booleanValue()) {
            this.shortTp();
        }
        if (this.m_6673_(pSource)) {
            return false;
        }
        boolean flag = pSource.m_7640_() instanceof ThrownPotion;
        if (pSource.m_269533_(DamageTypeTags.f_268524_) && ((Boolean)DawnOfTheFloodConfig.SERVER.enderman_form_teleportation.get()).booleanValue()) {
            this.shortTp();
        }
        if (!pSource.m_269533_(DamageTypeTags.f_268524_) && !flag) {
            boolean flag2 = super.m_6469_(pSource, pAmount);
            if (!this.m_9236_().m_5776_() && !(pSource.m_7639_() instanceof LivingEntity) && this.f_19796_.m_188503_(8) != 0 && ((Boolean)DawnOfTheFloodConfig.SERVER.enderman_form_teleportation.get()).booleanValue()) {
                this.teleport();
            }
            return flag2;
        }
        boolean flag1 = flag && this.hurtWithCleanWater(pSource, (ThrownPotion)pSource.m_7640_(), pAmount);
        for (int i = 0; i < 64; ++i) {
            if (!this.teleport() || !((Boolean)DawnOfTheFloodConfig.SERVER.enderman_form_teleportation.get()).booleanValue()) continue;
            return true;
        }
        return flag1;
    }

    public int getSubtractionPoints() {
        return 150;
    }

    public void m_8107_() {
        if (this.m_9236_().f_46443_) {
            for (int i = 0; i < 3; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20208_(0.75), this.m_20187_() + 0.25, this.m_20262_(0.75), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
            }
        }
        super.m_8107_();
    }

    public void m_6667_(DamageSource source) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            WorldDataUtils worldDataUtils = WorldDataUtils.getWorldDataRegistry(world);
            int currentScore = worldDataUtils.getScore();
            int currentWave = worldDataUtils.getWave();
            if (currentWave > 2) {
                worldDataUtils.setScore(currentScore - this.getSubtractionPoints());
            }
        }
        super.m_6667_(source);
    }

    protected void m_7472_(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        super.m_7472_(pSource, pLooting, pRecentlyHit);
        if (Math.random() <= (double)0.1f) {
            this.m_19998_((ItemLike)ItemRegistry.FLOODED_ENDER_PEARL.get());
        }
    }

    private void summonFloodParticle() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.FLOOD_BLOOD_SPLASH.get()), this.m_20208_(0.25), this.m_20187_() + 0.25, this.m_20262_(0.25), 3, 0.1, 0.2, 0.1, ParticleUtils.getDownwardsSmallSpread((RandomSource)this.f_19796_));
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_21223_() <= 8.0f) {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_(this.noSpeed);
            if (!this.isClose) {
                this.setExplosionTicks(40);
                this.m_20331_(true);
                this.isClose = true;
            }
        }
        if (this.getTransformTicks() > 0 && !this.isImmobile) {
            this.isImmobile = true;
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_(0.0);
        }
        if (this.getTransformTicks() == 0 && this.isImmobile) {
            this.isImmobile = false;
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_(0.45);
        }
        if (this.getExplosionTicks() == 1) {
            this.burst(3, this.getVolume(), this.getPitch(this.f_19796_));
        }
        if (this.getTransformTicks() > 0) {
            this.summonFloodParticle();
        }
        if (this.getTransformTicks() == 38) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundRegistry.ENTITY_FORM_SPAWN.get(), this.m_5720_(), this.getVolume(), this.getPitch(this.f_19796_) - 0.35f);
        }
        if (this.m_5448_() != null && this.getTransformTicks() == 0 && this.m_217043_().m_188503_(15) == 0 && ((Boolean)DawnOfTheFloodConfig.SERVER.enderman_form_teleportation.get()).booleanValue() && this.m_5448_() != null && this.getExplosionTicks() == 0) {
            this.teleportTowards((Entity)this.m_5448_());
            this.m_6710_(this.m_5448_());
            this.f_20883_ = this.f_20885_;
            this.m_146922_(this.f_20883_);
            if (this.m_5448_() != null) {
                this.m_21563_().m_24960_((Entity)this.m_5448_(), 30.0f, 90.0f);
            }
            if (((Boolean)DawnOfTheFloodConfig.SERVER.enderman_form_reinforcements.get()).booleanValue() && Math.random() <= (Double)DawnOfTheFloodConfig.SERVER.enderman_form_reinforcement_rate.get() && this.m_5448_() != null) {
                if (this.m_217043_().m_188503_(4) != 0) {
                    double d1 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 2.0;
                    double d2 = this.m_20186_() + Mth.m_14005_((double)0.0, (double)0.5);
                    double d3 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 2.0;
                    this.teleportAlly(d1, d2, d3);
                } else {
                    double d1 = this.m_5448_().m_20185_() + this.f_19796_.m_188500_();
                    double d2 = this.m_5448_().m_20186_() + (double)(this.f_19796_.m_188503_(24) - 12);
                    double d3 = this.m_5448_().m_20189_() + this.f_19796_.m_188500_();
                    this.teleportAlly(d1, d2, d3);
                }
                this.m_6710_(this.m_5448_());
            }
        }
        if (this.m_5448_() != null && ((Boolean)DawnOfTheFloodConfig.SERVER.carrier_form_aggro_despawn.get()).booleanValue()) {
            this.setAggroTicks(this.getAggroTicks() + 1);
        }
        if (!this.m_9236_().f_46443_) {
            this.m_21195_(MobEffects.f_19614_);
        }
        if (this.canRegenerate() && ((Boolean)DawnOfTheFloodConfig.SERVER.enderman_form_regeneration.get()).booleanValue() && this.m_217043_().m_188503_(240) == 0 && (double)this.m_21223_() < (double)this.m_21233_() - 1.5) {
            this.m_5634_(1.5f);
        }
    }

    protected boolean teleport() {
        if (!this.m_9236_().m_5776_() && this.m_6084_()) {
            double d0 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
            double d1 = this.m_20186_() + (double)(this.f_19796_.m_188503_(64) - 32);
            double d2 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
            return this.teleport(d0, d1, d2);
        }
        return false;
    }

    public void teleportAlly(double d1, double d2, double d3) {
        AABB boundingBox = this.m_20191_().m_82400_(80.0);
        List entities = this.m_9236_().m_45933_((Entity)this, boundingBox);
        Random random = new Random();
        if (!entities.isEmpty()) {
            for (int i = 0; i < 1; ++i) {
                LivingEntity livingEntity;
                int randomIndex = random.nextInt(entities.size());
                Entity entity = (Entity)entities.get(randomIndex);
                if (!(entity instanceof LivingEntity) || !((livingEntity = (LivingEntity)entity) instanceof BaseForm) || livingEntity instanceof SangheiliFormEntity || this.m_5448_() == null) continue;
                livingEntity.m_6021_(d1, d2, d3);
                ((BaseForm)livingEntity).m_21561_(true);
                if (this.m_20067_()) continue;
                livingEntity.m_9236_().m_6263_(null, this.f_19854_, this.f_19855_, this.f_19856_, (SoundEvent)SoundRegistry.ENDERMAN_FORM_TP.get(), SoundSource.HOSTILE, 2.0f, 1.0f);
                livingEntity.m_5496_((SoundEvent)SoundRegistry.ENDERMAN_FORM_TP.get(), 1.0f, 1.0f);
            }
        }
    }

    protected boolean shortTp() {
        if (!this.m_9236_().m_5776_() && this.m_6084_()) {
            double d0 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 24.0;
            double d1 = this.m_20186_() + (double)(this.f_19796_.m_188503_(60) - 12);
            double d2 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 24.0;
            return this.teleport(d0, d1, d2);
        }
        return false;
    }

    private boolean teleportTowards(Entity pTarget) {
        Vec3 vec3 = new Vec3(this.m_20185_() - pTarget.m_20185_(), this.m_20227_(0.5) - pTarget.m_20188_(), this.m_20189_() - pTarget.m_20189_());
        vec3 = vec3.m_82541_();
        double d0 = 16.0;
        double d1 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vec3.f_82479_ * 16.0;
        double d2 = this.m_20186_() + (double)(this.f_19796_.m_188503_(16) - 8) - vec3.f_82480_ * 16.0;
        double d3 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vec3.f_82481_ * 16.0;
        return this.teleport(d1, d2, d3);
    }

    private boolean teleport(double pX, double pY, double pZ) {
        if (this.getTransformTicks() > 0) {
            return false;
        }
        this.m_21561_(true);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(pX, pY, pZ);
        while (blockpos$mutableblockpos.m_123342_() > this.m_9236_().m_141937_() && !this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos).m_280555_()) {
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos);
        boolean flag = blockstate.m_280555_();
        boolean flag1 = blockstate.m_60819_().m_205070_(FluidTags.f_13131_);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)pX, (double)pY, (double)pZ);
            if (event.isCanceled()) {
                return false;
            }
            Vec3 vec3 = this.m_20182_();
            boolean flag2 = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2) {
                this.m_9236_().m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)this));
                if (!this.m_20067_()) {
                    this.m_9236_().m_6263_(null, this.f_19854_, this.f_19855_, this.f_19856_, (SoundEvent)SoundRegistry.ENDERMAN_FORM_TP.get(), SoundSource.HOSTILE, 2.0f, 1.0f);
                    this.m_5496_((SoundEvent)SoundRegistry.ENDERMAN_FORM_TP.get(), 1.0f, 1.0f);
                }
            }
            return flag2;
        }
        return false;
    }

    private boolean hurtWithCleanWater(DamageSource pSource, ThrownPotion pPotion, float pAmount) {
        ItemStack itemstack = pPotion.m_7846_();
        Potion potion = PotionUtils.m_43579_((ItemStack)itemstack);
        List list = PotionUtils.m_43547_((ItemStack)itemstack);
        boolean flag = potion == Potions.f_43599_ && list.isEmpty() && !this.hasOvercomeWaterWeakness();
        return flag && super.m_6469_(pSource, pAmount);
    }

    public boolean canRegenerate() {
        return !this.m_6060_();
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return pDistanceToClosestPlayer > 16384.0 || this.getAggroTicks() < (Integer)DawnOfTheFloodConfig.SERVER.enderman_form_aggro_ticks.get();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        this.stackScaler.randomizeScale(this.f_19796_, this.randFactor);
        this.randomizeScale(3.0f);
        return super.m_6518_(pLevel, pDifficulty, pReason, spawnGroupData, compoundTag);
    }
}

