/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.entity.custom;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import mod.chloeprime.aaaparticles.api.common.AAALevel;
import mod.chloeprime.aaaparticles.api.common.ParticleEmitterInfo;
import net.asestefan.screenshake.ScreenShakeUtils;
import net.asestefan.utils.MathUtils;
import net.asestefan.utils.ParticleUtils;
import net.asestefan.utils.SoundUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.NetworkHooks;
import net.teamabyssalofficial.dotf.config.DawnOfTheFloodConfig;
import net.teamabyssalofficial.dotf.controls.WallMovementControl;
import net.teamabyssalofficial.dotf.datagen.tags.GenericBlockTags;
import net.teamabyssalofficial.entity.ai.EscapeFromVehicleGoal;
import net.teamabyssalofficial.entity.ai.FastSwimmingDiveGoal;
import net.teamabyssalofficial.entity.categories.BaseForm;
import net.teamabyssalofficial.entity.custom.PillagerFormEntity;
import net.teamabyssalofficial.entity.custom.PlayerFormEntity;
import net.teamabyssalofficial.entity.custom.PodInfectorEntity;
import net.teamabyssalofficial.entity.custom.special.CovenantOrsShipEntity;
import net.teamabyssalofficial.entity.custom.special.IronAxeEntity;
import net.teamabyssalofficial.guns.bullet.AbstractBullet;
import net.teamabyssalofficial.registry.DamageTypeRegistry;
import net.teamabyssalofficial.registry.EffectRegistry;
import net.teamabyssalofficial.registry.EntityRegistry;
import net.teamabyssalofficial.registry.ParticleRegistry;
import net.teamabyssalofficial.registry.ParticleResourceRegistry;
import net.teamabyssalofficial.registry.SoundRegistry;
import net.teamabyssalofficial.util.BlockUtils;
import net.teamabyssalofficial.util.PerformanceEngine;
import net.teamabyssalofficial.util.SoundPacket;
import net.teamabyssalofficial.util.WorldDataUtils;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class JuggernautFormEntity
extends Monster
implements GeoEntity,
SoundUtils {
    private static final EntityDataAccessor<Integer> AGGRO_TICKS = SynchedEntityData.m_135353_(JuggernautFormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ROAR_TIMER = SynchedEntityData.m_135353_(JuggernautFormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANGER_CAP = SynchedEntityData.m_135353_(JuggernautFormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> STACK_SCALE = SynchedEntityData.m_135353_(JuggernautFormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int attacktick;
    public int attackID;
    public boolean isImmobile = false;
    public static final byte BASH_ATTACK = 1;
    public static final byte STAB_ATTACK = 2;
    public static final byte SLAM_ATTACK = 3;
    public static final int BASH_ATTACK_LENGTH = 21;
    public static final int STAB_ATTACK_LENGTH = 23;
    public static final int SLAM_ATTACK_LENGTH = 40;
    public static final int ROAR_TICKS = 67;

    public JuggernautFormEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 36.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.8f);
        if (((Boolean)DawnOfTheFloodConfig.SERVER.juggernaut_form_climb.get()).booleanValue()) {
            this.f_21342_ = new WallMovementControl((Mob)this);
            this.f_21344_ = new WallClimberNavigation((Mob)this, pLevel);
        }
        this.m_274367_(2.0f);
        this.f_21364_ = 35;
        EntityRegistry.FLOOD_FORMS.add((Entity)this);
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(AGGRO_TICKS, (Object)0);
        this.f_19804_.m_135372_(ROAR_TIMER, (Object)0);
        this.f_19804_.m_135372_(ANGER_CAP, (Object)0);
        this.f_19804_.m_135372_(STACK_SCALE, (Object)Float.valueOf(0.0f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 50.0).m_22268_(Attributes.f_22279_, 0.22).m_22268_(Attributes.f_22276_, ((Double)DawnOfTheFloodConfig.SERVER.juggernaut_form_health.get()).doubleValue()).m_22268_(Attributes.f_22281_, ((Double)DawnOfTheFloodConfig.SERVER.juggernaut_form_damage.get()).doubleValue()).m_22268_(Attributes.f_22282_, 0.95).m_22268_(Attributes.f_22283_, 2.95).m_22268_(Attributes.f_22278_, 2.75).m_22268_(Attributes.f_22284_, 8.0);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("aggroTicks", this.getAggroTicks());
        pCompound.m_128405_("roarTimer", this.getRoarTimer());
        pCompound.m_128405_("angerCap", this.getAngerCap());
        pCompound.m_128350_("stackScale", this.stackScale());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setAggroTicks(pCompound.m_128451_("aggroTicks"));
        this.setRoarTimer(pCompound.m_128451_("roarTimer"));
        this.setAngerCap(pCompound.m_128451_("angerCap"));
        this.setStackScale(pCompound.m_128457_("stackScale"));
    }

    public int m_20146_() {
        return super.m_6062_();
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.f_21345_.m_25352_(5, (Goal)new FastSwimmingDiveGoal((Mob)this, 0.5f));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8){

            public boolean m_8036_() {
                return super.m_8036_() && this.f_25725_.m_5448_() == null;
            }

            public boolean m_8045_() {
                return super.m_8045_() && this.f_25725_.m_5448_() == null;
            }
        });
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true, this::targetPredicate));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{BaseForm.class}));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{PodInfectorEntity.class}));
        this.f_21345_.m_25352_(0, (Goal)new JuggernautFormBashAttackGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new JuggernautFormStabAttackGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new JuggernautFormSlamAttackGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new EscapeFromVehicleGoal((Mob)this));
    }

    private boolean targetPredicate(LivingEntity liv) {
        return !EntityRegistry.FLOOD_FORMS.contains(liv) && !(liv instanceof CovenantOrsShipEntity) && !(liv instanceof Squid) && !(liv instanceof ArmorStand) && !(liv instanceof AbstractFish) && !(liv instanceof Bat) && !((List)DawnOfTheFloodConfig.SERVER.blacklist.get()).contains(liv.m_20078_());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerV) {
        controllerV.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controllerJug", 8, event -> {
            if (this.getRoarTimer() > 0) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("juggernaut.form.roar"));
            }
            if (!event.isMoving() && !this.m_5912_() && this.attackID == 0) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("juggernaut.form.idle"));
            }
            if (event.isMoving() && this.attackID == 0) {
                event.getController().setAnimationSpeed(this.m_5912_() ? 1.25 : 1.0);
                return event.setAndContinue(RawAnimation.begin().thenLoop("juggernaut.form.walk"));
            }
            if (this.attackID == 1) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("juggernaut.form.bash_attack"));
            }
            if (this.attackID == 2) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("juggernaut.form.stab_attack"));
            }
            if (this.attackID == 3) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("juggernaut.form.slam_attack"));
            }
            return PlayState.CONTINUE;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void setAttackID(int id) {
        this.attackID = id;
        this.attacktick = 0;
        this.m_9236_().m_7605_((Entity)this, (byte)(-id));
    }

    public void m_7822_(byte id) {
        if (id <= 0) {
            this.attackID = Math.abs(id);
            this.attacktick = 0;
        } else {
            super.m_7822_(id);
        }
    }

    public int getAggroTicks() {
        return (Integer)this.f_19804_.m_135370_(AGGRO_TICKS);
    }

    public void setAggroTicks(int ticks) {
        this.f_19804_.m_135381_(AGGRO_TICKS, (Object)ticks);
    }

    public int getRoarTimer() {
        return (Integer)this.f_19804_.m_135370_(ROAR_TIMER);
    }

    public void setRoarTimer(int ticks) {
        this.f_19804_.m_135381_(ROAR_TIMER, (Object)ticks);
    }

    public int getAngerCap() {
        return (Integer)this.f_19804_.m_135370_(ANGER_CAP);
    }

    public void setAngerCap(int ticks) {
        this.f_19804_.m_135381_(ANGER_CAP, (Object)ticks);
    }

    public float stackScale() {
        return ((Float)this.f_19804_.m_135370_(STACK_SCALE)).floatValue();
    }

    public void setStackScale(float pScale) {
        this.f_19804_.m_135381_(STACK_SCALE, (Object)Float.valueOf(pScale));
    }

    public void randomizeScale(float pFactor) {
        float scalingMul = this.f_19796_.m_188501_() / pFactor;
        this.setStackScale(this.stackScale() + scalingMul);
    }

    protected void m_8024_() {
        if (this.getRoarTimer() > 0) {
            this.setRoarTimer(this.getRoarTimer() - 1);
        }
        if (this.getAngerCap() > 0 && this.m_217043_().m_188503_(110) == 0) {
            this.setAngerCap(this.getAngerCap() - 1);
        }
        super.m_8024_();
    }

    public boolean m_7327_(Entity pEntity) {
        if (!this.m_9236_().f_46443_ && this.attackID == 0) {
            this.attackID = this.f_19796_.m_188503_(3) != 0 ? 1 : 2;
        }
        return true;
    }

    public void m_8107_() {
        super.m_8107_();
        LivingEntity attackTarget = this.m_5448_();
        if (this.m_6084_() && attackTarget != null && this.m_142582_((Entity)attackTarget) && this.m_20270_((Entity)attackTarget) <= 15.0f && ((Boolean)DawnOfTheFloodConfig.SERVER.juggernaut_form_breaks_blocks.get()).booleanValue()) {
            SoundPacket soundPacket = new SoundPacket((SoundEvent)SoundRegistry.JUGGERNAUT_IDLE.get(), SoundSource.HOSTILE, this.getVolume(), this.getPitch(this.f_19796_));
            BlockUtils.destroyBlocks(this.m_9236_(), (LivingEntity)this, 0.33f, this.getDestroySpeed(), 40, soundPacket);
        }
    }

    public int getDestroySpeed() {
        return 2;
    }

    public static boolean checkFloodJuggernautFormRules(EntityType<? extends JuggernautFormEntity> entityType, ServerLevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos pos, RandomSource source) {
        WorldDataUtils worldDataUtils = WorldDataUtils.getWorldDataRegistry(levelAccessor.m_6018_());
        int currentWave = worldDataUtils.getWave();
        return levelAccessor.m_46791_() != Difficulty.PEACEFUL && JuggernautFormEntity.m_219009_((ServerLevelAccessor)levelAccessor, (BlockPos)pos, (RandomSource)source) && JuggernautFormEntity.m_217057_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)pos, (RandomSource)source) && currentWave > 4;
    }

    public int getSubtractionPoints() {
        return 3000;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SoundRegistry.JUGGERNAUT_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.JUGGERNAUT_DEATH.get();
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundRegistry.JUGGERNAUT_IDLE.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        super.m_7355_(pos, blockIn);
        this.m_5496_((SoundEvent)SoundRegistry.JUGGERNAUT_WALK.get(), this.getVolume() * 0.85f, this.getPitch(this.f_19796_) * 0.55f);
    }

    private void spawnLingeringCloud() {
        AreaEffectCloud cloud = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
        cloud.m_19712_(1.5f);
        cloud.m_19732_(-0.5f);
        cloud.m_19740_(6);
        cloud.m_19716_(new MobEffectInstance(MobEffects.f_19614_, 100, 0));
        cloud.m_19734_(Mth.m_14107_((double)((double)cloud.m_19748_() / 3.0 * 1.2)));
        cloud.m_19738_(-cloud.m_19743_() / (float)cloud.m_19748_());
        this.m_9236_().m_7967_((Entity)cloud);
    }

    private void spawnPods(Entity entity) {
        PodInfectorEntity podInfectorEntity = new PodInfectorEntity((EntityType<? extends Monster>)((EntityType)EntityRegistry.POD_INFECTOR.get()), entity.m_9236_());
        podInfectorEntity.m_6027_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        entity.m_9236_().m_7967_((Entity)podInfectorEntity);
        podInfectorEntity.m_20254_(entity.m_20094_());
        podInfectorEntity.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.FROM_THE_SOURCE.get(), 500, 0));
    }

    private void vanishFully() {
        if (!this.m_9236_().f_46443_) {
            this.f_20890_ = true;
            this.m_146870_();
        }
    }

    public DamageSource getDamage() {
        List<DamageSource> damageSources = List.of(DamageTypeRegistry.form_melee_damage1((LivingEntity)this), DamageTypeRegistry.form_melee_damage2((LivingEntity)this), DamageTypeRegistry.form_melee_damage3((LivingEntity)this), DamageTypeRegistry.form_melee_damage4((LivingEntity)this), DamageTypeRegistry.form_melee_damage5((LivingEntity)this), DamageTypeRegistry.form_melee_damage6((LivingEntity)this), DamageTypeRegistry.form_melee_damage7((LivingEntity)this), DamageTypeRegistry.form_melee_damage8((LivingEntity)this));
        int length = damageSources.size();
        return damageSources.get(this.f_19796_.m_188503_(length));
    }

    public void burst(int podCount, float volume, float pitch) {
        AABB boundingBox = this.m_20191_().m_82400_(3.5);
        List entities = this.m_9236_().m_45933_((Entity)this, boundingBox);
        for (Entity entity : entities) {
            LivingEntity livingEntity;
            if (entity instanceof LivingEntity && !EntityRegistry.FLOOD_FORMS.contains(livingEntity = (LivingEntity)entity)) {
                float dist = this.m_20270_((Entity)livingEntity);
                float arclen = (float)(MathUtils.arcfloat((double)dist) * (3.1415927410125732 + this.f_19796_.m_188583_()));
                livingEntity.m_6469_(this.getDamage(), (float)(this.m_21133_(Attributes.f_22281_) * (double)0.45f * (double)arclen));
            }
            AABB aabb = this.m_20191_().m_82400_(1.0);
            for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                BlockUtils.generateBlood(this.m_9236_(), blockpos);
            }
        }
        this.spawnLingeringCloud();
        this.vanishFully();
        for (int i = 0; i < podCount; ++i) {
            this.spawnPods((Entity)this);
        }
        if (((Boolean)DawnOfTheFloodConfig.SERVER.base_form_screen_shake.get()).booleanValue() && PerformanceEngine.canPerformShake((LivingEntity)this, this.m_9236_(), 10.0)) {
            ScreenShakeUtils.ScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)PerformanceEngine.getShakeRadius(6), (float)0.07f, (int)4, (int)9);
        }
        this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SoundRegistry.BASE_FORM_EXPLODE.get(), SoundSource.HOSTILE, volume + 0.25f, pitch);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (!PerformanceEngine.hasPerformanceModeOn()) {
                AAALevel.addParticle((Level)server, (boolean)true, (ParticleEmitterInfo)ParticleResourceRegistry.getPodExplosionSmoke().clone().scale(1.85f).position(this.m_20182_()));
            }
            server.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.GUTS.get()), this.m_20208_(0.5), this.m_20187_() + 0.35, this.m_20262_(0.65), PerformanceEngine.getParticleCount(15), 0.1, 0.2, 0.1, ParticleUtils.getDownwardsSmallSpread((RandomSource)this.f_19796_) * 0.65);
            server.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.FLYING_REMAIN.get()), this.m_20208_(0.5), this.m_20187_() + 0.35, this.m_20262_(0.65), PerformanceEngine.getParticleCount(45), 0.1, 0.2, 0.1, ParticleUtils.getDownwardsLargeSpread((RandomSource)this.f_19796_) * 0.85);
        }
    }

    public void m_6667_(DamageSource source) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            WorldDataUtils worldDataUtils = WorldDataUtils.getWorldDataRegistry(world);
            int currentScore = worldDataUtils.getScore();
            int currentWave = worldDataUtils.getWave();
            if (currentWave > 4) {
                worldDataUtils.setScore(currentScore - this.getSubtractionPoints());
            }
        }
        this.burst(12, 1.0f, 1.0f);
        super.m_6667_(source);
    }

    private void sweep(Entity pEntity) {
        AABB boundingBox = this.m_20191_().m_82400_((double)2.35f);
        List entities = this.m_9236_().m_45933_((Entity)this, boundingBox);
        for (Entity entity : entities) {
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || !this.targetPredicate(livingEntity = (LivingEntity)entity) || livingEntity == pEntity) continue;
            float dist = this.m_20270_((Entity)livingEntity);
            livingEntity.m_6469_(this.getDamage(), (float)this.m_21133_(Attributes.f_22281_) * (1.0f / dist) * 0.75f);
            livingEntity.m_9236_().m_5594_(null, livingEntity.m_20183_(), SoundEvents.f_12317_, SoundSource.HOSTILE, this.getVolume(), this.getPitch(this.f_19796_) - 0.45f);
        }
    }

    public void destroySwingable() {
        AABB aabb = this.m_20191_().m_82400_((double)1.1f);
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            BlockState blockstate = this.m_9236_().m_8055_(blockpos);
            if (!blockstate.m_204336_(BlockTags.f_13104_) && !blockstate.m_204336_(BlockTags.f_13073_) && !blockstate.m_204336_(BlockTags.f_13035_) && !blockstate.m_204336_(GenericBlockTags.Blocks.SWINGABLE)) continue;
            this.m_9236_().m_46953_(blockpos, false, (Entity)this);
        }
    }

    private void summonFloodParticle() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.FLOOD_BLOOD_SPLASH.get()), this.m_20208_(0.25), this.m_20187_() + 0.25, this.m_20262_(0.25), 3, 0.1, 0.2, 0.1, ParticleUtils.getDownwardsSmallSpread((RandomSource)this.f_19796_));
        }
    }

    public void m_8119_() {
        float f;
        super.m_8119_();
        if (this.m_20096_() && !this.isInFluidType() && this.f_267362_.m_267731_() > 0.1f && ((Boolean)DawnOfTheFloodConfig.SERVER.juggernaut_form_tremble_walk.get()).booleanValue() && (double)Math.abs(f = (float)Math.cos(this.f_267362_.m_267756_() * 0.8f - 1.5f)) < 0.2) {
            if (PerformanceEngine.canPerformShake((LivingEntity)this, this.m_9236_(), 12.0)) {
                ScreenShakeUtils.ScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)PerformanceEngine.getShakeRadius(12), (float)0.021f, (int)3, (int)2);
            }
            this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SoundRegistry.HEAVY_STEP.get(), SoundSource.HOSTILE, 1.35f, 1.0f);
        }
        if (this.m_5448_() != null && ((Boolean)DawnOfTheFloodConfig.SERVER.juggernaut_form_aggro_despawn.get()).booleanValue()) {
            this.setAggroTicks(this.getAggroTicks() + 1);
        }
        if (!this.m_9236_().f_46443_) {
            this.m_21195_(MobEffects.f_19614_);
        }
        if (this.getRoarTimer() > 0 && !this.isImmobile) {
            this.isImmobile = true;
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_(0.0);
        }
        if (this.getRoarTimer() == 0 && this.isImmobile) {
            this.isImmobile = false;
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_(0.22);
        }
        if (this.m_5448_() != null && this.getAngerCap() == 10 && this.getRoarTimer() == 0) {
            this.setRoarTimer(67);
        }
        if (this.m_5448_() != null && this.getAngerCap() == 10) {
            this.setAngerCap(0);
        }
        if (this.getRoarTimer() > 0) {
            this.summonFloodParticle();
        }
        if (this.attackID != 0) {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_(0.0);
        } else {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_(0.22);
        }
        if (this.getRoarTimer() == 45) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundRegistry.JUGGERNAUT_ROAR.get(), this.m_5720_(), this.getVolume() + 0.65f, this.getPitch(this.f_19796_) - 0.25f);
            if (((Boolean)DawnOfTheFloodConfig.SERVER.base_form_screen_shake.get()).booleanValue()) {
                ScreenShakeUtils.ScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)PerformanceEngine.getShakeRadius(16), (float)0.24f, (int)29, (int)14);
            }
        }
        if (this.getRoarTimer() == 1 && this.m_5448_() != null) {
            this.attackID = 3;
        }
        if (this.attackID != 0) {
            this.f_20883_ = this.f_20885_;
            this.m_146922_(this.f_20883_);
            ++this.attacktick;
            if (this.m_5448_() != null) {
                this.m_21563_().m_24960_((Entity)this.m_5448_(), 30.0f, 90.0f);
            }
        }
        if (this.canRegenerate() && ((Boolean)DawnOfTheFloodConfig.SERVER.juggernaut_form_regeneration.get()).booleanValue() && this.m_217043_().m_188503_(170) == 0 && (double)this.m_21223_() < (double)this.m_21233_() - 3.0) {
            this.m_5634_(1.5f);
        }
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity p_20971_) {
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        Arrow arrow;
        Entity entity;
        if (this.m_5448_() != null && this.attackID == 0 && this.getAngerCap() < 10) {
            this.setAngerCap(this.getAngerCap() + 1);
        }
        if ((entity = pSource.m_7640_()) instanceof Arrow && ((arrow = (Arrow)entity).m_19749_() instanceof PlayerFormEntity || arrow.m_19749_() instanceof PillagerFormEntity)) {
            return false;
        }
        if (pSource.m_7640_() instanceof AbstractBullet) {
            return false;
        }
        if (pSource.m_7640_() instanceof IronAxeEntity) {
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    public boolean canRegenerate() {
        return !this.m_6060_();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        RandomSource randomsource = pLevel.m_213780_();
        this.m_213945_(randomsource, pDifficulty);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        this.randomizeScale(3.0f);
        return super.m_6518_(pLevel, pDifficulty, pReason, spawnGroupData, compoundTag);
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return pDistanceToClosestPlayer > 16384.0 || this.getAggroTicks() < (Integer)DawnOfTheFloodConfig.SERVER.juggernaut_form_aggro_ticks.get();
    }

    class JuggernautFormBashAttackGoal
    extends Goal {
        private final JuggernautFormEntity juggernautFormEntity;
        private LivingEntity attackTarget;

        public JuggernautFormBashAttackGoal(JuggernautFormEntity juggernautFormEntity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.juggernautFormEntity = juggernautFormEntity;
        }

        public boolean m_8036_() {
            this.attackTarget = this.juggernautFormEntity.m_5448_();
            return this.attackTarget != null && this.juggernautFormEntity.attackID == 1 && !JuggernautFormEntity.this.isImmobile;
        }

        public void m_8056_() {
            this.juggernautFormEntity.setAttackID(1);
            Objects.requireNonNull(this.juggernautFormEntity.m_21051_(Attributes.f_22279_)).m_22100_(0.0);
        }

        public void m_8041_() {
            this.juggernautFormEntity.setAttackID(0);
            this.attackTarget = null;
            Objects.requireNonNull(this.juggernautFormEntity.m_21051_(Attributes.f_22279_)).m_22100_(0.22);
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8045_() {
            return this.juggernautFormEntity.attacktick < 21;
        }

        public void m_8037_() {
            if (JuggernautFormEntity.this.attacktick == 4) {
                float f1 = (float)Math.cos(Math.toRadians(JuggernautFormEntity.this.m_146908_() + 90.0f));
                float f2 = (float)Math.sin(Math.toRadians(JuggernautFormEntity.this.m_146908_() + 90.0f));
                JuggernautFormEntity.this.m_5997_((double)f1 * 0.1, 0.0, (double)f2 * 0.1);
            }
            if (JuggernautFormEntity.this.attacktick == 10) {
                float volume = 1.15f;
                float pitch = 0.35f;
                this.juggernautFormEntity.m_9236_().m_5594_(null, this.juggernautFormEntity.m_20183_(), (SoundEvent)SoundRegistry.ENTITY_SWING.get(), SoundSource.HOSTILE, volume, pitch);
            }
            if (JuggernautFormEntity.this.attacktick == 13) {
                JuggernautFormEntity.this.destroySwingable();
                JuggernautFormEntity.this.sweep((Entity)this.attackTarget);
                if (JuggernautFormEntity.this.m_20270_((Entity)this.attackTarget) <= 4.2f) {
                    Player player;
                    LivingEntity livingEntity;
                    this.attackTarget.m_6469_(JuggernautFormEntity.this.getDamage(), (float)JuggernautFormEntity.this.m_21133_(Attributes.f_22281_) * 0.7f);
                    if (this.attackTarget.m_6084_() && (livingEntity = this.attackTarget) instanceof Player && (player = (Player)livingEntity).m_21254_() && Math.random() <= 0.75) {
                        player.m_36384_(true);
                    }
                }
            }
            JuggernautFormEntity.this.m_21573_().m_26569_();
        }
    }

    class JuggernautFormStabAttackGoal
    extends Goal {
        private final JuggernautFormEntity juggernautFormEntity;
        private LivingEntity attackTarget;

        public JuggernautFormStabAttackGoal(JuggernautFormEntity juggernautFormEntity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.juggernautFormEntity = juggernautFormEntity;
        }

        public boolean m_8036_() {
            this.attackTarget = this.juggernautFormEntity.m_5448_();
            return this.attackTarget != null && this.juggernautFormEntity.attackID == 2 && !JuggernautFormEntity.this.isImmobile;
        }

        public void m_8056_() {
            this.juggernautFormEntity.setAttackID(2);
            Objects.requireNonNull(this.juggernautFormEntity.m_21051_(Attributes.f_22279_)).m_22100_(0.0);
        }

        public void m_8041_() {
            this.juggernautFormEntity.setAttackID(0);
            this.attackTarget = null;
            Objects.requireNonNull(this.juggernautFormEntity.m_21051_(Attributes.f_22279_)).m_22100_(0.22);
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8045_() {
            return this.juggernautFormEntity.attacktick < 23;
        }

        public void m_8037_() {
            if (JuggernautFormEntity.this.attacktick == 5) {
                JuggernautFormEntity.this.f_20883_ = JuggernautFormEntity.this.f_20885_;
                float f1 = (float)Math.cos(Math.toRadians(JuggernautFormEntity.this.m_146908_() + 90.0f));
                float f2 = (float)Math.sin(Math.toRadians(JuggernautFormEntity.this.m_146908_() + 90.0f));
                JuggernautFormEntity.this.m_5997_((double)f1 * 0.1, 0.0, (double)f2 * 0.1);
            }
            if (JuggernautFormEntity.this.attacktick == 11) {
                float volume = 1.15f;
                float pitch = 0.35f;
                this.juggernautFormEntity.m_9236_().m_5594_(null, this.juggernautFormEntity.m_20183_(), (SoundEvent)SoundRegistry.ENTITY_SWING.get(), SoundSource.HOSTILE, volume, pitch);
            }
            if (JuggernautFormEntity.this.attacktick == 15) {
                JuggernautFormEntity.this.destroySwingable();
                if (JuggernautFormEntity.this.m_20270_((Entity)this.attackTarget) <= 4.7f) {
                    this.attackTarget.m_6469_(JuggernautFormEntity.this.getDamage(), (float)JuggernautFormEntity.this.m_21133_(Attributes.f_22281_));
                    if (this.attackTarget.m_6084_()) {
                        Player player;
                        double dx = MathUtils.sin((float)MathUtils.APPROX_PI) * 2.05f;
                        double dz = this.attackTarget.m_20189_();
                        double strength = 2.35f;
                        this.attackTarget.m_147240_(strength, dx, dz);
                        LivingEntity livingEntity = this.attackTarget;
                        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_21254_()) {
                            player.m_36384_(true);
                        }
                    }
                }
            }
            JuggernautFormEntity.this.m_21573_().m_26569_();
        }
    }

    class JuggernautFormSlamAttackGoal
    extends Goal {
        private final JuggernautFormEntity juggernautFormEntity;
        private LivingEntity attackTarget;

        public JuggernautFormSlamAttackGoal(JuggernautFormEntity juggernautFormEntity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.juggernautFormEntity = juggernautFormEntity;
        }

        public boolean m_8036_() {
            this.attackTarget = this.juggernautFormEntity.m_5448_();
            return this.attackTarget != null && this.juggernautFormEntity.attackID == 3 && !JuggernautFormEntity.this.isImmobile;
        }

        public void m_8056_() {
            this.juggernautFormEntity.setAttackID(3);
            Objects.requireNonNull(this.juggernautFormEntity.m_21051_(Attributes.f_22279_)).m_22100_(0.0);
        }

        public void m_8041_() {
            this.juggernautFormEntity.setAttackID(0);
            this.attackTarget = null;
            Objects.requireNonNull(this.juggernautFormEntity.m_21051_(Attributes.f_22279_)).m_22100_(0.22);
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8045_() {
            return this.juggernautFormEntity.attacktick < 40;
        }

        public boolean same(int value) {
            return JuggernautFormEntity.this.attacktick == value;
        }

        public void m_8037_() {
            if (this.same(8) || this.same(11) || this.same(18) || this.same(21) || this.same(27) || this.same(30) || this.same(36)) {
                JuggernautFormEntity.this.destroySwingable();
                ScreenShakeUtils.ScreenShake((Level)JuggernautFormEntity.this.m_9236_(), (Vec3)JuggernautFormEntity.this.m_20182_(), (float)PerformanceEngine.getShakeRadius(16), (float)0.14f, (int)5, (int)3);
                this.juggernautFormEntity.m_9236_().m_5594_(null, this.juggernautFormEntity.m_20183_(), (SoundEvent)SoundRegistry.HEAVY_STEP.get(), SoundSource.BLOCKS, 4.0f, 0.9f);
                BlockUtils.moveTrembleBlocks(JuggernautFormEntity.this.m_9236_(), 4, (LivingEntity)this.juggernautFormEntity, 0.1, 0.15, 0.1, false);
                JuggernautFormEntity.this.sweep((Entity)this.attackTarget);
                if (JuggernautFormEntity.this.m_20270_((Entity)this.attackTarget) <= 4.4f) {
                    Player player;
                    LivingEntity livingEntity;
                    this.juggernautFormEntity.m_9236_().m_5594_(null, this.juggernautFormEntity.m_20183_(), (SoundEvent)SoundRegistry.ENTITY_SWING.get(), SoundSource.HOSTILE, 1.25f, 0.35f);
                    this.attackTarget.m_6469_(JuggernautFormEntity.this.getDamage(), (float)JuggernautFormEntity.this.m_21133_(Attributes.f_22281_) * 0.7f);
                    if (this.attackTarget.m_6084_() && (livingEntity = this.attackTarget) instanceof Player && (player = (Player)livingEntity).m_21254_() && Math.random() <= 0.75) {
                        player.m_36384_(true);
                    }
                }
            }
            JuggernautFormEntity.this.m_21573_().m_26569_();
        }
    }
}

