/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.event.extra;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.teamabyssalofficial.registry.GameruleRegistry;
import net.teamabyssalofficial.util.PlayerVariableUtils;
import net.teamabyssalofficial.util.WorldDataUtils;

@Mod.EventBusSubscriber(modid="dotf")
public class PlayerPhaseEvent {
    @SubscribeEvent
    public static void PhaseEvent(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase == TickEvent.Phase.END && (player = event.player) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            player = event.player.m_9236_();
            if (player instanceof ServerLevel) {
                ServerLevel world = (ServerLevel)player;
                WorldDataUtils worldDataUtils = WorldDataUtils.getWorldDataRegistry(world);
                worldDataUtils.waveHandlerEvent(world, player2);
                PlayerVariableUtils playerVariableUtils = (PlayerVariableUtils)player2;
                player2.m_20331_(playerVariableUtils.isInvincible());
            }
        }
    }

    @SubscribeEvent
    public static void PointIncrementEvent(TickEvent.LevelTickEvent event) {
        Level level = event.level;
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            WorldDataUtils worldDataRegistry = WorldDataUtils.getWorldDataRegistry(world);
            worldDataRegistry.tick(world);
            if (event.phase == TickEvent.Phase.END) {
                int currentWave = worldDataRegistry.getWave();
                int currentScore = worldDataRegistry.getScore();
                int main_score = currentWave * 3 + currentWave * currentWave * currentWave + 2;
                main_score *= world.m_46791_().m_19028_();
                if (Math.random() <= (double)0.01994f) {
                    worldDataRegistry.setScore(currentScore + main_score);
                }
                if (world.m_6106_().m_5470_().m_46207_(GameruleRegistry.CONSTANT_ZERO_WAVE_POINTS) && currentScore != 0) {
                    worldDataRegistry.setScore(0);
                }
            }
        }
    }

    @SubscribeEvent
    public static void SleepEvent(PlayerSleepInBedEvent event) {
        Player player;
        if (event.getEntity() != null && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            WorldDataUtils worldDataRegistry = WorldDataUtils.getWorldDataRegistry((ServerLevel)player2.m_9236_());
            int currentWave = worldDataRegistry.getWave();
            int currentScore = worldDataRegistry.getScore();
            int addScore = 360 * (currentWave + 1);
            worldDataRegistry.setScore(currentScore + addScore);
        }
    }
}

