/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.guns.event;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.teamabyssalofficial.annotation.MainMethod;
import net.teamabyssalofficial.dotf.config.DawnOfTheFloodConfig;
import net.teamabyssalofficial.guns.gun.GunItem;
import net.teamabyssalofficial.guns.helper.GunCrosshairType;
import net.teamabyssalofficial.util.PlayerVariableUtils;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="dotf")
public class RenderCrosshairEvent {
    @SubscribeEvent(receiveCanceled=true)
    public static void onRenderOverlay(RenderGuiOverlayEvent.Pre event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        PlayerVariableUtils playerVariableUtils = (PlayerVariableUtils)player;
        if (playerVariableUtils.hasHudHidden()) {
            event.setCanceled(true);
            return;
        }
        if (event.getOverlay().id().equals((Object)VanillaGuiOverlay.CROSSHAIR.id())) {
            if (!((Boolean)DawnOfTheFloodConfig.SERVER.hasHaloCrosshairs.get()).booleanValue()) {
                ItemStack stack = player.m_21205_();
                if (!(stack.m_41720_() instanceof GunItem)) {
                    return;
                }
                if (!stack.m_41784_().m_128471_("isAiming")) {
                    return;
                }
                event.setCanceled(true);
            } else {
                ItemStack stack = player.m_21205_();
                GuiGraphics guiGraphics = event.getGuiGraphics();
                Window window = event.getWindow();
                boolean flag = (Boolean)DawnOfTheFloodConfig.SERVER.keepNormalMCCrosshair.get();
                if (!stack.m_41784_().m_128471_("isAiming")) {
                    Item item = stack.m_41720_();
                    if (item instanceof GunItem) {
                        GunItem gunItem = (GunItem)item;
                        RenderCrosshairEvent.renderCrosshair(guiGraphics, window, stack.m_41720_());
                    } else if (!flag) {
                        RenderCrosshairEvent.renderDefaultCrosshair(guiGraphics, window, stack.m_41720_());
                    } else {
                        return;
                    }
                }
                event.setCanceled(true);
            }
        }
    }

    @MainMethod
    private static void renderCrosshair(GuiGraphics graphics, Window window, Item item) {
        Options options = Minecraft.m_91087_().f_91066_;
        if (!options.m_92176_().m_90612_()) {
            return;
        }
        if (options.f_92062_) {
            return;
        }
        MultiPlayerGameMode gameMode = Minecraft.m_91087_().f_91072_;
        if (gameMode == null) {
            return;
        }
        if (gameMode.m_105295_() == GameType.SPECTATOR) {
            return;
        }
        if (!(item instanceof GunItem)) {
            return;
        }
        GunItem gunItem = (GunItem)item;
        int width = window.m_85445_();
        int height = window.m_85446_();
        ResourceLocation location = Minecraft.m_91087_().f_91076_ != null ? GunCrosshairType.getTextureLocationRed(gunItem) : GunCrosshairType.getTextureLocation(gunItem);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.9f);
        float x = (float)width / 2.0f - 8.0f;
        float y = (float)height / 2.0f - 8.0f;
        graphics.m_280163_(location, (int)x, (int)y, 0.0f, 0.0f, 16, 16, 16, 16);
    }

    @MainMethod
    private static void renderDefaultCrosshair(GuiGraphics graphics, Window window, Item item) {
        if (!((Boolean)DawnOfTheFloodConfig.SERVER.hasHaloCrosshairs.get()).booleanValue()) {
            return;
        }
        Options options = Minecraft.m_91087_().f_91066_;
        if (!options.m_92176_().m_90612_()) {
            return;
        }
        if (options.f_92062_) {
            return;
        }
        MultiPlayerGameMode gameMode = Minecraft.m_91087_().f_91072_;
        if (gameMode == null) {
            return;
        }
        if (gameMode.m_105295_() == GameType.SPECTATOR) {
            return;
        }
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            return;
        }
        int width = window.m_85445_();
        int height = window.m_85446_();
        ResourceLocation location = Minecraft.m_91087_().f_91076_ != null ? new ResourceLocation("dotf", "textures/visual/minecraft_crosshair_red.png") : new ResourceLocation("dotf", "textures/visual/minecraft_crosshair.png");
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.9f);
        float x = (float)width / 2.0f - 8.0f;
        float y = (float)height / 2.0f - 8.0f;
        graphics.m_280163_(location, (int)x, (int)y, 0.0f, 0.0f, 16, 16, 16, 16);
    }
}

