/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.Message;

import java.util.function.Supplier;
import net.miauczel.legendary_monsters.entity.IAnimatedMonster;
import net.miauczel.legendary_monsters.sound.BossMusicPlayer;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class PlayBossMusicMessage {
    private final int entityID;
    private final boolean play;

    public PlayBossMusicMessage(int bossBar, boolean canPlay) {
        this.entityID = bossBar;
        this.play = canPlay;
    }

    public static PlayBossMusicMessage read(FriendlyByteBuf buf) {
        return new PlayBossMusicMessage(buf.readInt(), buf.readBoolean());
    }

    public static void write(PlayBossMusicMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.entityID);
        buf.writeBoolean(message.play);
    }

    public static class Handler {
        public static boolean onMessage(PlayBossMusicMessage message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(message.entityID);
                if (entity instanceof IAnimatedMonster) {
                    IAnimatedMonster am = (IAnimatedMonster)entity;
                    if (message.play) {
                        BossMusicPlayer.playBossMusic(am);
                    } else {
                        BossMusicPlayer.stopBossMusic(am);
                    }
                }
            });
            ctx.get().setPacketHandled(true);
            return true;
        }
    }
}

