/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.ai;

import net.miauczel.legendary_monsters.config.ModConfig;
import net.miauczel.legendary_monsters.effect.ModEffects;
import net.miauczel.legendary_monsters.entity.CameraShakeEntity;
import net.miauczel.legendary_monsters.entity.custom.Withered_AbominationEntity;
import net.miauczel.legendary_monsters.sound.ModSounds;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class Withered_AbominationAttackGoal
extends MeleeAttackGoal {
    private final Withered_AbominationEntity entity;
    private int attackDelay = 20;
    private int ticksUntilNextAttack = 20;
    private boolean shouldCountTillNextAttack = false;

    public Withered_AbominationAttackGoal(PathfinderMob pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
        super(pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
        this.entity = (Withered_AbominationEntity)pMob;
    }

    public void m_8056_() {
        super.m_8056_();
        this.attackDelay = 20;
        this.ticksUntilNextAttack = 20;
    }

    protected boolean canEntitySee(Withered_AbominationEntity entity, LivingEntity targetEntity) {
        Vec3 mobEyes = entity.m_20299_(1.0f);
        Vec3 targetEyes = targetEntity.m_20299_(1.0f);
        BlockHitResult hitResult = entity.m_9236_().m_45547_(new ClipContext(mobEyes, targetEyes, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity));
        return hitResult.m_6662_() == HitResult.Type.MISS;
    }

    protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
        if (this.isEnemyWithinAttackDistance(pEnemy, pDistToEnemySqr)) {
            this.shouldCountTillNextAttack = true;
            if (this.isTimeToStartAttackAnimation()) {
                // empty if block
            }
            if (this.m_25564_()) {
                this.f_25540_.m_21563_().m_24946_(pEnemy.m_20185_(), pEnemy.m_20188_(), pEnemy.m_20189_());
                this.performAttack(pEnemy);
            }
        } else {
            this.m_25563_();
            this.shouldCountTillNextAttack = false;
        }
    }

    protected boolean isEnemyWithinAttackDistance(LivingEntity enemy, double distanceSquared) {
        double horizontalAttackDistance = 6.0;
        double verticalAttackDistance = 6.0;
        double xDistance = enemy.m_20185_() - this.entity.m_20185_();
        double yDistance = enemy.m_20186_() - this.entity.m_20186_();
        double zDistance = enemy.m_20189_() - this.entity.m_20189_();
        return xDistance * xDistance + zDistance * zDistance <= horizontalAttackDistance * horizontalAttackDistance && Math.abs(yDistance) <= verticalAttackDistance;
    }

    protected void m_25563_() {
        this.ticksUntilNextAttack = this.m_183277_(this.attackDelay * 2);
    }

    protected boolean m_25564_() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected boolean isTimeToStartAttackAnimation() {
        return this.ticksUntilNextAttack <= this.attackDelay;
    }

    protected int m_25565_() {
        return this.ticksUntilNextAttack;
    }

    protected void performAttack(LivingEntity pEnemy) {
        Player player;
        this.m_25563_();
        this.entity.performAreaAttack();
        if (pEnemy instanceof Player || pEnemy instanceof ServerPlayer) {
            this.entity.attackTargets((Entity)pEnemy);
        } else {
            this.f_25540_.m_7327_((Entity)pEnemy);
        }
        Vec3 entityPosition = this.f_25540_.m_5448_().m_20182_();
        CameraShakeEntity.cameraShake(this.f_25540_.m_5448_().m_9236_(), entityPosition, 20.0f, 0.2f, 0, 20);
        if (this.f_25540_.m_5448_().m_21254_() && this.entity.canStun()) {
            this.entity.resetStunCooldown();
        }
        if (((Boolean)ModConfig.MOB_CONFIG.AllowWitheredAbominationStun.get()).booleanValue() && !this.f_25540_.m_5448_().m_21023_((MobEffect)ModEffects.STUN.get()) && !this.f_25540_.m_5448_().m_21254_() && this.entity.canStun()) {
            this.entity.resetStunCooldown();
            this.f_25540_.m_5448_().m_7292_(new MobEffectInstance((MobEffect)ModEffects.STUN.get(), 40, 0));
        }
        if (this.f_25540_.m_5448_() != null) {
            this.f_25540_.m_5448_().m_20256_(new Vec3(0.0, 0.75, 0.0));
            if (!this.f_25540_.m_5448_().m_21254_()) {
                this.f_25540_.m_5448_().m_7292_(new MobEffectInstance(MobEffects.f_19615_, 60, 2));
            }
        }
        SoundEvent customAttackSound = (SoundEvent)ModSounds.ENDERSENT_ATTACK.get();
        this.f_25540_.m_9236_().m_5594_(null, this.f_25540_.m_20183_(), customAttackSound, SoundSource.NEUTRAL, 1.0f, 1.0f);
        if (pEnemy instanceof Player && (player = (Player)pEnemy).m_21254_() && (player.m_21205_().m_41720_() instanceof ShieldItem || player.m_21206_().m_41720_() instanceof ShieldItem)) {
            Item shieldItem;
            Item item = shieldItem = player.m_21205_().m_41720_() instanceof ShieldItem ? player.m_21205_().m_41720_() : player.m_21206_().m_41720_();
            if (!player.m_36335_().m_41519_(shieldItem)) {
                player.m_36335_().m_41524_(shieldItem, 70);
                if (player.m_21254_()) {
                    player.m_5810_();
                }
            }
        }
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.shouldCountTillNextAttack) {
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        }
    }

    public void m_8041_() {
        super.m_8041_();
    }
}

