/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.custom;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.miauczel.legendary_monsters.Particle.custom.Circle;
import net.miauczel.legendary_monsters.entity.ModEntities;
import net.miauczel.legendary_monsters.entity.custom.Cloud_GolemEntity;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class LightningBoltEntity
extends Entity {
    private int warmupDelayTicks;
    private boolean sentSpikeEvent;
    private int lifeTicks = 35;
    private boolean clientSideAttackStarted;
    private LivingEntity caster;
    private UUID casterUuid;
    private Entity caster2;
    private UUID casterUuid2;
    private static final EntityDataAccessor<Float> LIFE = SynchedEntityData.m_135353_(LightningBoltEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(LightningBoltEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Optional<UUID>> CASTER2_UUID = SynchedEntityData.m_135353_(LightningBoltEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public float activateProgress;
    public float prevactivateProgress;
    public float heightAB;
    public boolean ParticleAppeared = false;
    private static final EntityDataAccessor<Boolean> ATTACK = SynchedEntityData.m_135353_(LightningBoltEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public LightningBoltEntity(EntityType<? extends LightningBoltEntity> p_i50170_1_, Level p_i50170_2_) {
        super(p_i50170_1_, p_i50170_2_);
    }

    public LightningBoltEntity(Level worldIn, double x, double y, double z, float p_i47276_8_, int p_i47276_9_, LivingEntity casterIn, int life, float setDamage) {
        this((EntityType<? extends LightningBoltEntity>)((EntityType)ModEntities.L.get()), worldIn);
        this.warmupDelayTicks = p_i47276_9_;
        this.setCaster(casterIn);
        this.setCaster2(this.caster2);
        this.setDamage(setDamage);
        this.lifeTicks = life;
        this.m_146922_(p_i47276_8_ * 57.295776f);
        this.m_6034_(x, y, z);
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public float getLife() {
        return ((Float)this.f_19804_.m_135370_(LIFE)).floatValue();
    }

    public void setLifeTicks(float lifeTicks) {
        this.f_19804_.m_135381_(LIFE, (Object)Float.valueOf(lifeTicks));
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(damage));
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(LIFE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ATTACK, (Object)false);
        this.f_19804_.m_135372_(CASTER2_UUID, Optional.empty());
    }

    public void setCaster(@Nullable LivingEntity p_190549_1_) {
        this.caster = p_190549_1_;
        this.casterUuid = p_190549_1_ == null ? null : p_190549_1_.m_20148_();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    public void setCaster2(@Nullable Entity caster2) {
        this.caster2 = caster2;
        this.casterUuid2 = caster2 == null ? null : caster2.m_20148_();
        this.f_19804_.m_135381_(CASTER2_UUID, Optional.ofNullable(this.casterUuid2));
        System.out.println("setCaster2 called. Server side: " + !this.m_9236_().f_46443_ + ". Caster2: " + (caster2 != null ? caster2.m_7755_().getString() : "null"));
    }

    @Nullable
    public Entity getCaster2() {
        Level level;
        Optional optionalUuid;
        if (this.caster2 == null && (optionalUuid = (Optional)this.f_19804_.m_135370_(CASTER2_UUID)).isPresent() && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Entity entity = serverLevel.m_8791_((UUID)optionalUuid.get());
            if (entity != null) {
                this.caster2 = entity;
                System.out.println("Client-side: Found caster2 with UUID: " + optionalUuid.get());
            } else {
                System.out.println("Client-side: Could not find caster2 with UUID: " + optionalUuid.get());
            }
        }
        return this.caster2;
    }

    protected void m_7378_(CompoundTag compound) {
        this.warmupDelayTicks = compound.m_128451_("Warmup");
        if (compound.m_128403_("Owner")) {
            this.casterUuid = compound.m_128342_("Owner");
        }
        if (compound.m_128403_("Caster2")) {
            this.casterUuid2 = compound.m_128342_("Caster2");
            this.f_19804_.m_135381_(CASTER2_UUID, Optional.of(this.casterUuid2));
        }
    }

    protected void m_7380_(CompoundTag compound) {
        if (this.casterUuid2 != null) {
            compound.m_128362_("Caster2", this.casterUuid2);
        }
        compound.m_128405_("Warmup", this.warmupDelayTicks);
        if (this.casterUuid != null) {
            compound.m_128362_("Owner", this.casterUuid);
        }
    }

    public float GetH() {
        return this.heightAB;
    }

    public boolean GetHH() {
        return this.heightAB > 0.0f;
    }

    public void setH(float h) {
        this.heightAB = h;
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        ServerLevel serverLevel;
        Entity entity;
        Level level;
        Optional optionalUuid;
        super.m_7350_(key);
        if (key.equals(CASTER2_UUID) && (optionalUuid = (Optional)this.f_19804_.m_135370_(CASTER2_UUID)).isPresent() && (level = this.m_9236_()) instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)level).m_8791_((UUID)optionalUuid.get())) != null) {
            this.caster2 = entity;
            System.out.println("Updated caster2 with UUID: " + optionalUuid.get());
        }
    }

    public int getLifeTicks() {
        return this.lifeTicks;
    }

    public void m_8119_() {
        if (this.lifeTicks != 20 || !this.m_20067_()) {
            // empty if block
        }
        super.m_8119_();
        this.prevactivateProgress = this.activateProgress;
        if (this.isActivate() && this.activateProgress > 0.0f) {
            this.activateProgress -= 1.0f;
        }
        if (this.m_9236_().f_46443_ && this.clientSideAttackStarted && !this.ParticleAppeared) {
            this.m_9236_().m_7106_((ParticleOptions)new Circle.RingData(0.0f, 1.5707964f, 30, 0.9f, 0.89f, 1.0f, 1.0f, 15.0f, false, Circle.EnumRingBehavior.GROW), this.m_20185_(), this.m_20186_() + (double)0.1f, this.m_20189_(), 0.0, 0.0, 0.0);
            this.ParticleAppeared = true;
        }
        if (this.m_9236_().f_46443_) {
            if (this.clientSideAttackStarted) {
                if (!this.m_20067_()) {
                    // empty if block
                }
                --this.lifeTicks;
                if (!this.isActivate() && this.activateProgress < 10.0f) {
                    this.activateProgress += 1.0f;
                }
                if (this.lifeTicks == 37) {
                    for (int i = 0; i < 80; ++i) {
                        BlockState block = this.m_9236_().m_8055_(this.m_20183_().m_7495_());
                        double d0 = this.m_20185_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
                        double d1 = this.m_20186_() + 0.03;
                        double d2 = this.m_20189_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
                        double d3 = this.f_19796_.m_188583_() * 0.07;
                        double d4 = this.f_19796_.m_188583_() * 0.07;
                        double d5 = this.f_19796_.m_188583_() * 0.07;
                        this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block), d0, d1, d2, d3, d4, d5);
                    }
                }
                if (this.lifeTicks == 6) {
                    this.setActivate(true);
                }
            }
        } else if (--this.warmupDelayTicks < 0) {
            if (this.warmupDelayTicks == -5 && this.isActivate()) {
                this.setActivate(false);
            }
            if (this.warmupDelayTicks < -5 && this.warmupDelayTicks > -30) {
                for (LivingEntity livingentity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(0.2, 6.0, 0.2))) {
                    this.damage(livingentity);
                }
            }
            if (!this.sentSpikeEvent) {
                this.m_9236_().m_7605_((Entity)this, (byte)4);
                this.sentSpikeEvent = true;
            }
            if (--this.lifeTicks < 0) {
                this.m_146870_();
            }
        }
    }

    public boolean isActivate() {
        return (Boolean)this.f_19804_.m_135370_(ATTACK);
    }

    public void setActivate(boolean Activate) {
        this.f_19804_.m_135381_(ATTACK, (Object)Activate);
    }

    private void damage(LivingEntity ImpactEntity) {
        LivingEntity livingentity = this.getCaster();
        if (ImpactEntity.m_6084_() && !ImpactEntity.m_20147_() && ImpactEntity != livingentity && this.f_19797_ % 5 == 0) {
            if (livingentity == null) {
                DamageSource damageSource = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268530_), (Entity)livingentity);
                if (this.getCaster() instanceof Cloud_GolemEntity) {
                    ImpactEntity.m_6469_(damageSource, this.getDamage());
                } else {
                    ImpactEntity.m_6469_(damageSource, this.getDamage());
                }
            } else {
                if (livingentity.m_7307_((Entity)ImpactEntity)) {
                    return;
                }
                DamageSource damageSource = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268530_), (Entity)livingentity);
                if (this.getCaster() instanceof Cloud_GolemEntity) {
                    ImpactEntity.m_6469_(damageSource, this.getDamage());
                } else {
                    ImpactEntity.m_6469_(damageSource, this.getDamage());
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        super.m_7822_(id);
        if (id == 4) {
            this.clientSideAttackStarted = true;
        }
    }

    public float m_213856_() {
        return 1.0f;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (this.m_9236_().f_46443_) {
            System.out.println("ThunderCloud added to client world");
        } else {
            System.out.println("ThunderCloud added to server world");
        }
    }

    public float getAnimationProgress(float pPartialTicks) {
        if (!this.clientSideAttackStarted) {
            return 0.0f;
        }
        int $$1 = this.lifeTicks - 2;
        return $$1 <= 0 ? 1.0f : 1.0f - ((float)$$1 - pPartialTicks) / 20.0f;
    }
}

