/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.custom;

import java.util.List;
import java.util.function.DoubleSupplier;
import net.miauczel.legendary_monsters.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;

public class MiniSkeletosaurusEntity
extends TamableAnimal
implements PlayerRideableJumping {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(MiniSkeletosaurusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int cooldown = 0;
    private static final int COOLDOWN_DURATION = 40;
    private static final float MAX_ROTATION = 0.0f;
    private static final float ROTATION_SPEED = 0.2f;
    private int walkAnimationTickCounter = 0;
    private static final int MESSAGE_INTERVAL = 15;
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    public final AnimationState attackAnimationState = new AnimationState();
    public int attackAnimationTimeout = 0;
    private float prevYaw;
    private int regenerationCooldown = 30;
    private double lastY = 0.0;
    private boolean reduceFallDamage = false;
    protected int gallopSoundCounter;
    protected boolean canGallop = true;
    private double lastJumpHeight = 0.0;
    protected boolean isJumping;
    protected float playerJumpPendingScale;
    protected boolean allowStandSliding;
    private int standCounter;

    public MiniSkeletosaurusEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 10;
        this.m_21557_(false);
        this.m_21530_();
    }

    public void m_8119_() {
        LivingEntity forward2;
        Player player;
        LivingEntity livingEntity;
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.f_19797_ % this.regenerationCooldown == 0 && this.m_21223_() < this.m_21233_()) {
            this.m_5634_(1.0f);
        }
        if (this.m_20160_() && (livingEntity = this.m_6688_()) instanceof Player) {
            player = (Player)livingEntity;
            if (this.m_20186_() < this.lastJumpHeight && !this.m_20096_()) {
                this.reduceFallDamage = true;
            }
        }
        if (this.m_20096_()) {
            this.reduceFallDamage = false;
        }
        if (this.m_20160_() && (livingEntity = this.m_6688_()) instanceof Player) {
            player = (Player)livingEntity;
            this.f_19859_ = player.f_19859_;
            this.f_19859_ = player.f_19859_;
            this.m_146922_(this.f_19859_);
            this.m_5618_(this.f_19859_);
            float forward2 = player.f_20902_;
            float strafe = player.f_20900_;
            if (this.m_20160_() && this.m_6688_() instanceof Player) {
                this.m_7910_((float)this.m_21051_(Attributes.f_22279_).m_22135_() + 0.15f);
            } else {
                this.m_21051_(Attributes.f_22279_).m_22100_(0.1);
            }
            super.m_7023_(new Vec3((double)strafe, 0.0, (double)forward2));
        }
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
        this.handleWalkingMessage();
        if (this.m_20160_() && (forward2 = this.m_6688_()) instanceof Player) {
            player = (Player)forward2;
            if (!this.m_20096_()) {
                double fallDistance = this.lastY - this.m_20186_();
                this.reduceFallDamage = fallDistance < 10.0 && fallDistance > 0.0;
            }
        }
        if (this.m_20096_()) {
            this.reduceFallDamage = false;
        }
        this.lastY = this.m_20186_();
    }

    private void handleWalkingMessage() {
        if (this.isMoving()) {
            ++this.walkAnimationTickCounter;
            if (this.walkAnimationTickCounter >= 15) {
                this.walkAnimationTickCounter = 0;
                Vec3 vec3 = this.m_20182_();
            }
        } else {
            this.walkAnimationTickCounter = 0;
        }
    }

    private boolean isMoving() {
        return this.m_20184_().m_82556_() > 0.01;
    }

    private void sendMessageToAllPlayers(String message) {
        this.m_9236_().m_6907_().forEach(player -> {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.m_213846_((Component)Component.m_237113_((String)message));
            }
        });
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource source) {
        if (this.reduceFallDamage && fallDistance < 60.0f) {
            return false;
        }
        return super.m_142535_(fallDistance, damageMultiplier, source);
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.f_19796_.m_188503_(40) + 80;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.isAttacking() && this.attackAnimationTimeout <= 0) {
            this.attackAnimationTimeout = 19;
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.attackAnimationTimeout;
        }
        if (!this.isAttacking()) {
            this.attackAnimationState.m_216973_();
        }
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f));
        this.f_21345_.m_25352_(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 3.0));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public void m_8107_() {
        super.m_8107_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21183_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22279_, (double)0.1f).m_22268_(Attributes.f_22282_, 0.5).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22288_, 0.9);
    }

    protected void playGallopSound(SoundType pSoundType) {
        if (Math.random() < 0.5) {
            this.m_5496_((SoundEvent)ModSounds.STEP_SOUND.get(), pSoundType.m_56773_() * 0.15f, pSoundType.m_56774_());
        } else {
            this.m_5496_((SoundEvent)ModSounds.STEP_SOUND3.get(), pSoundType.m_56773_() * 0.15f, pSoundType.m_56774_());
        }
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        if (!pBlock.m_278721_()) {
            BlockState blockstate = this.m_9236_().m_8055_(pPos.m_7494_());
            SoundType soundtype = pBlock.getSoundType((LevelReader)this.m_9236_(), pPos, (Entity)this);
            if (blockstate.m_60713_(Blocks.f_50125_)) {
                soundtype = blockstate.getSoundType((LevelReader)this.m_9236_(), pPos, (Entity)this);
            }
            if (this.m_20160_() && this.canGallop) {
                ++this.gallopSoundCounter;
                if (this.gallopSoundCounter > 4 && this.gallopSoundCounter % 2 == 0) {
                    this.playGallopSound(soundtype);
                } else if (this.gallopSoundCounter <= 4) {
                    this.m_5496_(SoundEvents.f_12036_, soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
                }
            } else if (this.isWoodSoundType(soundtype)) {
                this.m_5496_(SoundEvents.f_12036_, soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
            } else {
                this.m_5496_(SoundEvents.f_12035_, soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
            }
        }
    }

    private boolean isWoodSoundType(SoundType pSoundType) {
        return pSoundType == SoundType.f_56736_ || pSoundType == SoundType.f_244244_ || pSoundType == SoundType.f_56763_ || pSoundType == SoundType.f_271497_ || pSoundType == SoundType.f_243772_;
    }

    protected float m_6108_() {
        return 0.96f;
    }

    public void performAreaAttack() {
        double attackRadius = 3.0;
        double attackHeight = 3.0;
        AABB attackBox = new AABB(this.m_20185_() - attackRadius, this.m_20186_(), this.m_20189_() - attackRadius, this.m_20185_() + attackRadius, this.m_20186_() + attackHeight, this.m_20189_() + attackRadius);
        List entities = this.m_9236_().m_45933_((Entity)this, attackBox);
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity) || entity == this) continue;
            this.m_7327_((Entity)((LivingEntity)entity));
        }
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        boolean var = true;
        int var2 = 2;
        ItemStack emerald = new ItemStack((ItemLike)Items.f_41852_, 1);
        emerald = this.getItemWithLootingEnchant(emerald, source.m_7639_());
        this.m_19983_(emerald);
    }

    private ItemStack getItemWithLootingEnchant(ItemStack stack, Entity killer) {
        int lootingLevel;
        if (killer instanceof Player && (lootingLevel = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44982_, (LivingEntity)((LivingEntity)killer))) > 0) {
            stack.m_41769_(lootingLevel);
        }
        return stack;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.m_21530_();
    }

    public boolean m_6094_() {
        return true;
    }

    public void m_6075_() {
        super.m_6075_();
        this.m_6210_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268468_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268671_) && this.reduceFallDamage && this.m_20160_()) {
            return false;
        }
        if (source.m_7640_() instanceof ThrownPotion || source.m_7640_() instanceof AreaEffectCloud) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
    }

    public boolean canBeControlledByRider() {
        return true;
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        return entity instanceof LivingEntity ? (LivingEntity)entity : null;
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_20160_() && this.m_6688_() instanceof Player) {
            LivingEntity livingentity = this.m_6688_();
            this.m_146922_(livingentity.m_146908_());
            this.f_19859_ = this.m_146908_();
            this.m_146926_(livingentity.m_146909_() * 0.5f);
            this.m_19915_(this.m_146908_(), this.m_146909_());
            this.f_20885_ = this.f_20883_ = this.m_146908_();
            float strafe = livingentity.f_20900_ * 0.5f;
            float forward = livingentity.f_20902_;
            if (forward <= 0.0f) {
                forward *= 0.25f;
            }
            if (this.m_20069_()) {
                this.m_19920_(0.02f, new Vec3((double)strafe, travelVector.f_82480_, (double)forward));
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_(0.8));
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            } else if (this.m_6109_()) {
                this.m_7910_((float)this.m_21051_(Attributes.f_22279_).m_22135_());
                super.m_7023_(new Vec3((double)strafe, travelVector.f_82480_, (double)forward));
            } else if (livingentity instanceof Player) {
                this.m_20256_(Vec3.f_82478_);
            }
        } else {
            super.m_7023_(travelVector);
        }
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6129_() {
        return true;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12423_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.SKELETOSAURUS_HURT3.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.SKELETOSAURUS_DEATH.get();
    }

    protected boolean canDespawn() {
        this.m_21530_();
        return true;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (this.m_6898_(itemstack)) {
            this.m_142075_(player, hand, itemstack);
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                this.m_21828_(player);
                this.m_21839_(true);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            this.m_21530_();
            return InteractionResult.CONSUME;
        }
        InteractionResult interactionresult1 = super.m_6071_(player, hand);
        if (interactionresult1.m_19077_()) {
            this.m_21530_();
            return interactionresult1;
        }
        if (this.m_9236_().f_46443_) {
            if (this.m_21824_() && this.m_21830_((LivingEntity)player) && !this.m_6162_()) {
                return InteractionResult.SUCCESS;
            }
            return !this.m_6898_(itemstack) || !(this.m_21223_() < this.m_21233_()) && this.m_21824_() ? InteractionResult.PASS : InteractionResult.SUCCESS;
        }
        if (!this.m_6162_() && (this.m_21830_((LivingEntity)player) || this.m_21824_())) {
            player.m_20329_((Entity)this);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return InteractionResult.PASS;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == Items.f_42579_;
    }

    @Nullable
    public ItemEntity LGspawnatlocation(ItemStack pStack) {
        pStack.m_41700_("Enchantments", (Tag)new ListTag());
        ItemEntity itemEntity = this.m_5552_(pStack, 0.0f);
        if (itemEntity != null) {
            itemEntity.m_146915_(true);
        }
        return itemEntity;
    }

    public boolean isJumping() {
        return this.isJumping;
    }

    public void setIsJumping(boolean pJumping) {
        this.isJumping = pJumping;
    }

    protected void playJumpSound() {
        this.m_5496_(SoundEvents.f_11979_, 0.4f, 1.0f);
    }

    public void m_7888_(int pJumpPower) {
        if (pJumpPower < 0) {
            pJumpPower = 0;
        } else {
            this.allowStandSliding = true;
            this.standIfPossible();
        }
        this.playerJumpPendingScale = pJumpPower >= 90 ? 1.0f : 0.4f + 0.4f * (float)pJumpPower / 90.0f;
    }

    public boolean m_7132_() {
        return true;
    }

    public void standIfPossible() {
    }

    public void m_7199_(int pJumpPower) {
        this.allowStandSliding = true;
        this.standIfPossible();
        this.playJumpSound();
    }

    public void m_8012_() {
    }

    public double getCustomJump() {
        return this.m_21133_(Attributes.f_22288_);
    }

    protected void m_274498_(Player pPlayer, Vec3 pTravelVector) {
        super.m_274498_(pPlayer, pTravelVector);
        if (this.m_20096_()) {
            this.setIsJumping(false);
            if (this.playerJumpPendingScale > 0.0f && !this.isJumping() && this.m_20096_()) {
                this.executeRidersJump(this.playerJumpPendingScale, pTravelVector);
            }
            this.playerJumpPendingScale = 0.0f;
        }
    }

    protected void executeRidersJump(float p_248808_, Vec3 p_275435_) {
        double d0 = this.getCustomJump() * (double)p_248808_ * (double)this.m_20098_();
        double d1 = d0 + (double)this.m_285755_();
        Vec3 vec3 = this.m_20184_();
        this.m_20334_(vec3.f_82479_, d1, vec3.f_82481_);
        this.setIsJumping(true);
        this.f_19812_ = true;
        ForgeHooks.onLivingJump((LivingEntity)this);
        if (p_275435_.f_82481_ > 0.0) {
            float f = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            float f1 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            this.m_20256_(this.m_20184_().m_82520_((double)(-0.4f * f * p_248808_), 0.0, (double)(0.4f * f1 * p_248808_)));
        }
    }

    protected static double generateJumpStrength(DoubleSupplier pSupplier) {
        return (double)0.4f + pSupplier.getAsDouble() * 0.2 + pSupplier.getAsDouble() * 0.2 + pSupplier.getAsDouble() * 0.2;
    }
}

